/*
 * Barber.cpp
 *
 *  Created on: 02.12.2009
 *      Author: ingmar
 */

#include "Clerk.h"
#include "Customer.h"

Clerk::Clerk(
		AgencySimulation& sim,
		double expectedValue,
		double variance
		):
		odemx::base::Process(sim, "Clerk"), sim(sim)
	 {

	//init the random generator
	random = new odemx::random::Normal(sim,"serviceTime", expectedValue, variance);
}

Clerk::~Clerk() {
}

int Clerk::main() {
	while (true) {

		//odemx::base::Process* process = sim.getCounterWaitQ()->coopt ( (odemx::base::Selection) &Clerk::suitableCustomer );

		odemx::base::Process* process = sim.getCounterWaitQ()->coopt ( (odemx::base::Weight) &Clerk::bestCustomer );

//		odemx::base::Process* process = sim.getCounterWaitQ()->avail( (odemx::base::Selection) &Clerk::onlyMyCustomer );
//
//		if (process == NULL) {
//			process = sim.getCounterWaitQ()->coopt ( (odemx::base::Selection) &Clerk::suitableCustomer );
//		} else {
//			std::cout << "good customer" << std::endl;
//		}


		Customer* customer = dynamic_cast<Customer*>(process);

		//if i see this one the first time
		if (customer->getClerk() == NULL)
			customer->setClerk(this);

		//now explain the form
		if (customer->getClerk() != this)
			holdFor(2* random->sample());
		else
			holdFor(random->sample());

		//send customer away for good or to fill out form
		customer->activateAfter(this);
	}
	return 0;
}

double Clerk::bestCustomer ( Process* partner ) {
	Customer* customer = dynamic_cast<Customer*>(partner);
	Clerk* clerk = customer->getClerk();
	if (clerk == NULL) {
		return 0.5;
	} else if (clerk == this) {
		return 1;
	} else {
		return 0.0;
	}
}

bool Clerk::suitableCustomer (odemx::base::Process* partner) {
	Customer* customer = dynamic_cast<Customer*>(partner);
	Clerk* clerk = customer->getClerk();
	if (clerk == NULL || clerk == this) {
		return true;
	} else {
		return false;
	}
}

bool Clerk::onlyMyCustomer(odemx::base::Process* partner) {
	Customer* customer = dynamic_cast<Customer*>(partner);
	Clerk* clerk = customer->getClerk();
	if (clerk == this) {
		return true;
	} else {
		return false;
	}
}
