/*
 * AgencySimulation.h
 *
 *  Created on: 02.12.2009
 *      Author: ingmar
 */

#ifndef AGENCYSIMULATION_H_
#define AGENCYSIMULATION_H_

#include <odemx/odemx.h>
#include <list>

#include "Clerk.h"
#include "Customer.h"
#include "CustomerGenerator.h"

class AgencySimulation: public odemx::base::Simulation {
public:
	AgencySimulation(int clerkQuantity);
	virtual ~AgencySimulation();

	void initSimulation();

	odemx::synchronization::WaitQ* getCounterWaitQ () {
		return counterWaitQ;
	}

	odemx::statistics::Tally* getServiceTimeTally() {
		return serviceTimeTally;
	}

	odemx::statistics::Count* getUnsatisfiedCount() {
		return unsatisfiedCount;
	}

private:
	int clerkQuantity;

	odemx::synchronization::WaitQ* counterWaitQ;
	odemx::statistics::Tally* serviceTimeTally;
	odemx::statistics::Count* unsatisfiedCount;
};

#endif /* AGENCYSIMULATION_H_ */
