/*
 * AgencySimulation.cpp
 *
 *  Created on: 02.12.2009
 *      Author: ingmar
 */

#include "AgencySimulation.h"

AgencySimulation::AgencySimulation( int clerkQuantity) : odemx::base::Simulation(), clerkQuantity(clerkQuantity) {
}

AgencySimulation::~AgencySimulation() {
//	std::list<odemx::base::Process *>& t = getTerminatedProcesses ();
//	for (std::list<odemx::base::Process*>::iterator i = t.begin(); i != t.end(); ++i) {
//		delete *i;
//	}
}

void AgencySimulation::initSimulation() {

	serviceTimeTally = new odemx::statistics::Tally(*this, "serviceTime");
	unsatisfiedCount = new odemx::statistics::Count(*this, "unsatisfied");
	counterWaitQ = new odemx::synchronization::WaitQ(*this,"counterWaitQ");

	CustomerGenerator* cg = new CustomerGenerator(*this);
	cg->activate();

	//take an invalid quantity to code the fast and the slow clerk
	if (clerkQuantity == -1) {
		Clerk* fastClerk = new Clerk(*this, 4,1.5);
		Clerk* slowClerk = new Clerk(*this, 5,1);
		fastClerk->activate();
		slowClerk->activate();
	} else {
		for (int i = 0; i < clerkQuantity; i++) {
			Clerk* slowClerk = new Clerk(*this, 5,1);
			slowClerk->activate();
		}
	}
}

