/*
 * main.cpp
 *
 *  Created on: 15.05.2009
 *      Author: ingmar
 */
#include <odemx/odemx.h>
#include <iostream>

class Message : public odemx::synchronization::PortData {
public:
	Message(std::string payload): payload(payload){};
	std::string payload;
};

class Sender : public odemx::base::Process {
	odemx::synchronization::PortHead::Ptr _port;

public:
	Sender(odemx::base::Simulation& sim, odemx::synchronization::PortHead::Ptr& port):
		odemx::base::Process(sim, "sender"), _port(port) {
	}

	int main () {
		while (true) {
			holdFor(3);
			_port->getTail()->put(new Message("msg1"));
			holdFor(5);
			_port->getTail()->put(new Message("msg2"));
			holdFor(3);
			_port->getTail()->put(new Message("msg3"));
		}
		return 0;
	}
};

class Receiver : public odemx::base::Process {
	odemx::synchronization::PortHead::Ptr _port;
	odemx::synchronization::Timer* _timer;

	Message* buffer;

	int _timeout;

public:
	Receiver(odemx::base::Simulation& sim, odemx::synchronization::PortHead::Ptr& port, int timeout):
		odemx::base::Process(sim, "receiver"), _port(port), _timeout(timeout) {
		_timer = new odemx::synchronization::Timer(sim, "timer");
	}

	int main () {
		while (true) {
			_timer->setIn(_timeout);
			odemx::synchronization::IMemory* who = wait(_timer, _port.get() );
			if (who == _timer) {
				std::cout << getSimulation().getTime() << ": timeout" << std::endl;
			} else if ( who == _port.get()) {
				std::auto_ptr< odemx::synchronization::PortData* > data = _port->get();


				odemx::synchronization::PortData* myData = *(data.get());
				Message* msg = (Message* ) myData;
				std::cout << getSimulation().getTime() << ": received message: " << msg->payload << std::endl;
				delete msg;
			}


		}
		return 0;
	}

};

class MySimulation : public odemx::base::Simulation {

	int _timeout;

public:

	MySimulation (int timeout): odemx::base::Simulation(), _timeout(timeout) {

	}

	void initSimulation() {
		odemx::synchronization::PortHead::Ptr port = odemx::synchronization::PortHead::create(*this, "port");
		Sender* sender = new Sender(*this, port);
		Receiver* receiver = new Receiver(*this, port, _timeout);

		sender->activate();
		receiver->activate();
	}

};

int main( int argc, char* argv[] )
{

	MySimulation* mySim = new MySimulation(4);
	mySim->runUntil( 20 );

	MySimulation* mySim2 = new MySimulation(2);
	mySim2->runUntil( 20 );

	return 0;
}
