// ==================== GLOBALS =================================

xmlTraceIncluded = true;

var currentOptionId; // the last display option clicked
var currentFile;// the currently active xml file
var allTraceFiles = new Array(); // stores xml trace file names

// ==================== INITIALIZATION ===========================


function init() {
log('init()');

	try { var opts = getElementsByClassName('opt'); }
	catch(e) { alert('Error initializing options menu'); }

	// init options with onclick event listener
	for (var i = 0; i < opts.length; i++) {
		$(opts[i].id).onclick = function () { showFilteredData( this.id ); };
	}
	
	$('log').className = 'hidden';

	// first time set option to first in the list, should be 'all'	
	currentOptionId = opts[0].id; 
	// read global xmlListFile to initiate time selector
	setSimulationPeriods( xmlListFile );
}


function setSimulationPeriods( listFile ) {
log('setSimulationPeriods( ' + listFile + ' )');

	// read the xml list file
	showLoad();
	var xmlFiles = loadXml( listFile );

	// parse document for all file tags
	var xpath = "//file";
	var files = xmlFiles.evaluate( xpath, 
								   xmlFiles, 
								   null, 
								   XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, 
								   null );
								   
	// fill an HTML select menu with the file values
	var html = '<select ' +
			   'onchange="' +
			   'showSimulationPeriod(this.options[this.selectedIndex].value)">';

	// iterate over the whole xml snapshot
	for ( var j = 0; j < files.snapshotLength; j++ ) {
		// get file name and time periods
		var fileName = files.snapshotItem(j).getAttribute('name');
		var fileStart = files.snapshotItem(j).getAttribute('starttime');  
		var fileEnd = files.snapshotItem(j).getAttribute('endtime');
		// create a new select option
		html += '<option value="' + fileName +'">'
			    + fileStart + "-" + fileEnd + '</option>';
		// remember file name 
		allTraceFiles.push( fileName );
	}
	html += '</select>';
	
	// populate div box with the select menu
	$('periodSelect').innerHTML = html;
	
	// first time set current file to first file listed (the trace begin)	
	currentFile = files.snapshotItem(0).getAttribute('name');

	// display first trace file with first filter ( should be the complete trace ) 	
	showSimulationPeriod( currentFile );
}

// called on change of the html select built above
function showSimulationPeriod( periodFile ) {
log('showSimulationPeriod( ' + periodFile + ', ' + currentOptionId + ' )');

	showLoad();
	
	// remember chosen file in case a different option 
	// is chosen for display on the same file 
	currentFile = periodFile;

	// use current filter option on given file
	showFilteredData( currentOptionId );
}

// called on click of a filter option 
function showFilteredData( optionId ) {
log('showFilteredData( ' + currentFile + ', ' + optionId + ' )');

	showLoad();

	// remember option clicked and switch display style
	$(currentOptionId).style.backgroundColor = '#FFFFC0';
	currentOptionId = optionId;
	$(currentOptionId).style.backgroundColor = 'gold';

	var xmlTrace = loadXml( currentFile );

	var newData = '';
	
	if ( currentOptionId == 'all' )
		newData += allMarksHtmlTrace( xmlTrace );
	
	if ( currentOptionId == 'msg' )
		newData += messageHtmlTrace( xmlTrace );

	if ( currentOptionId == 'broad' )
		newData += broadcastHtmlTrace( xmlTrace );

	if ( currentOptionId == 'uni' )
		newData += unicastHtmlTrace( xmlTrace );
		
	if ( currentOptionId == 'trans' )
		newData += transmitHtmlTrace( xmlTrace );
	
	if ( currentOptionId == 'complete' )
		newData += completeHtmlTrace();
	
	$('content').innerHTML = newData;
	if ( newData != '' ) {	showContent(); }	
}


// display all trace marks
function allMarksHtmlTrace( xmlTrace ) {
log('allMarksHtmlTrace()');

	var xpath = "//mark";

	return printMarks( xpath, xmlTrace );
}


// find all marks with attribute name value set by messages 
function messageHtmlTrace( xmlTrace ) {
log('messageHtmlTrace()');	

	var xpath = "//mark[@name='schedule broadcast' " +
				"or @name='schedule unicast' " +
				"or @name='unicast success' " +
				"or @name='broadcast success' " +
				"or @name='unicast failure' " +
				"or @name='broadcast failure' " +
				"or @name='received message']";
		
	return printMarks( xpath, xmlTrace );
}


// find all marks with attribute name value set by broadcast messages
function broadcastHtmlTrace( xmlTrace ) {
log('broadcastHtmlTrace()');
	
	var xpath = "//mark[@name='schedule broadcast' " +
				"or @name='broadcast success' " +
				"or @name='broadcast failure']";
	
	return printMarks( xpath, xmlTrace );
}


// find all marks with attribute name value set by unicast messages
function unicastHtmlTrace( xmlTrace ) {
log('unicastHtmlTrace()');
	
	var xpath = "//mark[@name='schedule unicast' " +
				"or @name='unicast success' " +
				"or @name='unicast failure']";

	return printMarks( xpath, xmlTrace );
}


// find all marks with attribute name value set by unicast messages
function transmitHtmlTrace( xmlTrace ) {
log('transmitHtmlTrace()');
	
	var xpath = "//mark[@name='initiate transmission' " +
				"or @name='transmit' " +
				"or @name='pass upward' " +
				"or @name='received message']";

	return printMarks( xpath, xmlTrace );
}


function completeHtmlTrace() {

	var allData = '';

	for ( var file_i = 0; file_i < allTraceFiles.length; ++file_i ) {
		
		var xmlTrace = loadXml( allTraceFiles[ file_i ] );
		allData += allMarksHtmlTrace( xmlTrace );
	}
	return allData;
}

// use given marks to generate html output to fill the content area
function printMarks( xpath, xmlTrace ) {
log('printMarks()');

	var marks = xmlTrace.evaluate( xpath, 
								   xmlTrace, 
								   null, 
								   XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, 
								   null );
	
	if ( marks.snapshotLength == 0 ) {
		showNothing();
		return '';
	}	
	
	var newHTML = ''; // the output stream
	var lastSimTime = null; // remember the marks' simulation time
	
	// iterate over the whole xml snapshot
	for ( var i = 0; i < marks.snapshotLength; i++ )
	{	
		// get time, only print if new
		var attrTime = marks.snapshotItem(i).getAttribute('time');
		if ( attrTime != lastSimTime ) {
			
			// new simulation time: close time box 
			if ( lastSimTime != null ) 
			{
				newHTML += "</table>";
				newHTML += "</div>";
			}
			// remember time of current timeBox;
			lastSimTime = attrTime;
				
			// build new time box containing a table
			newHTML += "<div class='timeBox'>"
			newHTML += "<h3>SimTime: " + attrTime + "</h3>";
			newHTML += "<table class='timeTable'>";
			newHTML += "<tr><th>Sender</th><th>Event</th><th>Details</th></tr>";
		}

		// build event row
		newHTML += "<tr>";
				
		// get sender label
		newHTML += "<td class='sender'>";
		newHTML += marks.snapshotItem(i).getElementsByTagName('sender')[0].textContent + " ";
		newHTML += "</td>";
		
		// get event name
		newHTML += "<td class='event'>";		
		newHTML += marks.snapshotItem(i).getAttribute('name');
		newHTML += "</td>";
				
		// print tags belonging to this event 
		var tags = marks.snapshotItem(i).getElementsByTagName('tag');
		if ( tags.length > 0 )
		{
			// print tags in the third column
			for ( var tag_i = 0; tag_i < tags.length; tag_i++ )
			{
				if ( tag_i > 0 ) {
					// start row, leave first two columns empty
					newHTML += "</tr><tr><td class='empty' colspan='2'>&nbsp;</td>";
				}
				newHTML += "<td class='tag'>";

				// get name and value
				tagName = tags[tag_i].getAttribute('name');
				tagValue = tags[tag_i].textContent;
								
				// print tags and treat comments
				if ( tagName != "comment" ) {
					newHTML += "<div class='tagName'>";
					newHTML += tagName;
					newHTML += "</div>";
					newHTML += "<div class='tagValue'>";
					newHTML += tagValue;
					newHTML += "</div>";
				}
				else
				{
					newHTML += "<div class='comment'>";
					newHTML += tagValue;
					newHTML += "</div>";
				}
				
				// close tag
				newHTML += "</td>";
			}
		}
		else { // no tags
			newHTML += "<td>&nbsp;</td>";
		}
 
		// close event box and draw spacer line to next event
		newHTML += "</tr>";
		newHTML += "<tr><td class='spacer' colspan='3'></td></tr>";

	} // end of mark loop

	// close last time box
	newHTML += "</table>";
	newHTML += "</div>";

	// alert( newHTML );
	return newHTML; 
}


// =================== HELP FUNCTIONS ==============================

function showLoad() {
log('showLoad()');

	$('content').style.display = 'none';
	$('nothing').style.display = 'none';
	$('load').style.display = 'block';
}

function showNothing() {
log('showNothing()');
	
	$('content').style.display = 'none';
	$('load').style.display = 'none';
	$('nothing').style.display = 'block';
}

function showContent() {
log('showContent()');
	
	$('nothing').style.display = 'none';
	$('load').style.display = 'none';
	$('content').style.display = 'block';
}

function $( elementId ) {
	return document.getElementById( elementId );
}

function getElementsByClassName( className, parentElement ) {
log('getElementsByClassName');

	// xpath expression to find objects by className
  	xpath = ".//*[contains(concat(' ', @class, ' '), ' " + className + " ')]";
    
    // apply xpath to the document node
    var query = document.evaluate(xpath, $(parentElement) || document,
      			null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
    
    // fill result list and return it 
    var results = [];
    for (var i = 0, length = query.snapshotLength; i < length; i++) {
      results.push(query.snapshotItem(i));
    }
    return results;
}

function log( string ) {
	var tmp = string + "<br />"; 
	tmp += $('log').innerHTML;
	$('log').innerHTML = tmp;
}

function toggleLog() {
log( 'toggleLog()' );

	$('log').className = 
		( $('log').className == 'visible' ) ? 'hidden' : 'visible';
}

function createXmlHttp() {
log('createXmlHttp()');
	try {
		return( new XMLHttpRequest() );
	}
	catch(e) {
		return( new ActiveXObject('Microsoft.XMLHTTP') );
	}
}

function loadXml( file ) {
log('loadXml( ' + file + ' )');

	var xmlhttp = createXmlHttp();
	
	if ( xmlhttp!=null )
	{
		xmlhttp.open( "GET", file, false );
		xmlhttp.send( null );
	}
	else
	{
		alert( "This browser does not support XMLHTTP." )
	}

	// read the xml document (implicit cast) 	
	return xmlhttp.responseXML;
}
