//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file LabeledObject.cpp

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2002/08/17

	\brief Implementation of classes in LabeledObject.h

	\sa LabeledObject.h

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#include <odemx/util/LabeledObject.h>

#include <sstream>

using namespace odemx;
using namespace std;

LabeledObject::~LabeledObject() { }

LabelScope::LabelScope(const char* defLabel, char defSpace) :
	def(defLabel),
	spc(defSpace)
{}

string LabelScope::createLabel(const char* label) {
	unsigned int number=0;
	string l(label);
	ostringstream stream;

	if (l.empty()) l=def;

	number=lookup[l]++;
	stream << l;

	if (number>0) stream << spc << number;

	stream << ends;
	return stream.str();
}

DefLabeledObject::DefLabeledObject() : l("???") {
}


DefLabeledObject::DefLabeledObject( LabelScope* scope, const char* label )
	{
		if (scope!=0)
			l=scope->createLabel(label);
		else
			l=label;
	}


Label DefLabeledObject::getLabel() const {
	return l.c_str();
}

void DefLabeledObject::setLabel(LabelScope* scope, const char* label) {
	if (scope!=0)
		l=scope->createLabel(label);
	else
		l=label;
}

