//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file ErrorHandling.h

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2002/01/22

	\brief Declaration of error handler functions

	\sa ErrorHandling.cpp

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#ifndef ODEMX_ERRORHANDLING_INCLUDED
#define ODEMX_ERRORHANDLING_INCLUDED

namespace odemx {
	/**
		\ingroup util

		\brief %debug() writes debug messages in debug mode
		\param message
			debug message as const char*

		\note use the macro _debugOut(message) instead,
		to skip the function call in the release build
	*/
	void debug(const char* message);

#ifdef _DEBUG
#define debugOut(message) debug(message)
#else
#define debugOut(message)
#endif

	/**
		\ingroup util

		\brief %warning() writes the message to \c stderr and continues;

		This function is used to inform the user about unusual events,
		that indicate an user error.

		\param message
			warning description as const char*
	*/
	void warning(const char* message);

	/** 
		\ingroup util

		\brief %error() writes the message to \c stderr and continues;

		This function reports errors, caused by wrong usage and internal errors,
		the system could handle. The behaviour of the simulation could be wrong
		after an error() is reported.

		\param message
			error description as const char*
	*/
	void error(const char* message);

	/**
		\ingroup util

		\brief %fatalError() writes the message to \c stderr and terminates the program;

		This function reports errors, caused by wrong usage and internal errors,
		the system can't handle.

		\param message
			error description as const char*
		\param exitValue
			exit value of program
	*/
	void fatalError(const char* message, int exitValue);
}

#endif

