using namespace odemx;

#if defined(__GNUC__)
#include <cxxabi.h>
#define _storeElementTypeString(ElementType)\
{\
int status = -1;\
elementTypeName = abi::__cxa_demangle(typeid(ElementType).name(), 0, 0, &status);\
}
#else /* different compiler */
#define _storeElementTypeString(ElementType)\
{\
elementTypeName = typeid(ElementType).name();\
}
#endif /* __GNUC__ detection */


/********************* Port Template Implementation ***************************/

template < typename ElementType >
PortT< ElementType >::PortT( Simulation* sim, Label l, unsigned int max, 
							 PortHeadT< ElementType >* ph, 
							 PortTailT< ElementType >* pt ):
	StatisticObject( sim ),
	maxCapacity( max ), 
	portHead( ph ), 
	portTail( pt ), 
	env( sim ),
	elementTypeName( 0 ),
	portAccum( sim )
	{
		_storeElementTypeString(ElementType);
		DefLabeledObject::setLabel( sim, l );
	}


template < typename ElementType >
PortT< ElementType >::~PortT()	
	{	
		if ( !elementList.empty() ) {
			// warning: port still contains elements
			warning( "Port::~Port(): deletion of non-empty port" );

			// pointer types will be deleted by detection template
			if ( PointerList< ElementType >::value == true ) {
				PointerList< ElementType >::deleteList( elementList );
			}
		}
		
		free( elementTypeName ); // allocated by malloc() in ...demangle()
	}


template < typename ElementType >
void PortT< ElementType >::report( Report* r ) {
	assert(r);

	static const char* labels[] = { "Name", "Element type", "Buffer limit",
								    "Reset at", "Put calls", "Get calls",
								    "Unget calls",
								    "Min buffer count", "Max buffer count",
								    "Now buffer count", "Avg buffer count",
								    "Head alerts", "Tail alerts" };

	static const ColumnType types[] = { STRING, STRING, INTEGER,
									    REAL, INTEGER, INTEGER,
									    INTEGER,
									    INTEGER, INTEGER,
									    INTEGER, REAL,
									    INTEGER, INTEGER };

	static utTableDef def(sizeof(labels)/sizeof(char*), labels, types);

	Table* t = r -> createTable("Port Statistics", &def);
	assert(t);

	*t << getLabel() << elementTypeName << maxCapacity;
	*t << getResetTime() << putCalls << getCalls << ungetCalls;
	*t << getMinCount() << getMaxCount();
	*t << getNowCount() << getAvgCount();
	*t << headAlerts << tailAlerts;
}


template < typename ElementType >
void PortT< ElementType >::reset() {
	putCalls = 0;
	getCalls = 0;
	headAlerts = 0;
	tailAlerts = 0;
	StatisticObject::reset();
	
	portAccum.reset();
	portAccum.update(getNowCount());	
}

