//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file Queue.cpp

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2003/06/28

	\brief Implementation of Queue

	\sa Queue.h

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#ifdef _MSC_VER
#pragma warning (disable : 4786)
#endif

#include <odemx/synchronization/Queue.h>
#include <odemx/base/Process.h>

using namespace std;
using namespace odemx;

Queue::Queue(Simulation* s, Label l, ProcessOrder* pred) :
	ProcessQueue(pred), StatisticObject(s),
	queueStatistics(s, (string(l) + string("_statistic")).c_str())
{
	assert(s!=0);

	// set label
	DefLabeledObject::setLabel(s, l);

	// init statistic
	reset();
}

void Queue::popQueue()
{
	ProcessQueue::popQueue();
	queueStatistics.update(getNow());
}

void Queue::remove(Process* p)
{
	ProcessQueue::remove(p);
	queueStatistics.update(getNow());
}

void Queue::inSort(Process* p,  bool fifo)
{
	//ProcessQueue::inSort(p, fifo);
	// Process p has to remember this queue
	p->enqueue(this);
	ProcessQueue::l.push_back(p);

	queueStatistics.update(getNow());
}

void Queue::reset()
{
	StatisticObject::reset();
	queueStatistics.reset();
	queueStatistics.update(getNow());
}

void Queue::report(Report* r) {
	assert(r);

	static const char* labels[] = {"Name", "Reset at", "Min queue length", "Max queue length", "Now queue length", "Avg queue length"};
	static const ColumnType types[] = {STRING, REAL, INTEGER, INTEGER, INTEGER, REAL};
	static utTableDef def(sizeof(labels)/sizeof(char*), labels, types);

	Table* t=r->createTable("Queue Statistics", &def);
	assert(t);

	*t << getLabel() << getResetTime() << getMin() << getMax() << getNow() << getAVLength();
}

