//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file System.h

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2002/02/04

	\brief Operating system and platform specific 'includes', 
	'defines' and 'types'.

	<!-- [\sa <pair-file>] -->

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}] -->

	\since 1.0
*/

#ifndef ODEMX_SYSTEM_INCLUDED
#define ODEMX_SYSTEM_INCLUDED

#ifdef FORCE_STACK_IMPL
#include <csetjmp>
#include <memory.h>
#else

#ifdef _WIN32
#define _WIN32_WINNT 0x0400
#define WINVER 0x0400
#define WIN32_LEAN_AND_MEAN
#define HAVE_FIBERS
#include <windows.h>
#else
#include <setjmp.h>
#include <memory.h>
#endif

#endif

namespace odemx {
#ifndef HAVE_FIBERS
	typedef char* StackAdress; ///< \internal address in runtime stack
	typedef char* StackBuffer; ///< \internal runtime stack type
#endif
}

#endif

