//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file TraceFilter.h

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2003/06/10

	\brief Filter for trace marks

	\sa TraceFilter.cpp

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/


#ifndef ODEMX_TRACEFILTER_INCLUDED
#define ODEMX_TRACEFILTER_INCLUDED

#include <odemx/util/Trace.h>

#include <string>
#include <set>

namespace odemx {
	/** \class TraceFilter

		\ingroup base

		\author Ralf Gerstenberger
		<!-- [\author <author>]* -->

		\brief Filter for trace marks

		<!-- [\note {notes}]* -->

		<!-- [\sa {references to other classes}]* -->

		TraceFilter provides a crude filter for trace marks. It
		can be used by TraceConsumer implementations to filter
		trace marks.

		<!-- [\warning {warnings}]* -->

		<!-- [\todo {todos for this file}]* -->

		<!-- [\bug {bug description}]* -->

		<!-- [\test {testcase description}]* -->

		\since 1.0
	*/
	class TraceFilter {
	public:
		/// Construction
		TraceFilter();
		/// Destruction
		virtual ~TraceFilter(); 

		/**
			\name output filter

			XmlTrace provides a crude filter to reduce
			the generated output. The filter can be set
			before trace starts or in pause mode through 
			setFilter(). 

			@{
		*/
		/// Set a new filter
		virtual void setFilter(const char* f);

		/// Get filter
		const std::string& getFilter() const {return patt;}
		//@}

	protected:
		/// Filter mark
		bool pass(const MarkType* m, const TraceProducer* sender);

		/// Last filter result
		bool hasPassed() const {return !filterOut;}

	private:
		bool filterOut; ///< Is filtering out
		std::string patt; ///< Filter string

		/// Filter
		struct Filter {
			enum {PASSALL, PASSNONE} def;
			std::set<MarkTypeId> MarkTypeIds;
			std::set<std::string> MarkTypeNames;
			std::set<std::string> MarkTypeScopes;
			std::set<std::string> SenderLabels;
			std::set<std::string> SenderTypes;
		} filter;
	};
}

#endif
