//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file StatisticObject.cpp

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2003/05/24

	\brief Implementation for statistic objects

	\sa StatisticObject.h

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#include <odemx/util/StatisticObject.h>
#include <algorithm>

using namespace odemx;

StatisticObject::StatisticObject(StatisticManager* m) : manager(m) {
	if (!manager) return;

	manager->add(this);
	reset_at=manager->getTime();
}

StatisticObject::~StatisticObject() {
	if (manager)
		manager->remove(this);
}

StatisticManager* StatisticObject::setStatisticManager(StatisticManager* nm) {
	if (manager)
		manager->remove(this);

	if (nm)
		nm->add(this);

	std::swap(nm, manager);

	return nm;
}

void StatisticObject::reset() {
	if(manager)
		reset_at=manager->getTime();
}

StatisticManager::StatisticManager() {}

StatisticManager::~StatisticManager() {
	so.clear();
}

void StatisticManager::reset() {
	std::list<StatisticObject*>::iterator i;
	for (i=so.begin(); i!=so.end(); ++i)
		(*i)->reset();
}

void StatisticManager::add(StatisticObject* o) {
	if (o) so.push_back(o);
}

void StatisticManager::remove(StatisticObject* o) {
	if (o) so.remove(o);
}

