//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004, 2007 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file PortTemplate.h

	\author Ronald Kluth
	<!-- [\author <author>]* -->

	\date created at 2007/04/04

	\brief Declaration of odemx::PortHead and odemx::PortTail

	\sa PortT.h, PortT.cpp, PortHeadT.cpp, PortTailT.cpp

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 2.0
*/


#ifndef ODEMX_PORT_TEMPLATE_INCLUDED
#define ODEMX_PORT_TEMPLATE_INCLUDED

// port template headers with implementation
#include <odemx/synchronization/templates/PortT.h>
#include <odemx/synchronization/templates/PortT.cpp>
#include <odemx/synchronization/templates/PortHeadT.cpp>
#include <odemx/synchronization/templates/PortTailT.cpp>


// type definitions for convenience
namespace odemx {

	/** \class PortElement
	
		\ingroup synch
	
		\author Ronald Kluth
		
		<!-- [\author <author>]* -->
	
		\brief %PortElement is the default base class for port elements.
	
		\sa PortHeadT, PortTailT, PortT
	
		%PortElement can be used as common base class for all objects that 
		are handled by ports. With default ports, all class types that 
		define elements such as messages to be passed through a port 
		must be derived	from %PortElement because default ports can only handle 
		pointers to derivations of this type.
		
		\since 2.0
	*/
	class PortElement { 
	protected: 
		/// Construction
		PortElement() {}
	public:
		/// Destruction
		virtual ~PortElement() {}
	};
	


	/** \var typedef PortHeadT< PortElement* > PortHead;
	 
		\brief Default PortHead supporting elements derived from PortElement
	*/
	typedef PortHeadT< PortElement* > PortHead;

	/** \var typedef PortTailT< PortElement* > PortTail;
	 
		\brief Default PortTail supporting elements derived from PortElement
	*/
	typedef PortTailT< PortElement* > PortTail;

	/** \var typedef PortHeadObserverT< PortElement* > PortHeadObserver;
	 
		\brief Default observer for PortHead
	*/
	typedef PortHeadObserverT< PortElement* > PortHeadObserver;

	/** \var typedef PortTailObserverT< PortElement* > PortTailObserver;
	 
		\brief Default observer for PortTail
	*/
	typedef PortTailObserverT< PortElement* > PortTailObserver;



}

#endif /* ODEMX_PORT_TEMPLATE_INCLUDED */
