//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file odemx.h

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2002/08/05

	\brief Includes ODEMx header files

	<!-- [\sa <pair-file>] -->

	<!-- [detailed description] -->
	This file includes other header files of odemx.
	
	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#ifndef ODEMX_ODEMX_INCLUDED
#define ODEMX_ODEMX_INCLUDED

// base package
#include <odemx/base/Simulation.h>
#include <odemx/base/Process.h>
#include <odemx/base/Event.h>
#include <odemx/base/Continuous.h>
#include <odemx/base/HtmlTrace.h>
#include <odemx/base/HtmlReport.h>

// synchronization package
#include <odemx/synchronization/Bin.h>
#include <odemx/synchronization/Res.h>
#include <odemx/synchronization/Condq.h>
#include <odemx/synchronization/Waitq.h>
#include <odemx/synchronization/Wait.h>
#include <odemx/synchronization/Timer.h>
#include <odemx/synchronization/Memo.h>
#include <odemx/synchronization/PortTemplate.h>

// protocol package
#include <odemx/protocol/NetNode.h>
#include <odemx/protocol/NetTopology.h>
#include <odemx/protocol/ProtocolEntity.h>
#include <odemx/protocol/ProtocolLayer.h>
#include <odemx/protocol/ProtocolMessage.h>
#include <odemx/protocol/ProtocolSimulation.h>
#include <odemx/protocol/TransmissionEvents.h>
#include <odemx/protocol/TransmissionMedium.h>

// statistics package
#include <odemx/statistics/Statistics.h>

// random package
#include <odemx/random/Idist.h>
#include <odemx/random/Rdist.h>

// util package
#include <odemx/util/LabeledObject.h>
#include <odemx/util/ErrorHandling.h>
#include <odemx/util/Version.h>
#include <odemx/util/XmlTrace.h>

#endif

