//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file Queue.h

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2003/06/28

	\brief Wrapper for ProcessQueue

	\sa Queue.cpp

	Queue is a wrapper for ProcessQueue. In addition to the 
	functions of ProcessQueue it also provides statistics about
	the queue usage. Queue is indented for ODEMx internal use only.

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/


#ifndef ODEMX_QUEUE_INCLUDED
#define ODEMX_QUEUE_INCLUDED

#include <odemx/base/Simulation.h>
#include <odemx/base/ProcessQueue.h>
#include <odemx/util/Report.h>
#include <odemx/util/LabeledObject.h>
#include <odemx/util/StatisticObject.h>
#include <odemx/statistics/Statistics.h>

namespace odemx{
	/** \class Queue

		\ingroup synch

		\author Ralf Gerstenberger
		<!-- [\author <author>]* -->

		\brief Wrapper for ProcessQueue		

		\note intended for ODEMx internal use only

		\sa ProcessQueue

		\copydoc Queue.h

		<!-- [\warning {warnings}]* -->

		<!-- [\todo {todos for this file}]* -->

		<!-- [\bug {bug description}]* -->

		<!-- [\test {testcase description}]* -->

		\since 1.0
	*/
	class Queue : public ProcessQueue,
				  public DefLabeledObject,
				  public StatisticObject,
				  public virtual ReportProducer
	{
	public:
		/// Contruction
		Queue(Simulation* s, Label l, ProcessOrder* pred = &defOrder);

		// Manipulator methods
		virtual void popQueue();
		virtual void remove(Process* p);
		virtual void inSort(Process* p,  bool fifo = true);

		/**
			\name Statistics

			@{
		*/
		/// reset statistics
		virtual void reset();

		/// min queue length
		unsigned int getMin() const {return (unsigned int)queueStatistics.getMin();}

		/// max queue length
		unsigned int getMax() const {return (unsigned int)queueStatistics.getMax();}

		/// current queue length
		unsigned int getNow() const {return ProcessQueue::getLength();}

		/// average queue length
		double getAVLength() const {return queueStatistics.getMean();}

		//@}

		/// generate report
		virtual void report(Report* r);

	private:
		// Implementation
		Accum queueStatistics;
	};
}

#endif

