#include <odemx/util/ErrorHandling.h>
#include <odemx/util/HtmlGenerator.h>
#include <odemx/util/Version.h>
#include <odemx/OdemXPath.h>


using namespace odemx;
using namespace std;


HtmlGenerator::HtmlGenerator( Simulation* sim ):
	env( sim )
	{}


void HtmlGenerator::generateHtml( string xmlFileName, string filter ) {
	
	// build file name
	ostringstream file;
	file << xmlFileName << ".html";
	
	htmlStream = new ofstream( file.str().c_str() );
	
	if ( htmlStream==0 || !(*htmlStream) ) {
		// Error: cannot open file
		error( "HtmlGenerator::generateHtml(): cannot open file, sending output to stdout" );
		htmlStream = &cout;
	}
	
	// build the file
	htmlHead( xmlFileName );
	htmlBodyCaption( filter );
	htmlBodyNavigation();
	htmlBodyFoot();
	
	// delete old file pointer
	reinterpret_cast<ofstream*>( htmlStream ) -> close();
	delete htmlStream;
}



void HtmlGenerator::htmlHead( string xmlFileName ) {
	
	*htmlStream << "<!DOCTYPE html" << endl; 
	*htmlStream << "PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"" << endl;
	*htmlStream << "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">" << endl;
	
	*htmlStream << "<html xmlns='http://www.w3.org/1999/xhtml'>" << endl;
	*htmlStream << "<head>" << endl;
	*htmlStream << "<meta http-equiv='Content-Script-Type' content='text/javascript' />" << endl;
	
	*htmlStream << "<link rel='stylesheet' type='text/css' href='";
	*htmlStream << odemxPath + "/util/XmlTrace.css' />" << endl;

	*htmlStream << "<script type='text/javascript'>" << endl;
	*htmlStream << "<!--" << endl;
	*htmlStream << "var xmlListFile = '";
	*htmlStream << xmlFileName << "_file_list.xml';" << endl;
	*htmlStream << "var xmlTraceIncluded = false;" << endl;
	*htmlStream << "//-->" << endl;
	*htmlStream << "</script>" << endl;
	*htmlStream << "<script type='text/javascript' src='";
	*htmlStream << odemxPath + "/util/XmlTrace.js'></script>" << endl;
	*htmlStream << "<script type='text/javascript'>" << endl;
	*htmlStream << "<!--" << endl;
	*htmlStream << "if ( !xmlTraceIncluded ) { " << endl;
	*htmlStream << "	alert( 'Script XmlTrace.js not found!' );" << endl;
	*htmlStream << "}" << endl;
	*htmlStream << "//-->" << endl;
	*htmlStream << "</script>" << endl;
	*htmlStream << "<title>ODEMx XML Trace: " << env -> getLabel() << "</title>" << endl;
	*htmlStream << "</head>" << endl;
}

void HtmlGenerator::htmlBodyCaption( string filter ) {
	
	*htmlStream << "<body onload='init();'>" << endl;

	*htmlStream << "<div id='caption'>" << endl;
	*htmlStream << "<h1>ODEMx XML Trace</h1>" << endl;
	*htmlStream << "<h2>Simulation: ";
	*htmlStream << env -> getLabel() <<	"</h2>" << endl;
	*htmlStream << "<h2>ODEMx Version: " << Version::getString(); 
	*htmlStream << "</h2>" << endl;
	*htmlStream << "<h2>Trace Filter:</h2>" << endl;
	*htmlStream << filter << endl;
	*htmlStream << "</div>" << endl;
}

void HtmlGenerator::htmlBodyNavigation() {
	
	*htmlStream << "<div id='nav'>" << endl;
	*htmlStream << "<div id='log'></div>" << endl;
	*htmlStream << "<table id='navOptions'>" << endl;
	*htmlStream << "<tr><td id='all' class='opt'><a href=#self>All Trace Marks</a></td></tr>" << endl;
	*htmlStream << "<tr><td id='msg' class='opt'><a href=#self>All Message Marks</a></td></tr>" << endl;
	*htmlStream << "<tr><td id='broad' class='opt'><a href=#self>Broadcast Marks</a></td></tr>" << endl;
	*htmlStream << "<tr><td id='uni' class='opt'><a href=#self>Unicast Marks</a></td></tr>" << endl;
	*htmlStream << "<tr><td id='trans' class='opt'><a href=#self>Protocol Stack Marks</a></td></tr>" << endl;
	*htmlStream << "<tr><td id='navTime'>Time Period:</td></tr>" << endl;
	*htmlStream << "<tr><td id='navPeriod'><span id='periodSelect'></span></td></tr>" << endl;
	*htmlStream << "<tr><td id='logToggle' onclick='toggleLog();'>Toggle JS Log</td></tr>" << endl;
	*htmlStream << "<tr><td id='complete' class='opt'><a href=#self>Complete Trace</a></td></tr>" << endl;
	*htmlStream << "</table>" << endl;
	*htmlStream << "</div>" << endl;
}

void HtmlGenerator::htmlBodyFoot() {
	
	*htmlStream << "<div id='load' class='info'><p>Retrieving simulation data...</p></div>" << endl;
	*htmlStream << "<div id='nothing' class='info'><p>No trace data to display.</p></div>" << endl;
	*htmlStream << "<div id='content'></div>" << endl;

	*htmlStream << "</body>" << endl;
	*htmlStream << "</html>" << endl;
}

