//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004, 2007 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file ProtocolSimulation.cpp

	\author Ronald Kluth
	<!-- [\author <author>]* -->

	\date created at 2007/04/04

	\brief Implementation of classes in ProtocolSimulation.h

	\sa ProtocolSimulation.h

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 2.0
*/


#include <odemx/protocol/ProtocolSimulation.h>
#include <odemx/protocol/TransmissionMedium.h>
#include <odemx/util/ErrorHandling.h>
#include <iostream>

using namespace odemx;


ProtocolSimulation::ProtocolSimulation( Label l, SimulationObserver* o ):
	Simulation( l, o ),
	medium( 0 ) 
	{
		layerManager = new ProtocolLayerManager();
	}


ProtocolSimulation::~ProtocolSimulation() 
	{
		delete layerManager;
	}

 

NetTopology* ProtocolSimulation::getNetTopology() {
	
	if ( !medium )
		error( "ProtocolSimulation::getNetTopology():  NetTopology not set" );
	
	return medium;
}


void ProtocolSimulation::setTransmissionMedium( TransmissionMedium* tm ) {
	medium = tm;
}


TransmissionMedium* ProtocolSimulation::getTransmissionMedium() {
	
	if ( !medium )
		error( "ProtocolSimulation::getTransmissionMedium(): TransmissionMedium not set" );
	
	return medium;
}


ProtocolLayerManager* ProtocolSimulation::getLayerManager() {
	return layerManager;
}


ProtocolLayerList& ProtocolSimulation::getLayerList() {
	return getLayerManager() -> getLayerList();
}


void ProtocolSimulation::printLayers( bool withEntities /*=false*/ ) {
	std::cout << "Layers:" << std::endl;
	ProtocolLayerList::iterator iter;
	for( iter = getLayerList().begin(); iter != getLayerList().end(); ++iter ) {
		std::cout << (*iter) -> getLabel() << std::endl;
		if ( withEntities )
			(*iter) -> printEntityList();
	}
}


void ProtocolSimulation::report( Report* r ) {
	assert( r );

	static const char* labels[] = { "Nodes", "Messages", 
									"Broadcasts", "Unicasts", 
									"Failed Broadcasts", "Failed Unicasts", 
									"Collisions" };

	static const ColumnType types[] = { INTEGER, INTEGER,
									    INTEGER, INTEGER,
									    INTEGER, INTEGER,
									    INTEGER };

	static utTableDef def( sizeof( labels ) / sizeof( char* ), labels, types );

	Table* t = r -> createTable( "Protocol Simulation Statistics", &def);
	assert(t);

	*t << getNetTopology() -> getAllNodes().size();
	*t << medium -> messageCount;
	*t << medium -> broadcastCount;
	*t << medium -> unicastCount;
	*t << medium -> failedBroadcastCount; 
	*t << medium -> failedUnicastCount;
	*t << medium -> collisionCount;
}

