/*
 * main.cpp
 *
 *  Created on: 15.05.2009
 *      Author: ingmar
 */

#include "odemx/odemx.h"
#include "Clock.h"

int main( int argc, char* argv[] )
{

	odemx::base::Simulation& sim = odemx::getDefaultSimulation();
	Clock clock1( sim, "clock1", 1.0);
	Clock clock2( sim, "clock2", 2.0);

	clock1.activate();
	clock2.activate();

	std::cout << "Basic Process Simulation Example\n";
	std::cout << "================================\n";

	for( int i = 0; i < 5; ++i )
	{
		std::cout << "step: " << i <<std::endl;
		sim.step();
	}

	std::cout << "continue until SimTime 10 is reached:" <<std::endl;
	sim.runUntil( 10 );
	std::cout << "time = " << sim.getTime() << "\n";

	std::cout << "run until end:" <<std::endl;
	sim.run();
	std::cout << "time = " << sim.getTime() << "\n";

	std::cout << "================================" << std::endl;

	return 0;
}
