
#ifndef _GLOBALS_HPP_
#define _GLOBALS_HPP_

#include <string>
#include <map>
#include <iostream>
#include <vector>
#include <set>
#include "limits.h"///////////////////////
#include "stdlib.h"/////////////

#include "KollisionException.hpp"

using namespace std;

//#define MY_DEBUG 42
//#define USE_CACHE 42 // ausschalten; kollidiert mit IOOrder
//#define SORTED_INSERT 42
#define USE_C_FILES 42

// hardcoded!
// abhängig von global_var_use_odci (default: false)
// per Definition sind die Pfade festgelegt
// die Umschaltung erfolgt durch die variable use_odci
#define ODCI_DATA_SUBDIR string("D:/oracle/express_edition/oradata/idx_data/")
#define DATA_SUBDIR string("/home/a/Studienarbeit/Data/native/")

#define MAXCHARS 4
#define ALPHABET_COMPRESSION_FACTOR 4
// vier Positionen der Kinder sind frei == 16
#define DEFAULT_INTERNALSAVEDSUFFIXSIZE (MAXCHARS * sizeof(POS_TYPE) * 4)
#define DEFAULT_INTERNALSAVEDSUFFIXSIZE_ONDISK (MAXCHARS * sizeof(POS_TYPE))

// nur drei Kind-Positionen, aber einmal Key-Größe abzüglich der Längen-Info + suffixLength + suffixStart
// 3*4+8-2+2+4 = 24!
#define DEFAULT_INTERNALSAVEDINFIXSIZE (4 * (((MAXCHARS-1) * sizeof(POS_TYPE)) + sizeof(KEY_TYPE) - sizeof(LENGTH_TYPE) + sizeof(LENGTH_TYPE) + sizeof(SUFFIXSTART_TYPE)))
#define DEFAULT_INTERNALSAVEDINFIXSIZE_ONDISK (((MAXCHARS-1) * sizeof(POS_TYPE)) + sizeof(KEY_TYPE) - sizeof(LENGTH_TYPE) + sizeof(LENGTH_TYPE) + sizeof(SUFFIXSTART_TYPE))
#define BLOCKSIZE (4 + 4 + 2 + MAXCHARS * 4)

// Konstanten für die Seitenweise Speicherung
// 1 + 8 + 2 + 4 + 4*4 = 31 (64bit-Key), =27 (32bit-Key)
#define DEFAULT_NODESIZE_ON_DISK (sizeof(char) + sizeof(KEY_TYPE) + sizeof(LENGTH_TYPE) + sizeof(SUFFIXSTART_TYPE) + (MAXCHARS * sizeof(POS_TYPE)))
#define DEFAULT_PAGESIZE_ON_DISK ((int)(DEFAULT_NODESIZE_ON_DISK * 1024)) // 31 * 1024 = 31744 bytes bei 1024 Knoten pro Seite
#define DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY 1000 // 31744 * 1000 = 31.744.000 => ca 30,2MB im RAM

// für die Seitenweise Verarbeitung der Suffixe
#define DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY 512 // 512 * 64k == 32MB im RAM
#define DEFAULT_SUFFIX_PAGESIZE_ON_DISK 65536 // 64k pro Seite (bis zu 256k Zeichen pro Seite)

//#define PTREE_MIN (INT_MIN +4)
//#define PTREE_MIN 1
//#define PTREE_MAX INT_MAX

// INT_MIN // INT_MAX

///////////////////////////////////////////////////

#define USE_64_BIT_KEY 1

#ifdef USE_64_BIT_KEY

#define PTREE_ABS_MIN LLONG_MIN
#define PTREE_ABS_MAX LLONG_MAX
#define PTREE_ABS_UMAX ULLONG_MAX
#define DEF_KEY_TYPE_ long long int
#define DEF_UNSIGNED_KEY_TYPE_ unsigned long long int

#else

#define PTREE_ABS_MIN INT_MIN
#define PTREE_ABS_MAX INT_MAX
#define PTREE_ABS_UMAX UINT_MAX
#define DEF_KEY_TYPE_ int
#define DEF_UNSIGNED_KEY_TYPE_ unsigned int

#endif

///////////////////////////////////////////////////

#define PTREE_MIN (PTREE_ABS_MIN +4)
#define PTREE_MAX PTREE_ABS_MAX
#define PTREE_UMAX PTREE_ABS_UMAX

#define PTREE_NULL (PTREE_ABS_MIN + 1)
#define PTREE_NULLKEY (PTREE_ABS_MIN + 2)
#define PTREE_DUMMY_KEY (PTREE_ABS_MIN + 3)
#define PTREE_NULLPOS -1
#define PTREE_POSTYPE_MIN (INT_MIN +1)
#define PTREE_POSTYPE_MAX (INT_MAX -1)
//#define PTREE_DUMMY_POS -99

/*Insert Astrid*/
#define FVEC_LEN (unsigned short * 4)
#define MIN_LEN unsigned short
#define MAX_LEN unsigned short
/*Insert Ende*/

//#define POS_TYPE int
//#define KEY_TYPE int
typedef int POS_TYPE;
typedef DEF_KEY_TYPE_ KEY_TYPE;
typedef DEF_UNSIGNED_KEY_TYPE_ UNSIGNED_KEY_TYPE;
typedef unsigned short LENGTH_TYPE;
typedef int SUFFIXSTART_TYPE;

typedef map< KEY_TYPE, KEY_TYPE > AlterKeysMap;
typedef pair< KEY_TYPE, KEY_TYPE > KeyPair;
typedef pair< string, string > TIDPair;

typedef vector<string> StringVector;
typedef vector<KeyPair> KeyPairVector;
typedef vector<TIDPair> TIDPairVector;

#define CONTAINER_NUMPAIRS 1024
#define CONTAINER_TID_SIZE 18
#define CONTAINER_PAIRSIZE (( sizeof(KEY_TYPE) ) + CONTAINER_TID_SIZE)
#define CONTAINER_PAGE_SIZE (CONTAINER_NUMPAIRS * CONTAINER_PAIRSIZE) // ist günstig auch für Blockgrößen von 4kB auf der Platte

#define FILEOPENMODE_READWRITE 1
#define FILEOPENMODE_READ 2


//// wichtige Makros
/**
 *  geprüftes Löschen der Knoten
 *
 *  prüft, ob
 *  - der Zeiger NULL ist
 *  - ob posID != 0
 *  - ob posID != PTREE_TOMBSTONE ==> ist ein Hinweis darauf, daß der Knoten gerade vorher gelöscht wurde
 *  - vergleicht 0,1, oder 2 Zeiger
 *
 *  aus debuggingzwecken noch checkTombStone hinzugefügt
 *
 */
#define checkTombStone(zeiger) if(zeiger != NULL && zeiger->posID == PTREE_TOMBSTONE){cerr << "TOMBSTONE at " << zeiger << " ==> " << *zeiger << endl;}
#define checkActive(zeiger) if(zeiger != NULL && activeNodes.find((int)zeiger) == activeNodes.end() ){cerr << "Not in activeNodes... " << zeiger << " ==> " << *zeiger << endl;}

//#define checkPosDelete(zeiger) checkTombStone(zeiger) if(zeiger != NULL && zeiger->posID != PTREE_TOMBSTONE && zeiger->posID != 0){delete zeiger; zeiger = NULL;}
//#define checkPosCompDelete(zeiger, zeiger_to_compare) checkTombStone(zeiger) if(zeiger != NULL && zeiger->posID != PTREE_TOMBSTONE && zeiger->posID != 0 && zeiger != zeiger_to_compare){delete zeiger; zeiger = NULL;}
//#define checkPosComp2Delete(zeiger, zeiger_to_compare1, zeiger_to_compare2) checkTombStone(zeiger) if(zeiger != NULL && zeiger->posID != PTREE_TOMBSTONE && zeiger->posID != 0 && zeiger != zeiger_to_compare1 && zeiger != zeiger_to_compare2){delete zeiger; zeiger = NULL;}

//#define checkPosDelete(zeiger) if(zeiger != NULL && zeiger->posID != 0){delete zeiger; zeiger = NULL;}
//#define checkPosCompDelete(zeiger, zeiger_to_compare) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare){delete zeiger; zeiger = NULL;}
//#define checkPosComp2Delete(zeiger, zeiger_to_compare1, zeiger_to_compare2) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare1 && zeiger != zeiger_to_compare2){delete zeiger; zeiger = NULL;}

#define checkNotButDelete(zeiger) mPSpeicher->freeCharNode(zeiger)
#define checkPosDelete(zeiger) if(zeiger != NULL && zeiger->posID != 0){mPSpeicher->freeCharNode(zeiger);}
#define checkPosCompDelete(zeiger, zeiger_to_compare) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare){mPSpeicher->freeCharNode(zeiger);}
#define checkPosComp2Delete(zeiger, zeiger_to_compare1, zeiger_to_compare2) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare1 && zeiger != zeiger_to_compare2){mPSpeicher->freeCharNode(zeiger);}

// die _ext-Makros haben dieselbe Semantik, nur holen sie sich vorher mPSpeicher vom zu löschenden Zeiger ab
#define checkPosDelete_ext(zeiger) if(zeiger != NULL && zeiger->posID != 0){zeiger->mPSpeicher->freeCharNode(zeiger);}
#define checkPosCompDelete_ext(zeiger, zeiger_to_compare) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare){zeiger->mPSpeicher->freeCharNode(zeiger);}
#define checkPosComp2Delete_ext(zeiger, zeiger_to_compare1, zeiger_to_compare2) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare1 && zeiger != zeiger_to_compare2){zeiger->mPSpeicher->freeCharNode(zeiger);}

// löscht den Zeiger, wenn nicht root, dann return getKey
//#define return_getKey(zeiger) KEY_TYPE ret = zeiger->getKey();if(zeiger->posID != 0)delete zeiger;return ret
#define return_getKey(zeiger) KEY_TYPE ret = zeiger->getKey();if(zeiger->posID != 0){mPSpeicher->freeCharNode(zeiger);}return ret

#define streamout(X,Y) X << #Y << " == " << Y << endl


// Prototypen für die "flachen" Funktionen
// auf diese weise können hashChar und unhashChar einfach ausgetauscht werden
extern int hashChar(char c);
extern char unhashChar(POS_TYPE pos);
extern unsigned int getPrefixLength(const char * string1, const char * string2);
extern string getPrefixFromString(string& p_string);
extern bool special_debug;
extern bool global_var_use_odci;
extern bool getSubstValue(int p, int t);

// Funktionen für den Dateizugriff
extern bool fileexists(string& filename);
extern bool filecreate(string& filename);
extern FILE * openOrCreateFile(string& filename, int openmode /* = FILEOPENMODE_READWRITE */);

extern string packBits(const string& input);
extern string unpackBits(const char* input,int input_laenge, int startPos, int laenge);


/**
 * Variablen zur Bestimmung der Knotengröße
 * alle Variablen haben das Präfix "ns" für NodeSize, zur Unterscheidung
 *
 * Variable Werte zum Einstellen von außen
 * - nsIntSuffixSize
 * - nsInfixSize
 *
 * Geamtwerte:
 * - nsNodeSizeOnDisk
 * - nsNodePageSize
 * - nsSuffixPageSize (auch gleich mit definiert)
 *
 * die folgenden Variablen werden zum auffüllen der
 * - nsNormalNodeStuffBytes
 * - nsSuffixNodeStuffBytes
 * - nsInfixNodeStuffBytes
 *
 */

extern bool packBitsCompression;
extern bool packBitsCompression_for_Infixes;

extern int nsIntSuffixSize;
extern int nsIntSuffixStringLength; // für Alpha-Kompression
extern int nsInfixSize;
extern int nsInfixStringLength; // für Alpha-Kompression

extern int nsNodeSizeOnDisk;
extern int nsNodePageSize;
extern int nsSuffixPageSize;
extern int nsNodePagesInBuffer;
extern int nsSuffixPagesInBuffer;

extern int nsNodeBufferSize;
extern int nsSuffixBufferSize;

extern int nsStuffBytesNormalNode;
extern int nsStuffBytesSuffixNode;
extern int nsStuffBytesInfixNode;


/**
 * Eingabe: suffixSize und/oder infixSize
 * Ausgabe: obige Parameter werden gefüllt
 */
extern void nsCalculateNodeSizeParameters(
		int p_intSuffixSize,
		int p_infixSize,
		int p_nodePageSize,
		int p_suffixPageSize,
		int p_nodePagesInBuffer,
		int p_suffixPagesInBuffer);

/**
 * Implementiert das LRU-Verfahren für die Caches
 *
 * (auch für SuffixDiskPageBuffer, daher in globals.[hc]pp)
 */
class LRUList {
	// int bestimmt die aktuelle Nummer --> muß periodisch zurückgesetzt werden
	// POS_TYPE bestimmt die StartPos der Seite
	map<unsigned int, POS_TYPE> lruList;       // Position der Seite in der Reihenfolge
	map<POS_TYPE, unsigned int> lruList_index; // index-Liste --> welche Seite hat gerade welchen Wert?

public:
	POS_TYPE latest;
	LRUList(): latest(PTREE_NULLPOS){};

	void touch(POS_TYPE startPos);

	// ältestes Element ist das mit der kleinsten Nummer --> und das steht vorne
	// nehme per Default an, daß die Liste nicht leer ist
	POS_TYPE getOldest(){return lruList.begin()->second;}

	// jüngstes Element ist das mit der größten Nummer --> und das steht hinten
	// nehme per Default an, daß die Liste nicht leer ist
	POS_TYPE getLatest(){return lruList.rbegin()->second;}

	// entfernt die älteste Seite aus der LRU-Liste und liefert die startPos zurück
	POS_TYPE pop_oldest();
};




#endif

