// Watch.h : header file of the Watch class
//
// Copyright (c) Olaf Neuendorf 1997
//

#ifndef _WATCH_H_
#define _WATCH_H_

#ifdef _WIN32
	#define _WIN32_WINNT 0x0501
	#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

	#include <windows.h>
	#include <winnt.h>

#else

typedef union LI {
	struct {
		unsigned int LowPart;
		signed int HighPart;
	};
	long long QuadPart;
} LARGE_INTEGER;

#endif

#include <iostream>


/**
 * Dient der präzisen Zeitmessung.
 */
class /* EXPORT_API */ Watch
{
public:
	/**
	 * C'tor
	 */
	Watch ();
	~Watch ();
	/**
	 * gibt die Zeit seit dem letzten stamp() in Mikrosekunden aus
	 */
	double stamp ();		// Zeitdauer in MicroSekunden
private:
	bool 			stamped; // wenn schonmal gestampt, dann keine weitere ausgabe mehr
	bool			m_HighRes;		// true => high-resolution performance counter vorhanden.
	double			m_Frequency;	// der Kehrwert der Prozessorfrequenz in MHz.
	LARGE_INTEGER	m_PerformanceCount1;
	LARGE_INTEGER	m_PerformanceCount2;
};

#endif			// _WATCH_H_

