// Watch.cpp : implementation of the Watch class
//
// Copyright (c) Olaf Neuendorf 1997, 1998
//


//#include "stdafx.h"
#include "Watch.h"
//#include <windows.h>

#ifdef _WIN32
	#pragma warning(disable:4244)	// Konversion LONGLONG -> double
#endif
using namespace std;

Watch::Watch ()
{
#ifdef _WIN32
	LARGE_INTEGER Frequency;
	const double MHZ = 1000000;
	// ermittle, ob wir einen high-resolution performance counter haben:
	if (QueryPerformanceFrequency(&Frequency))
	{
		//cerr << "Watch::HighRes == true" << endl;
		m_HighRes = true;
		const LONGLONG freq = Frequency.QuadPart;
		m_Frequency = freq;
		m_Frequency = MHZ/m_Frequency;
	}
	else
		m_HighRes = false;

	m_PerformanceCount1.QuadPart = 0;
	m_PerformanceCount2.QuadPart = 0;

#else
	m_HighRes = false;
#endif


	stamp();	// Die erste Zeitmessung erfolgt sofort
	stamped = false;
}


Watch::~Watch ()
{
	if(!stamped) cout << "runtime == " << (stamp() / 1000) << " ms" << endl;
}


// Merkt sich die aktuelle Zeit und gibt das vergangene Intervall (in ms) zurück.
double Watch::stamp ()
{
	double	value;

	// Der letzte Wert wird umgespeichert, der vorletzte weggeworfen:
	m_PerformanceCount1 = m_PerformanceCount2;

#ifdef _WIN32
	if (m_HighRes)
	{
		QueryPerformanceCounter (&m_PerformanceCount2);
		// bestimme das letzte Intervall:
		LARGE_INTEGER li;
		li.QuadPart = m_PerformanceCount2.QuadPart - m_PerformanceCount1.QuadPart;
		value = li.QuadPart;
		value *= m_Frequency;
	}
	else
	{
		m_PerformanceCount2.LowPart = GetTickCount();
		// Achtung, GetTickCount liefert nur DWORD, also Überlauf alle 49.7 Tage möglich!
		if (m_PerformanceCount1.QuadPart > m_PerformanceCount2.QuadPart)
			m_PerformanceCount1.HighPart++;
		// bestimme das letzte Intervall:
		value = m_PerformanceCount2.QuadPart - m_PerformanceCount1.QuadPart;
	}
#else
		m_PerformanceCount2.LowPart = clock();
		// Achtung, GetTickCount liefert nur DWORD, also Überlauf alle 49.7 Tage möglich!
		if (m_PerformanceCount1.QuadPart > m_PerformanceCount2.QuadPart)
			m_PerformanceCount1.HighPart++;
		// bestimme das letzte Intervall:
		value = m_PerformanceCount2.QuadPart - m_PerformanceCount1.QuadPart;
#endif
	// falls wir zum allerersten Mal messen:
	if (m_PerformanceCount1.QuadPart == 0)
		value = 0;
	stamped = true;
	return value;	// Zeitdauer in MicroSekunden
}

#ifdef _WIN32
	#pragma warning(default:4244)
#endif

