#include "PTree.hpp"

#ifdef _WIN32
	#pragma warning(disable:4290)	// warning bzgl throw( XX ) ohne DLLSPEC
#endif


/**
 * Konstruktor<br/>
 * p_mode -> 'W' f�r Lesen/Schreiben, 'N' f�r NEU, 'R' nur Lesen
 */
PTree::PTree(string p_name, string p_schema, char p_mode){

	currentMaxKey = PTREE_MIN + 1;

	name = p_name;
	schema = p_schema;

	switch (p_mode) {
	case 'W':
		mPSpeicher = new PSpeicher(p_name,p_schema,p_mode);
		rootNode = mPSpeicher->newCharNodeByPos(0);
		//cerr << "PTree::PTree(,,) --> case 'W' finished, rootNode == " << (long)rootNode << endl;
		break;
	case 'R':
		mPSpeicher = new PSpeicher(p_name,p_schema,p_mode);
		rootNode = mPSpeicher->newCharNodeByPos(0);
		//cerr << "PTree::PTree(,,) --> case 'W' finished, rootNode == " << (long)rootNode << endl;
		break;
	case 'N':
		mPSpeicher = new PSpeicher(p_name,p_schema, 'N');
		rootNode = mPSpeicher->newCharNodeAppend();
		rootNode->writeNode();
		//cerr << "PTree::PTree(,,) --> case 'C' finished, rootNode == " << (long)rootNode << endl;
		break;
	case 'D': // DROP
		mPSpeicher = new PSpeicher(p_name,p_schema,p_mode);
		// hier sollten keine Files des Index' mehr vorhanden sein
		break;
	default:
		cerr << "PTree::PTree(,, '" << p_mode << "') switch default (terminating program now!)" << endl;
		exit(-1);
	}
}// PTree::PTree

/*
 * Destruktor
 */
PTree::~PTree(){
	// l�scht den Wurzelknoten
	mPSpeicher->freeCharNode(rootNode);
	delete mPSpeicher; // Speicher auch l�schen --> sonst kein flush()! (Dateizeiger freigeben)
}


/**
 * Dateien schlie�en
 */
void PTree::closefiles(){
	mPSpeicher->closeFiles();
}



/**
 * F�gt einen String mit einem gesetzten Schl�ssel ein.
 */
KEY_TYPE PTree::insertString(string& p_string, KEY_TYPE p_key){
	//if(special_debug)cerr << "insertString(" << p_string << ", " << p_key << ")" << endl;
	if (p_string == "")
		return -1;

	int zeichenAnzahl = p_string.length();
	if (zeichenAnzahl == 0)
		return -1;

	CharNode * zeiger = getRootNode();
	CharNode * tempZeiger; // f�r vor dem L�schen
	bool gleich = false;
	int infixStartAt = 0;

	int c = -1;
	unsigned int fvect[]={0,0,0,0};

	for (int i=0; i<zeichenAnzahl; ++i){
		bool changed = false;
		c = hashChar(p_string[i]);
		//if(special_debug) if(zeiger->hasKey())cerr << "Key == " << zeiger->getKey() << endl;
		//if(special_debug) cerr << "loop: c == " << p_string[i] << endl;
		// hier Standardschleife einbauen
		// und sowas wie "splitInfix" aufrufen
		++fvect[c];
		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){

			//if(special_debug)cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << ", p_string[" << i << "] == " << p_string[i] << endl;
			const string& infix(zeiger->getInfix());
			if(infix[i - infixStartAt] == p_string[i] ){
				// alles okay, einfach mal weiter absteigen
				if(i != zeichenAnzahl -1){
					continue;
				}
				else{
					//if(special_debug)cerr << "mitten im Infix verendet...!" << endl;
					// Split!
					// Methode "splitInfix" erstellen, die sich um das alles k�mmert!
					// --> Anfang, Ende, Split
					if((i-infixStartAt) == 0){
						if(infix.length() == 1){
							//if(special_debug){
							//	cerr << "EndeImInfix: InfixStart... && length == 1" << endl;
							//	cerr << "infix == " << infix << endl;
							//}
							// hier nur den Infix-Knoten auspacken
							CharNode * newNode = mPSpeicher->newCharNodeAppend();
							for(int j=0;j<MAXCHARS;++j){
								newNode->setChildPos(j,zeiger->getChildPos(j));
								zeiger->setChildPos(j, PTREE_NULLPOS);
							}
							zeiger->addChild(hashChar(infix[0]), newNode->posID);
							newNode->setFreqVect(zeiger->freqVector);
							zeiger->deleteInfix();
							zeiger->writeNode();
							newNode->writeNode();
							checkPosDelete(zeiger);
							zeiger = newNode;
							//if(special_debug)cerr << "EndeImInfix: InfixStart... (length==1) finished" << endl;
						}
						else{
							//if(special_debug){
							//	cerr << "EndeImInfix: InfixStart... && length > 1" << endl;
							//	cerr << "infix == " << infix << endl;
							//}

							// SF Anfang
							char charInfixBegin = infix[0];
							// neuer Infix
							CharNode * newInfixNode = mPSpeicher->newCharNodeAppend();
							// Infix verk�rzen um ein Zeichen
							if(infix.length() > 2){
								newInfixNode->setInfix(infix.substr(2));
							}
							// Verkn�pfungen in nach neuen Infix kopieren
							// beim alten Knoten alle auf NULL setzen
							for(int j=0;j<MAXCHARS;++j){
								newInfixNode->setChildPos(j,zeiger->getChildPos(j));
								zeiger->setChildPos(j, PTREE_NULLPOS);
							}
							newInfixNode->setFreqVect(zeiger->freqVector);
							newInfixNode->writeNode();

							CharNode * newVerbinder = mPSpeicher->newCharNodeAppend();
							newVerbinder->addChild(hashChar(infix[1]), newInfixNode->posID);

							// jetzt Infix
							zeiger->addChild(hashChar(charInfixBegin),newVerbinder->posID);
							zeiger->deleteInfix();

							newVerbinder->setFreqVect(zeiger->freqVector);
							newVerbinder->addOneToFreqVectPos(hashChar(charInfixBegin));
							zeiger->writeNode();
							newVerbinder->writeNode();



							checkPosDelete(newInfixNode);
							checkPosDelete(zeiger);
							zeiger = newVerbinder;
							//if(special_debug)cerr << "EndeImInfix: InfixStart... (length>1) finished" << endl;
							// an Zeiger wird dann der Rest angef�gt
							// --> also doch kein break;
						}
					}
					else if((i-infixStartAt) == (zeiger->infixLength -1)){
						//if(special_debug)cerr << "EndeImInfix: InfixEnd..." << endl;
						// Infix hat hier L�nge >1, da anderer Fall oben abgefragt wurde
						char charInfixLetzter = infix[infix.length()-1];
						string newInfix;
						if(infix.length()-1 /*2*/ > 0){
							newInfix = infix.substr(0,infix.length()-1);
						}

						// zuerst den letzten Knoten bauen
						CharNode * nLetzterKnoten = mPSpeicher->newCharNodeAppend();
						// Verkn�pfungen kopieren...
						for(int j=0;j<MAXCHARS;++j){
							nLetzterKnoten->setChildPos(j,zeiger->getChildPos(j));
							zeiger->setChildPos(j, PTREE_NULLPOS);
						}
						nLetzterKnoten->setFreqVect(zeiger->freqVector);
						nLetzterKnoten->writeNode();
						zeiger->addChild(hashChar(charInfixLetzter),nLetzterKnoten->posID);

						zeiger->setInfix(newInfix);
						zeiger->substrOneFromFreqVectPos(hashChar(charInfixLetzter));
						zeiger->writeNode();

						checkPosDelete(zeiger);
						zeiger = nLetzterKnoten;
						//if(special_debug)cerr << "EndeImInfix: InfixEnd... finished" << endl;
					}
					else{
						// [OK]
						//if(special_debug)cerr << "EndeImInfix: Infix Split..." << endl;
						// normaler Split
						// Infix (orig) + Verbinder(=Branch-Node) + Rest-Infix
						CharNode * nodeRestInfix = mPSpeicher->newCharNodeAppend();
						for(int j=0;j<MAXCHARS;++j){
							nodeRestInfix->setChildPos(j,zeiger->getChildPos(j));
							zeiger->setChildPos(j, PTREE_NULLPOS);
						}
						nodeRestInfix->setInfix(infix.substr(i-infixStartAt+2));
						nodeRestInfix->setFreqVect(zeiger->freqVector);
						nodeRestInfix->writeNode();

						CharNode * nodeVerbinder = mPSpeicher->newCharNodeAppend();
						nodeVerbinder->addChild(hashChar(infix[i-infixStartAt+1]), nodeRestInfix->posID);

						for (unsigned int j = i-infixStartAt;j <infix.length();++j ){
							zeiger->substrOneFromFreqVectPos(hashChar(infix[j]));
						}
						zeiger->setInfix(infix.substr(0,i-infixStartAt));
						zeiger->addChild(hashChar(infix[i-infixStartAt]), nodeVerbinder->posID);
						nodeVerbinder->setFreqVect(zeiger->freqVector);
						nodeVerbinder->addOneToFreqVectPos(hashChar(infix[i-infixStartAt]));
						zeiger->writeNode();
						checkPosDelete(nodeRestInfix);
						checkPosDelete(zeiger);
						nodeVerbinder->writeNode();
						zeiger = nodeVerbinder;
						//if(special_debug)cerr << "EndeImInfix: Infix Split... finished" << endl;
					}
					break;
				}// else-Zweig  (i != zeichenAnzahl -1)
			}
			else{
				// hier ungleich --> an der Stelle mu� der Infix gesplittet werden!
				// Sonderf�lle:
				// gleich am Anfang --> Infix um erstes Zeichen k�rzen, neuen Knoten f�r 1. Zeichen vorh�ngen
				//                  --> danach am alten Infix-Knoten weiter anf�gen (Rest-String)
				//
				// ganz am Ende --> zwei Knoten l�sen, erster als Branch (f�r neuen Knoten), zweiter altes Infix-Zeichen
				if((i-infixStartAt) == 0){
					//if(special_debug){
					//	cerr << "InfixStart..." << endl;
						//cerr << *zeiger << endl;
					//}
					// SF Anfang
					char charInfixBegin = infix[0];
					// neuer Infix
					CharNode * newNode = mPSpeicher->newCharNodeAppend();
					// Infix verk�rzen um ein Zeichen
					newNode->setInfix(infix.substr(1));

					// Verkn�pfungen in nach neuen Infix kopieren
					// beim alten Knoten alle auf NULL setzen
					for(int j=0;j<MAXCHARS;++j){
						newNode->setChildPos(j,zeiger->getChildPos(j));
						zeiger->setChildPos(j, PTREE_NULLPOS);
					}
					newNode->setFreqVect(zeiger->freqVector);
					// jetzt Infix
					zeiger->addChild(hashChar(charInfixBegin),newNode->posID);
					zeiger->deleteInfix();
					zeiger->suffixStart = -1;

					newNode->writeNode();
					zeiger->writeNode();

					//if(special_debug){
					//	cerr << *zeiger << endl;
					//	cerr << *newNode << endl;
					//}
					checkPosDelete(newNode);
					// an Zeiger wird dann der Rest angef�gt
					// --> also doch kein break;
				}
				else if((i-infixStartAt) == (zeiger->infixLength -1)){
					//if(special_debug)cerr << "InfixEnd..." << endl;
					// Infix hat hier L�nge >1, da anderer Fall oben abgefragt wurde
					char charInfixLetzter = infix[infix.length()-1];
					char charInfixVorletzter = infix[infix.length()-2];
					string newInfix;
					if(infix.length()-2 > 0){
						newInfix = infix.substr(0,infix.length()-2);
					}

					// zuerst den letzten Knoten bauen
					CharNode * nLetzterKnoten = mPSpeicher->newCharNodeAppend();
					// Verkn�pfungen kopieren...
					for(int j=0;j<MAXCHARS;++j){
						nLetzterKnoten->setChildPos(j,zeiger->getChildPos(j));
						zeiger->setChildPos(j, PTREE_NULLPOS);
					}
					nLetzterKnoten->setFreqVect(zeiger->freqVector);
					nLetzterKnoten->writeNode();

					// jetzt den vorletzten bauen --> an den mu� dann der Rest angeh�ngt werden
					CharNode * nVorLetzterKnoten = mPSpeicher->newCharNodeAppend();
					nVorLetzterKnoten->addChild(hashChar(charInfixLetzter), nLetzterKnoten->posID);
					nVorLetzterKnoten->setFreqVect(zeiger->freqVector);
					nVorLetzterKnoten->substrOneFromFreqVectPos(hashChar(charInfixLetzter));
					zeiger->addChild(hashChar(charInfixVorletzter),nVorLetzterKnoten->posID);
					zeiger->substrOneFromFreqVectPos(hashChar(charInfixLetzter));
					zeiger->substrOneFromFreqVectPos(hashChar(charInfixVorletzter));
					zeiger->setInfix(newInfix);
					zeiger->writeNode();
					nVorLetzterKnoten->writeNode();

					checkPosDelete(nLetzterKnoten);
					checkPosDelete(zeiger);
					zeiger = nVorLetzterKnoten;
				}
				else{
					//if(special_debug)cerr << "Infix Split..." << endl;
					// normaler Split
					// Infix (orig) + Verbinder(=Branch-Node) + Rest-Infix
					CharNode * nodeRestInfix = mPSpeicher->newCharNodeAppend();
					for(int j=0;j<MAXCHARS;++j){
						nodeRestInfix->setChildPos(j,zeiger->getChildPos(j));
						zeiger->setChildPos(j, PTREE_NULLPOS);
					}
					nodeRestInfix->setInfix(infix.substr(i-infixStartAt+1));
					nodeRestInfix->setFreqVect(zeiger->freqVector);
					nodeRestInfix->writeNode();

					CharNode * nodeVerbinder = mPSpeicher->newCharNodeAppend();
					nodeVerbinder->addChild(hashChar(infix[i-infixStartAt]), nodeRestInfix->posID);
					nodeVerbinder->setFreqVect(zeiger->freqVector);
					for(unsigned int j =i-infixStartAt;j<infix.length();++j ){
						nodeVerbinder->substrOneFromFreqVectPos(hashChar(infix[j]));
					}
					nodeVerbinder->writeNode();
					string newInfix;
					if(i-infixStartAt-1 > 0){
						newInfix = infix.substr(0,i-infixStartAt-1);
					}
					zeiger->setInfix(newInfix);
					zeiger->setFreqVect(nodeVerbinder->freqVector);
					zeiger->substrOneFromFreqVectPos(hashChar(infix[i-infixStartAt-1]));
					zeiger->addChild(hashChar(infix[i-infixStartAt-1]), nodeVerbinder->posID);
					zeiger->writeNode();
					checkPosDelete(nodeRestInfix);
					checkPosDelete(zeiger);
					zeiger = nodeVerbinder;
				}

			}
		}
		else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			infixStartAt = i+1;
		}
		else{
			infixStartAt = 0;
		}

		if(!zeiger->hasChild(c)){
			if(zeiger->hasSuffix()){
				//if(special_debug)cerr << "insertString() !hasChild(" << c << "), hasSuffix" << endl;
				const string& mSubString(p_string.substr(i));

				// L�nge des gemeinsamen Pr�fix der Suffixe berechnen
				unsigned int prefixLength = getPrefixLength(mSubString.c_str(), zeiger->getSuffix().c_str());

				// wenn der Pr�fix f�r beide Suffixe gleich lang ist und auch deren Zeichenl�nge entspricht,
				// dann liegt ein exakter Match vor --> es wird nur der Key des Zeigers zur�ckgegeben (unter
				// dann der zu speichernde Schl�ssel abgelegt werden kann)
				if ((prefixLength == mSubString.length()) && (prefixLength == zeiger->suffixLength)){
					return_getKey(zeiger); // zeiger->getKey()
				}

				// hier existiert ein gemeinsamer Pr�fix, die L�ngen der Suffixe sind jedoch unterschiedlich
				if (prefixLength >= 0){
					if(mSubString.length() > zeiger->suffixLength){
						// der gespeicherte Suffix ist Teil des neu einzuf�genden Strings
						tempZeiger = zeiger->unPackSuffixAndFollowBevorConcat(prefixLength);
						// wenn der Zeiger noch einen Suffix enth�lt, dann mu� der einen Knoten weiter nach unten verschoben werden
						// scheint ein Fehler im original-Algorithmus zu sein...
						if(tempZeiger->hasSuffix()){
							CharNode * tmpNode = mPSpeicher->newCharNodeAppend();
							tmpNode->setKey(tempZeiger->getKey());
							tempZeiger->setKey(PTREE_NULLKEY);
							tmpNode->setSuffix(tempZeiger->getSuffix().substr(1));
							tmpNode->setFreqVect(tempZeiger->freqVector);
							unsigned int tmpNodeSuffixLength = tmpNode->getSuffix().length();
							if(tmpNodeSuffixLength > (unsigned int)nsIntSuffixStringLength){
								tmpNode->suffixStart = tempZeiger->suffixStart +1;
								tmpNode->suffixLength = tempZeiger->suffixLength-1;
							}else if(tmpNodeSuffixLength > 0){
								tmpNode->suffixStart = -2; // nur interne Speicherung!
								tmpNode->suffixLength = tempZeiger->suffixLength-1;
							}
							tempZeiger->addChild(hashChar(tempZeiger->getSuffix()[0]), tmpNode->posID);
							tempZeiger->deleteSuffix();
							tempZeiger->suffixStart = -1; // wichtig!
							tempZeiger->suffixLength = 0; // wichtig! (wird jetzt durch setSuffix gesetzt

							tmpNode->writeNode(); // das hier m��te eigentlich reichen; der Suffix wurde ja schonmal geschrieben
							mPSpeicher->freeCharNode(tmpNode);
						}

						// aufr�umen; aber verhindern, da� der rootNode gel�scht wird
						checkPosCompDelete(zeiger, tempZeiger);
						zeiger = tempZeiger;
						zeiger->writeNodeAndSuffix(); // wirklich writeNodeAndSuffix() ??? m��te hier nicht auch writeNode ausreichen?
					}
					else{
						// der neu einzuf�gende String ist Teil eines bestehenden Suffix
						tempZeiger = zeiger->unPackSuffixAndFollow(prefixLength);
						// aufr�umen; aber verhindern, da� der rootNode gel�scht wird
						checkPosCompDelete(zeiger, tempZeiger);
						zeiger = tempZeiger;
					}
				}
				else{
					gleich = true;
				}
				//
				if (prefixLength > 0) {
					for (int j = 1; j < prefixLength;++j){
						fvect[hashChar(mSubString[j])]++;
					}
					i += prefixLength;
					changed =true;
				}
			}// hasSuffix

			if(zeiger->hasInfix()){
			//if(special_debug)cerr << "insertString() !hasChild(" << c << "), hasInfix()" << endl;
				// hier nur das letzte Infix-Zeichen auspacken
				CharNode * neuerKnoten = mPSpeicher->newCharNodeAppend();
				// Verweise kopieren
				for(int i=0;i<MAXCHARS;++i){
					neuerKnoten->setChildPos(i,zeiger->getChildPos(i));
					zeiger->setChildPos(i, PTREE_NULLPOS);
				}
				neuerKnoten->setFreqVect(zeiger->freqVector);
				neuerKnoten->writeNode();
				const string& oldInfix(zeiger->getInfix());
				zeiger->addChild(hashChar(*oldInfix.rbegin()), neuerKnoten->posID);
				zeiger->setInfix(string(oldInfix.begin(), oldInfix.end()-1));
				zeiger->substrOneFromFreqVectPos(hashChar(*oldInfix.rbegin()));
				zeiger->writeNode();
				checkPosDelete(zeiger);
				zeiger = neuerKnoten;
			}// hasInfix

			// jetzt Knoten anlegen
			if(i < zeichenAnzahl){
				//if(special_debug)cerr << "insertString() !hasChild(c), i<zeichenAnzahl" << endl;
				if(changed){
					c = hashChar(p_string[i]); // i hat sich wom�glich weiter oben ge�ndert
				}
				CharNode * neuerKnoten = mPSpeicher->newCharNodeAppend();
				zeiger->addChild(c,neuerKnoten->posID);

				// ist ein Suffix vorhanden? ->anh�ngen
				if (p_string.substr(i+1).length() > 0){
					neuerKnoten->setSuffix(p_string.substr(i+1));// kopiert (hoffentlich) den neuen Suffix
					for(unsigned int j=i+1;j < p_string.length();++j) fvect[hashChar(p_string[j])]++;
				}
				neuerKnoten->setFreqVect(fvect);
				if (changed) neuerKnoten->addOneToFreqVectPos(c);
				//neuerKnoten->writeNode();
				// Knoten auf Platte schreiben
				zeiger->writeNode();

				//if(special_debug){cerr << *zeiger << endl;}
				// aufr�umen; aber verhindern, da� der rootNode gel�scht wird
				checkPosDelete(zeiger);
				zeiger = neuerKnoten;
				//if(special_debug){cerr << *zeiger << endl;}
			}// (i < zeichenAnzahl)

			break;
		}// !hasChild(c)

		tempZeiger = mPSpeicher->newCharNodeByPos(zeiger->getChildPos(c));
		// aufr�umen; aber verhindern, da� der rootNode gel�scht wird
		checkPosDelete(zeiger);
		zeiger = tempZeiger;
	}// for
	// text ist zu ende

	//if(special_debug)cerr << "insertString() loop finished" << endl;

	if(zeiger->hasKey()){
		if(zeiger->hasSuffix()){
			if(gleich){
				//if(special_debug)cerr << "insertString() hasKey, hasSuffix, gleich" << endl;
				// makro
				return_getKey(zeiger);
			}
			else{
				//if(special_debug)cerr << "insertString() hasKey, hasSuffix, !gleich" << endl;
				//nur eins auspacken
				CharNode * ret = zeiger->unPackSuffixAndFollow(0);
				//delete ret; // kann an der Stelle nicht der rootknoten sein (ABER zeiger!)
				checkPosCompDelete(ret, zeiger);
			}
		}
		else{
			//if(special_debug)cerr << "insertString() hasKey, !hasSuffix" << endl;
			// makro
			return_getKey(zeiger);
		}
	}

	if(zeiger->hasInfix()){
		//if(special_debug)cerr << "insertString() hasInfix" << endl;
		// erstes Infix-Zeichen auspacken
		// SF Anfang
		const string& infix(zeiger->getInfix());
		char charInfixBegin = infix[0];
		// neuer Infix
		CharNode * newNode = mPSpeicher->newCharNodeAppend();
		// Infix verk�rzen um ein Zeichen
		newNode->setInfix(infix.substr(1));
		newNode->setFreqVect(zeiger->freqVector);

		// Verkn�pfungen in nach neuen Infix kopieren
		// beim alten Knoten alle auf NULL setzen
		for(int i=0;i<MAXCHARS;++i){
			newNode->setChildPos(i,zeiger->getChildPos(i));
			zeiger->setChildPos(i, PTREE_NULLPOS);
		}
		// jetzt Infix
		zeiger->addChild(hashChar(charInfixBegin),newNode->posID);
		zeiger->deleteInfix();
		zeiger->suffixStart = -1;

		newNode->writeNode();
		zeiger->writeNode();

		checkPosDelete(newNode);
		// an Zeiger wird dann der Rest angef�gt
		// --> also doch kein break;
	}

	//if(special_debug)cerr << "insertString() !hasKey" << endl;

	// Schl�ssel setzen && Knoten schreiben
	zeiger->setKey(p_key);
	zeiger->writeNodeAndSuffix();
	checkPosDelete(zeiger); // makro
	//if(special_debug)cerr << "insertString() finished" << endl;
	return p_key;
}//PTree::insert()

/**
 * F�gt den String ein, key wird automatisch ermittelt; setzt die Methode insert ein.
 *
 */
KEY_TYPE PTree::insertStringOrder(string& p_string) throw (KollisionException) {
	//if(special_debug)cerr << "insertString(" << p_string << ")" << endl;

#ifdef USE_CACHE
	//if(mPSpeicher->allNodes.size() > 2000){
		for(map<POS_TYPE, CharNode*>::iterator it = mPSpeicher->allNodes.begin(); it != mPSpeicher->allNodes.end(); ++it){
			if(it->first != 0){
				delete (CharNode*)it->second;
			}
		}
		//map<POS_TYPE, CharNode*> * tmpMap = new map<POS_TYPE, CharNode*>;
		map<POS_TYPE, CharNode*> tmpMap;
		mPSpeicher->allNodes.swap(tmpMap);
		//delete tmpMap;
	//}
#endif

	KeyPair kp = select_lt_gt(p_string);
	KEY_TYPE key_vor = kp.first;
	KEY_TYPE key_nach = kp.second;
	/*
	KEY_TYPE key_vor = select_lt(p_string);
	KEY_TYPE key_nach = select_gt(p_string);
	*/
	KEY_TYPE neuerKey = key_vor + ((key_nach/2 - key_vor/2)); // nicht vereinfachen wg. Datentyp

	//cerr << (key_nach/2 - key_vor/2) << endl;

	//if(special_debug){
	//	cerr << "1 key_vor  == " << key_vor << endl;
	//	cerr << "2 key_nach == " << key_nach << endl;
	//	cerr << "3 neuerKey == " << neuerKey << endl;
	//}


	if(neuerKey <= key_vor || neuerKey >= key_nach){
		cerr << "throw KollisionException;" << endl;
		cerr << "1 key_vor  == " << key_vor << endl;
		cerr << "2 key_nach == " << key_nach << endl;
		cerr << "3 neuerKey == " << neuerKey << endl;

		throw KollisionException();
	}
	return insertString(p_string, neuerKey);
}//PTree::insertStringOrder()

/**
 * F�gt den String ein, der Schl�ssel ist ein Nachfolger des zuletzt gebrauchten
 */
KEY_TYPE PTree::insertStringSeq(string& p_string){
	currentMaxKey += 1024*1024; // sollte bei den 64Bit-Schl�sseln erstmal reichen
	KEY_TYPE neuerKey = currentMaxKey;
	return insertString(p_string, neuerKey);
}//PTREE::insertStringSeq()


/**
 * Sortierung der Keys �berpr�fen
 */
void PTree::checkTree(){
	getRootNode()->checkNodeNumbering(PTREE_MIN -1, PTREE_NULLPOS);
}


// sucht nach der exakten Repr�sentation des Strings
// liefert den key-Wert zur�ck, PTREE_NULLKEY bei Mi�erfolg

KEY_TYPE PTree::select_eq(string& p_string){
//	cerr << "select_eq() start" << endl;
	if(p_string.empty() || p_string.length() == 0){
		return PTREE_NULLKEY;
	}

	CharNode * zeiger = rootNode;
	int zeichenAnzahl;
	int infixStartAt = 0;
	int c;
	zeichenAnzahl = p_string.length();
	for(int i=0;i < zeichenAnzahl; ++i){
		c = hashChar(p_string[i]);
//		cerr << "select_eq(): c == " << c << ", p_string[" << i << "] == " << p_string[i] << endl;
		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
//			cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				continue;
			}else{
				checkPosDelete(zeiger); // makro
				return PTREE_NULLKEY;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}
		if(zeiger->hasChild(c)){
			CharNode * neuerZeiger = mPSpeicher->newCharNodeByPos(zeiger->getChildPos(c));
			checkPosDelete(zeiger);
			zeiger = neuerZeiger;
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				if(zeiger->suffixCompareTo(rest) == 0){
					return_getKey(zeiger); // makro
				}
			}
			checkPosDelete(zeiger);
			return PTREE_NULLKEY;
		}
	}// for

	// wenn hier angekommen, dann mu� ich nur noch feststellen
	// ob der Knoten einen key hat
	// zum Suffix: wenn am Key ein Suffix dranklebt, dann gilt der Key
	// f�r das Ende des Suffix
	if(zeiger->hasKey() && !zeiger->hasSuffix()){
		return_getKey(zeiger);
	}else{
		checkPosDelete(zeiger);
		return PTREE_NULLKEY;
	}
}

/**
 * Sucht den n�chstkleineren und den n�chstgr��eren Key zusammen heraus (haben schlie�lich oft den gleichen Weg)
 */
KeyPair PTree::select_lt_gt(string& p_string){
//	if(special_debug)cerr << "PTree::select_lt_gt(" << p_string << ")" << endl;
	if(p_string.empty() || p_string.length() == 0){
		return KeyPair(PTREE_NULLKEY, PTREE_NULLKEY);
	}

	CharNode * zeiger = rootNode;

	// Links auf den n�chstgr��eren Geschwisterknoten, falls vorhanden
	POS_TYPE nextBranchPos = PTREE_NULLPOS;
	POS_TYPE lastNextBranchPos = PTREE_NULLPOS;

	// Links auf den n�chstkleineren Geschwisterknoten, falls vorhanden
	POS_TYPE previousBranchPos = PTREE_NULLPOS;
	POS_TYPE lastPreviousBranchPos = PTREE_NULLPOS;

	// R�ckgabewerte
	KEY_TYPE ret_lt = PTREE_NULLKEY;
	KEY_TYPE ret_gt = PTREE_NULLKEY;

	// Abbruchbedingungen
	bool loop_finished_lt = false;
	bool loop_finished_gt = false;

	// kontrolliert, wann der letzte Schl�ssel im Baum gesehen wurde
	KEY_TYPE lastkey = PTREE_NULLKEY;
	KEY_TYPE verylastkey = PTREE_NULLKEY;
	KEY_TYPE lastkeyWithBranch = PTREE_NULLKEY;

	int infixStartAt = 0;
	bool gt_groesser = false;
	bool groesser = false;
	bool kleiner = false;


	int zeichenAnzahl = p_string.length();
	int c,i;

	for(i=0; i<zeichenAnzahl;++i){
		c = hashChar(p_string[i]);

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		// Standard-Konstrukt zur Infix-Behandlung
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){

			//if(special_debug)cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << ", p_string[" << i << "] == " << p_string[i] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
					gt_groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}
		// Ende Infix-Behandlung

		// gr��eren Knoten Suchen und ggf. speichern
		nextBranchPos = zeiger->getLexNextChildPos(c);
		if(nextBranchPos != PTREE_NULLPOS && !zeiger->hasInfix()){
			lastNextBranchPos = nextBranchPos;
			//if(special_debug)cerr << "lastNextBranchPos == " << endl << lastNextBranchPos << endl;
		}

		// kleineren Knoten Suchen und ggf. speichern
		previousBranchPos = zeiger->getLexPreviousChildPos(c);
		if(previousBranchPos != PTREE_NULLPOS && !zeiger->hasInfix()){
			lastPreviousBranchPos = previousBranchPos;
			lastkey = PTREE_NULLKEY;
			verylastkey = PTREE_NULLKEY;
			//if(special_debug)cerr << "lastPreviousBranchPos == " << endl << lastPreviousBranchPos << endl;
		}

		if(zeiger->hasChild(c)){
			CharNode * tempZeiger = zeiger->getChild(c);
			checkPosDelete(zeiger);
			zeiger = tempZeiger;
			//cerr << "zeiger == " << endl << *zeiger << endl;
			if(zeiger->hasKey() && !zeiger->isLeave() /* && i != zeichenAnzahl-1 */){
				verylastkey = lastkey;
				lastkey = zeiger->getKey();
				//if(special_debug)cerr << "lastkey == " << lastkey << endl;
			}
		}else{

			//if(special_debug){cerr << "!hasChild(" << c << ") zeiger == " << endl  << *zeiger << endl ;}
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				int vergleich = zeiger->suffixCompareTo(rest);
				//if(special_debug){cerr << "hasSuffix() vergleich == " <<  vergleich << endl;}
				// Strings sind gleich? dann den n�chstgr��eren finden
				if( vergleich == 0){
					gt_groesser = true;
					loop_finished_gt = true;
				}
				// der Suchstring ist lex. kleiner --> also kann ich den Key gleich zur�ckgeben
				if(vergleich > 0){
					lastNextBranchPos = PTREE_NULLPOS;
					ret_gt = zeiger->getKey();
				}

				if( vergleich >= 0){
					loop_finished_lt = true;
				}
				// der Suchstring ist lex. gr��er --> also kann ich den Key gleich zur�ckgeben
				if(vergleich < 0){
					lastPreviousBranchPos = PTREE_NULLPOS;
					ret_lt = zeiger->getKey();
				}

			} // zeiger->hasSuffix()
			// hier ist der Suchstring lexicographisch gr��er --> mu� also vom letzten bekannten
			// Branch ausgehen, dort den kleinsten Key zu finden
			if(!loop_finished_gt && ret_gt == PTREE_NULLKEY){
				gt_groesser = true;
			}

			CharNode * prevChild = zeiger->getLexPreviousChild(c);
			if(prevChild != NULL){
				ret_lt = prevChild->getLexMaxChild();
				checkPosDelete(prevChild);
				// zus�tzlich eingef�gt
				lastPreviousBranchPos = PTREE_NULLPOS;
			}

			// geht hier um ret_gt!
			if(zeiger->hasInfix()){
				CharNode * nextChild = zeiger->getLexNextChild(c);
				if(nextChild != NULL){
					ret_gt = zeiger->getLexFirstMinChild();
					checkPosDelete(nextChild);
				}
			}

			if(ret_lt == PTREE_NULLKEY && !loop_finished_lt){
				if(zeiger->hasKey()){
					//if(special_debug)cerr << "zeiger->hasKey() *zeiger == " << endl << *zeiger << endl;
					lastPreviousBranchPos = PTREE_NULLPOS;
					ret_lt = zeiger->getKey();
				}
			}
			//if(special_debug){cerr << "ret_lt == " << ret_lt << endl << "ret_gt == " << ret_gt << endl;}
			break;
		}// hasChild(c)
	}// for

	//if(special_debug){cerr << "select_lt_gt: loop finished!" << endl;}

	// hier also am Ende angekommen...
	// erstmal Behandlung f�r gt
	// entweder ist der Suchstring zu Ende oder ich hab nix gefunden
	if(ret_gt == PTREE_NULLKEY){
		if (gt_groesser == true){
			//if(special_debug)cerr << "1" << endl;
			if(lastNextBranchPos != PTREE_NULLPOS && lastNextBranchPos != PTREE_POSTYPE_MAX){
				CharNode * tmpNode = mPSpeicher->newCharNodeByPos(lastNextBranchPos);
				ret_gt = tmpNode->getLexFirstMinChild();
				checkPosDelete(tmpNode);
			}else{
				ret_gt = PTREE_MAX;
			}
		}else{
			if(zeiger->isLeave()){
				// diesen Block hier eingef�gt
				if(zeiger->hasKey() && zeiger->hasSuffix()){
					ret_gt = zeiger->getKey();
				}else{
					// hier sind ist der Suchstring gleich dem gefundenen --> schlecht
					if(lastNextBranchPos != PTREE_NULLPOS && lastNextBranchPos != PTREE_POSTYPE_MAX){
						CharNode * tmpNode = mPSpeicher->newCharNodeByPos(lastNextBranchPos);
						ret_gt = tmpNode->getLexFirstMinChild();
						checkPosDelete(tmpNode);
					}else{
						ret_gt = PTREE_MAX;
					}
				}
			}else{
				// es geht weiter --> jedes kleinste Blatt ist jetzt gr��er als der Suchstring
				CharNode * tmp = zeiger->getLexFirstChild();
				KEY_TYPE ret = (tmp?tmp->getLexFirstMinChild():PTREE_MAX);
				checkPosDelete(tmp);
				ret_gt = ret;
			}
		}
	}

	//if(special_debug)cerr << "LT... " << endl;
	// kann schon weg
	if(ret_lt == PTREE_NULLKEY){
		if(groesser){
			ret_lt = zeiger->getLexMaxChild();
		}else if(verylastkey != PTREE_NULLKEY && zeiger->hasKey() && !zeiger->hasSuffix()){
			ret_lt = verylastkey;
		}else if(lastkey != PTREE_NULLKEY && lastkey != lastkeyWithBranch && (!zeiger->hasKey() || zeiger->hasSuffix())){
			ret_lt = lastkey;
		}else if(lastPreviousBranchPos != PTREE_NULLPOS && lastPreviousBranchPos != PTREE_POSTYPE_MIN){
			CharNode * tmpNode = mPSpeicher->newCharNodeByPos(lastPreviousBranchPos);
			ret_lt = tmpNode->getLexMaxChild();
			checkPosDelete(tmpNode);
		}else{
			ret_lt = PTREE_MIN;
		}
	}

	checkPosDelete(zeiger);

	// Programmabbruch, wenn das hier schief geht...
	if(ret_lt >= ret_gt){
		cerr << "ret_lt >= ret_gt f�r " << p_string << endl;
		streamout(cerr, ret_lt);
		streamout(cerr, ret_gt);
		exit(-1);
	}

//	if(special_debug){cerr << "ret_lt == " << ret_lt << endl << "ret_gt == " << ret_gt << endl;}
//	if(special_debug)cerr << "PTree::select_lt_gt(" << p_string << ") end" << endl;
	return KeyPair(ret_lt, ret_gt);
}

/**
 * Sucht den n�chstgr��eren Key f�r den �bergebenen String heraus.
 */
KEY_TYPE PTree::select_gt(string& p_string){
	//cerr << "PTree::select_gt(" << p_string << ")" << endl;
	if(p_string.empty() || p_string.length() == 0){
		return PTREE_NULLKEY;
	}
	CharNode * zeiger = rootNode;
	CharNode * nextBranch = NULL;
	CharNode * lastNextBranch = NULL;
	int zeichenAnzahl = p_string.length();
	int infixStartAt = 0;
	int c,i;

	bool groesser = false;
	bool kleiner = false;

	for (i=0;i<zeichenAnzahl; ++i){
		c = hashChar(p_string[i]);
		//cerr << p_string[i] << endl;

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
			//cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}


		nextBranch = zeiger->getLexNextChild(c /*, string("select_gt @ 307" )*/);
		if(nextBranch != NULL){
			// wird vorher aufger�umt
			checkPosDelete(lastNextBranch);
			lastNextBranch = nextBranch;
		}
		if(zeiger->hasChild(c)){
			// Baum absteigen
			CharNode * tempZeiger = zeiger->getChild(c/*, string("select_gt @ 315" )*/);
			checkPosDelete(zeiger);
			zeiger = tempZeiger;
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				int vergleich = zeiger->suffixCompareTo(rest);
				// Strings sind gleich? dann den n�chstgr��eren finden
				if( vergleich == 0){
					groesser = true;
					break;
				}
				// der Suchstring ist lex. kleiner --> also kann ich den Key gleich zur�ckgeben
				if(vergleich > 0){ // weil durch suffixCompare umgedreht
					checkPosDelete(lastNextBranch);
					return_getKey(zeiger);
				}
			}
			// hier ist der Suchstring lexicographisch gr��er --> mu� also vom letzten bekannten
			// Branch ausgehen, dort den kleinsten Key zu finden
			groesser = true;
			break;
		}
	} // for

	// Fertig und nichts gefunden
	// entweder ist der Suchstring zu Ende oder ich hab nix gefunden
	// ... oder ein Infix-Vergleich hat nicht geklappt
	if (groesser == true){
		KEY_TYPE ret = (lastNextBranch?lastNextBranch->getLexFirstMinChild():PTREE_MAX);
		checkPosDelete(lastNextBranch);
		checkPosDelete(zeiger);
		return ret;
	}else{
		if(zeiger->isLeave()){
			// diesen Block hier eingef�gt
			if(zeiger->hasKey() && zeiger->hasSuffix()){
					checkPosDelete(lastNextBranch);
					return_getKey(zeiger);
			}
			// hier sind ist der Suchstring gleich dem gefundenen --> schlecht
			KEY_TYPE ret = (lastNextBranch?lastNextBranch->getLexFirstMinChild():PTREE_MAX);
			checkPosDelete(lastNextBranch);
			checkPosDelete(zeiger);
			return ret;
		}else{
			// es geht weiter --> jedes kleinste Blatt ist jetzt gr��er als der Suchstring
			CharNode * tmp = zeiger->getLexFirstChild();
			KEY_TYPE ret = (tmp?tmp->getLexFirstMinChild():PTREE_MAX);
			checkPosDelete(tmp);
			checkPosDelete(zeiger);
			checkPosDelete(lastNextBranch);
			return ret;
		}// else zeiger->isLeave()
	}// else groesser
}// select_gt

/**
 * Sucht den n�chstgr��eren oder gleichen Key f�r den String heraus
 */
KEY_TYPE PTree::select_egt(string& p_string){
	//cerr << "select_egt(" << p_string << ")" << endl;
	if(p_string.empty() || p_string.length() == 0){
		return PTREE_NULLKEY;
	}
	CharNode * zeiger = rootNode;
	CharNode * nextBranch = NULL;
	CharNode * lastNextBranch = NULL;
	int zeichenAnzahl = p_string.length();
	int c,i;

	int infixStartAt = 0;
	bool groesser = false;
	bool kleiner = false;

	for (i=0;i<zeichenAnzahl; ++i){
		c = hashChar(p_string[i]);

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
			//cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}

		nextBranch = zeiger->getLexNextChild(c);
		if(nextBranch != NULL){
			// wird vorher aufger�umt
			checkPosDelete(lastNextBranch);
			lastNextBranch = nextBranch;
		}
		if(zeiger->hasChild(c)){
			// Baum absteigen
			CharNode * tempZeiger = zeiger->getChild(c);
			checkPosDelete(zeiger);
			zeiger = tempZeiger;
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				int vergleich = zeiger->suffixCompareTo(rest);

				// der Suchstring ist lex. kleiner oder gleich --> also kann ich den Key gleich zur�ckgeben
				if(vergleich >= 0){
					checkPosDelete(lastNextBranch);
					return_getKey(zeiger);
				}
			}
			// hier ist der Suchstring lexicographisch gr��er --> mu� also vom letzten bekannten
			// Branch ausgehen, dort den kleinsten Key zu finden
			groesser = true;
			break;
		}
	}//for

	// Fertig und nichts gefunden
	// entweder ist der Suchstring zu Ende oder ich hab nix gefunden
	if (groesser == true){
		KEY_TYPE ret = (lastNextBranch?lastNextBranch->getLexFirstMinChild():PTREE_MAX);
		checkPosDelete(lastNextBranch);
		checkPosDelete(zeiger);
		return ret;
	}else{
		checkPosDelete(lastNextBranch);
		if(zeiger->hasKey()){
			// hier sind ist der Suchstring gleich dem gefundenen --> schlecht
			return_getKey(zeiger);
		}else{
			// es geht weiter --> jedes kleinste Blatt ist jetzt gr��er als der Suchstring
			CharNode * tmp = zeiger->getLexFirstChild();
			KEY_TYPE ret = (tmp?tmp->getLexFirstMinChild():PTREE_MAX);
			checkPosDelete(tmp);
			checkPosDelete(zeiger);
			return ret;
		}
	}
}// select_egt


/**
 * Sucht den n�chstkleineren Key f�r den String heraus
 */
KEY_TYPE PTree::select_lt(string& p_string){
	//cerr << "select_lt()..." << endl;
	if(p_string.empty() || p_string.length() == 0){
		return PTREE_NULLKEY;
	}
	CharNode * zeiger = rootNode;
	CharNode * previousBranch = NULL;
	CharNode * lastPreviousBranch = NULL;
	int zeichenAnzahl = p_string.length();
	int infixStartAt = 0;
	int c,i;
	KEY_TYPE lastkey = PTREE_NULLKEY;
	KEY_TYPE verylastkey = PTREE_NULLKEY;
	bool groesser = false;
	bool kleiner = false;

	for (i=0;i<zeichenAnzahl; ++i){
		c = hashChar(p_string[i]);

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
			//cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}

		previousBranch = zeiger->getLexPreviousChild(c/*, string("select_lt @ 476")*/);
		if(previousBranch != NULL){
			// wird vorher aufger�umt
			checkPosDelete(lastPreviousBranch);
			lastPreviousBranch = previousBranch;
			lastkey = PTREE_NULLKEY;
			verylastkey = PTREE_NULLKEY;
		}
		if(zeiger->hasChild(c)){
			// Baum absteigen
			CharNode * tempZeiger = zeiger->getChild(c/*, string("select_lt @ 485")*/);
			checkPosCompDelete(zeiger, lastPreviousBranch);
			zeiger = tempZeiger;

			// Knackpunkt hier: wenn der String matcht, dann den key nicht als lastkey abspeichern!
			if(zeiger->hasKey() && !zeiger->isLeave() /* && i != zeichenAnzahl-1 */){
				verylastkey = lastkey;
				lastkey = zeiger->getKey();
			}
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				int vergleich = zeiger->suffixCompareTo(rest);
				// Strings sind gleich? dann den n�chstgr��eren finden
				if( vergleich >= 0){
					break;
				}
				// der Suchstring ist lex. gr��er --> also kann ich den Key gleich zur�ckgeben
				if(vergleich < 0){
					//if(lastPreviousBranch != NULL) checkPosDelete(lastPreviousBranch);
					checkPosDelete(lastPreviousBranch);
					return_getKey(zeiger);
				}
			}
			// den n�chsten Block aus select_lt_gt eingef�gt
			CharNode * prevChild = zeiger->getLexPreviousChild(c);
			if(prevChild != NULL){
				KEY_TYPE ret;
				if(prevChild->hasChildren()){
					ret = prevChild->getLexMaxChild();
				}else{
					ret = prevChild->getKey();
				}
				checkPosDelete(prevChild);
				checkPosCompDelete(lastPreviousBranch, zeiger);
				checkPosDelete(zeiger);
				return ret;
			}

			if(zeiger->hasKey()){
				checkPosDelete(lastPreviousBranch);
				return_getKey(zeiger);
			}
			break;
		}// zeiger->hasChild()
	} // for

	// wenn der Suchstring gr��er ist als der Infix, dann der Verlinkung des
	// Infix folgen und den gr��ten Key zur�ckgeben
	if(groesser == true){
		// LPB wurde noch nicht gel�scht...
		checkPosCompDelete(lastPreviousBranch, zeiger);
		// es gibt nur einen Link...
		CharNode * n = zeiger->getLexFirstChild();
		KEY_TYPE ret = n->getLexMaxChild();
		checkPosDelete(n);
		checkPosDelete(zeiger);
		return ret;
	}

	// wenn der Suchstring kleiner als der Infix ist, dann den lastpreviousbranch nehmen
	// ... das geht so wie normal

	// kann schon weg
	bool zeigerHasKey = false;
	bool zeigerHasSuffix = false;
	if(zeiger->hasKey()) zeigerHasKey = true;
	if(zeiger->hasSuffix()) zeigerHasSuffix = true;
	checkPosDelete(zeiger);

	if(verylastkey != PTREE_NULLKEY && zeigerHasKey && !zeigerHasSuffix){
		checkPosDelete(lastPreviousBranch);
		return verylastkey;
	}
	if(lastkey != PTREE_NULLKEY && (!zeigerHasKey || zeigerHasSuffix)){
		checkPosDelete(lastPreviousBranch);
		return lastkey;
	}
	if(lastPreviousBranch){
		KEY_TYPE ret = lastPreviousBranch->getLexMaxChild();
		checkPosDelete(lastPreviousBranch);
		return ret;
	}else{
		return PTREE_MIN;
	}
}// select_lt

/**
 * Sucht den n�chstkleineren oder gleichen Key f�r den String heraus
 */
KEY_TYPE PTree::select_elt(string& p_string){
	//cerr << "select_elt(" << p_string << ")" << endl;
	if(p_string.empty() || p_string.length() == 0){
		return PTREE_NULLKEY;
	}
	CharNode * zeiger = rootNode;
	CharNode * previousBranch = NULL;
	CharNode * lastPreviousBranch = NULL;
	int zeichenAnzahl = p_string.length();
	int infixStartAt = 0;
	int c,i;
	bool groesser = false;
	bool kleiner = false;

	KEY_TYPE verylastkey = PTREE_NULLKEY;
	// ist quasi ein verschleppter lastkey, da der aktuelle lastkey auch
	// mit einem ung�ltigen Key (suffix-behaftet) �berschrieben werden kann --> f�r
	// den Fall brauche ich den vorletzten Key

	KEY_TYPE lastkey = PTREE_NULLKEY;

	for (i=0;i<zeichenAnzahl; ++i){
		c = hashChar(p_string[i]);

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
			//cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}

		previousBranch = zeiger->getLexPreviousChild(c);
		if(previousBranch != NULL){
			// wird vorher aufger�umt
			checkPosDelete(lastPreviousBranch);
			lastPreviousBranch = previousBranch;
			lastkey = PTREE_NULLKEY;
			verylastkey = PTREE_NULLKEY;
		}
		if(zeiger->hasChild(c)){
			CharNode * tempZeiger = zeiger->getChild(c);
			checkPosDelete(zeiger);
			zeiger = tempZeiger;
			if(zeiger->hasKey()){
				verylastkey = lastkey;
				lastkey = zeiger->getKey();
			}
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				int vergleich = zeiger->suffixCompareTo(rest);

				// der Suchstring ist lex. kleiner oder gleich --> also kann ich den Key gleich zur�ckgeben
				if(vergleich <= 0){
					// hier m��te eigentlich das return rein
					checkPosDelete(lastPreviousBranch);
					return_getKey(zeiger);
					//break;
				}
			}
			break;
		}
	}//for

	// wenn der Suchstring gr��er ist als der Infix, dann der Verlinkung des
	// Infix folgen und den gr��ten Key zur�ckgeben
	if(groesser == true){
		// LPB wurde noch nicht gel�scht...
		checkPosCompDelete(lastPreviousBranch, zeiger);
		// es gibt nur einen Link...
		CharNode * n = zeiger->getLexFirstChild();
		KEY_TYPE ret = n->getLexMaxChild();
		checkPosDelete(n);
		checkPosDelete(zeiger);
		return ret;
	}

	// Fall: bin an Knoten mit Key und Suffix angekommen --> bedeutet, da� der Key zum Suffix geh�rt
	// ==> aber auch, da� der Resultierende String auf jeden Fall gr��er ist
	// ist f�r den Fall, da� der String falsch eingef�gt ist; sollte in der aktuellen Version nicht mehr vorkommen
	if(zeiger->hasSuffix()){
		if(verylastkey != PTREE_NULLKEY){
			checkPosDelete(zeiger);
			//if(lastPreviousBranch != NULL) delete lastPreviousBranch;
			checkPosDelete(lastPreviousBranch);
			return verylastkey;
		}

		if(lastPreviousBranch){
			KEY_TYPE ret = lastPreviousBranch->getLexMaxChild();
			checkPosDelete(lastPreviousBranch);
			checkPosDelete(zeiger);
			return ret;
		}else{
			// alles, was k�rzer ist als mein Suchstring ist auch kleiner
			checkPosDelete(zeiger);
			return PTREE_MIN;
		}
	}

	// kann schon weg
	checkPosDelete(zeiger);

	if(lastkey != PTREE_NULLKEY){
		//if(lastPreviousBranch != NULL) delete lastPreviousBranch;
		checkPosDelete(lastPreviousBranch);
		return lastkey;
	}
	if(lastPreviousBranch){
		KEY_TYPE ret = lastPreviousBranch->getLexMaxChild();
		checkPosDelete(lastPreviousBranch);
		return ret;
	}else{
		return PTREE_MIN;
	}
}// select_elt


/**
 * Numeriert _alle_ keys des Baums neu. Danach sollte zwischen den Keys wieder Platz sein f�r neue.
 */
AlterKeysMap * PTree::updateAllKeys(int numberOfKeys){
	//int number_of_keys = getRootNode()->getNumberOfKeys();
	KEY_TYPE interval = (KEY_TYPE)((UNSIGNED_KEY_TYPE)(PTREE_UMAX-20) / (UNSIGNED_KEY_TYPE)(numberOfKeys + 2)); //  * 2;
	KEY_TYPE keyToUse = PTREE_MIN + interval;
	cerr << "PTree::updateAllKeys()" << endl;
	cerr << "numberOfKeys == " << numberOfKeys << ", keyToUse == " << keyToUse << ", interval == " << interval << endl;
	AlterKeysMap * map_alterkeys = new AlterKeysMap;
	getRootNode()->alterKeys(keyToUse, interval, *map_alterkeys);

	return map_alterkeys;
}


/**
 * L�scht den String aus dem Baum (und den Key auch)
 * Return: den Key des gel�schten Strings (mu� ja auch aus dem Container verschwinden).
 *  --> return wird nicht gebraucht
 *
 * Problem: Wenn an einem Key mehrere Datens�tze im Container dranh�ngen, mu� in h�heren Schichten gepr�ft
 * werden, was genau gel�scht wird. Aus dem Container mu� dann der Datensatz (pair) sehr genau gel�scht werden.
 *
 * F�rs l�schen aus dem Index mu� folgenderma�en vorgegangen werden:
 * - String suchen und ID finden
 * - f�r die ID genau den Datensatz mit der �bergebenen TID l�schen
 * - erst wenn sich herausstellt, da� es die letzte ID war, den String aus dem Baum l�schen
 *
 *
 * Von der Sache her ist es v�llig egal, ob der oldKey zur�ckgegeben wird --> kann erstmal
 * drinbleiben, ist aber eher unwichtig, daher bleibt das jetzt inkonsistent drin
 *
 */
KEY_TYPE PTree::deleteString(string& p_string){
	//cerr << "deleteString(" << p_string << ")" << endl;
	CharNode * zeiger = getRootNode();
	CharNode * lastBranch = NULL;
	POS_TYPE lastBranchChar = PTREE_NULLPOS;
	int zeichenAnzahl = 0;
	int c;
	int infixStartAt = 0;
	bool groesser = false;
	bool kleiner = false;

	if(p_string.empty() || p_string == ""){
		return PTREE_NULLKEY;
	}

	zeichenAnzahl = p_string.length();
	int i = 0; // f�r nachher
	for(i=0; i<zeichenAnzahl; ++i){
		c = hashChar(p_string[i]);

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
			//cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}


		if(zeiger->hasChild(c)){
			if(zeiger->isBranch() || zeiger->hasKey() || zeiger->posID == 0){
				// Wurzelknoten ist immer die erste Verzweigung, sonst kracht's beim letzten String...
				lastBranch = zeiger;
				lastBranchChar = c;
			}
			CharNode * temp = zeiger->getChild(c);
			checkPosCompDelete(zeiger, lastBranch);
			zeiger = temp;
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				int vergleich = zeiger->suffixCompareTo(rest);
				if(vergleich == 0){
					break;
				}
			}
			checkPosCompDelete(zeiger, lastBranch);
			checkPosDelete(lastBranch);
			return PTREE_NULLKEY;
		}
	} // for

	// f�r den Fall da� der String garnicht im Baum ist --> dann sollte wenigstens nichts schief gehen
	if(zeiger->hasSuffix()){
		// also hier noch pr�fen, ob die Suffixe gleich sind --> wenn ja, dann l�schen
		const string& rest = p_string.substr(i);
		if(zeiger->suffixCompareTo(rest) != 0){
			checkPosCompDelete(zeiger, lastBranch);
			checkPosDelete(lastBranch);
			return PTREE_NULLKEY;
		}
	}

	if(zeiger->hasChildren() || zeiger->isBranch()){
		KEY_TYPE oldKey = zeiger->getKey();
		zeiger->deleteKey();
		zeiger->writeNode();
		checkPosCompDelete(zeiger, lastBranch);
		checkPosDelete(lastBranch);
		return oldKey;
	}else{
		lastBranch->deleteChild(lastBranchChar);
		lastBranch->writeNode();
		checkPosCompDelete(zeiger, lastBranch);
		checkPosDelete(lastBranch);
		return PTREE_NULLKEY;
	}
}// deleteString

/**
 * p_string ist der Pr�fix , also "SELECT ... LIKE 'p_string%'"
 */
KeyPair PTree::select_prefix(string& p_string){
	KeyPair ret;

	CharNode * zeiger = getRootNode();
	int zeichenAnzahl = p_string.length();
	int i = 0;
	int c;
	int infixStartAt = 0;
	bool groesser = false;
	bool kleiner = false;

	for(i=0;i<zeichenAnzahl;++i){
		//cerr << "zeiger == " << *zeiger << endl;
		//cerr << "p_string[" << i << "] == " << p_string[i] << endl;
		c = hashChar(p_string[i]);

		if(infixStartAt == 0 && zeiger->hasInfix()){
			infixStartAt = i;
		}
		if(zeiger->hasInfix() && zeiger->infixLength > (i - infixStartAt)){
			//cerr << "getInfix()["  << i << " - " << infixStartAt << "] == " << zeiger->getInfix()[i - infixStartAt] << endl;
			if(zeiger->getInfix()[i - infixStartAt] == p_string[i]){
				// nur hier mu� ich durch Absteigen weitersuchen, geht ja auch nicht anders
				continue;
			}else{
				if(zeiger->getInfix()[i - infixStartAt] > p_string[i]){
					// Suchstring ist kleiner aus Infix
					kleiner = true;
				}else{
					// Suchstring ist gr��er als Infix
					groesser = true;
				}
				break;
			}
		}else if(zeiger->hasInfix() && zeiger->infixLength == (i - infixStartAt)){
			// hier bin ich bei einem verketteten Infix angekommen
			infixStartAt = i+1; // i
		}else{
			infixStartAt = 0;
		}


		if(zeiger->hasChild(c)){
			CharNode * tmp = zeiger->getChild(c);
			checkPosDelete(zeiger);
			zeiger = tmp;
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = p_string.substr(i);
				if(getPrefixLength(rest.c_str(), zeiger->getSuffix().c_str()) == rest.length()){
					ret.first = zeiger->getKey();
					ret.second = zeiger->getKey();
					checkPosDelete(zeiger);
					return ret;
				}
			}
			// nichts gefunden
			ret.first = PTREE_NULLKEY;
			ret.second = PTREE_NULLKEY;
			checkPosDelete(zeiger);
			return ret;
		}
	}// for

	//cerr << "zeiger == " << *zeiger << endl;

	if(kleiner || groesser){
		// irgendwo im Infix ausgestiegen --> Pr�fix nicht vorhanden!
		ret.first = PTREE_NULLKEY;
		ret.second = PTREE_NULLKEY;
		checkPosDelete(zeiger);
		return ret;
	}

	// irgendwo mitten im Baum angekommen -> kleinsten und gr��ten Key des Subtrees ausgeben
	ret.first = zeiger->getLexFirstMinChild(); // ist der lex. kleinste Key
	ret.second = zeiger->getLexMaxChild();  // ist der lex. gr��te Key
	checkPosDelete(zeiger);
	return ret;
}

/**
 * private
 *
 * !!!ACHTUNG!!! setzt als Seiteneffekt den prefix ggf. neu
 *
 * startNode wird _nicht_ gel�scht, wenn der Baum traversiert wird.
 *
 * gibt NULL zur�ck, falls der Pfad nicht existiert
 * gibt den Knoten des Subtrees zur�ck, wenn der Pfad direkt gefunden wurde
 * gibt den Knoten des Suffix zur�ck, falls der Pfad in einem Suffix endet
 *
 */
CharNode * PTree::getPrefixSubTree(CharNode * startNode, string& prefix){
	//cerr << "PTree::getPrefixSubTree(" << prefix << ")" << endl;
	CharNode * zeiger = startNode;
	CharNode * temp = NULL;
	int zeichenAnzahl = prefix.length();
	int i = 0;
	int c;

	for(i=0;i<zeichenAnzahl; ++i){
		c = hashChar(prefix[i]);

		//cerr << "*zeiger == " << *zeiger << endl;
		if(zeiger->hasInfix()){
			prefix = prefix.substr(0,i);
			return zeiger;
		}

		if(zeiger->hasChild(c)){
			temp = zeiger->getChild(c);
			checkPosCompDelete(zeiger, startNode);
			zeiger = temp;
		}else{
			if(zeiger->hasSuffix()){
				const string& rest = prefix.substr(i);
				// ganzer prefix im Suffix? dann zeiger zur�ckgeben
				if(getPrefixLength(rest.c_str(), zeiger->getSuffix().c_str()) == rest.length()){

					// drive-by �bernahme von Werten
					prefix = rest;

					//cerr << "PTree::getPrefixSubTree() END 1" << endl;
					return zeiger;
				}
			}
			checkPosCompDelete(zeiger, startNode);
			//cerr << "PTree::getPrefixSubTree() END 2" << endl;
			return NULL;
		}
	}
	// das folgend delete ist doch mal total ... fehl am platz!
	//if(zeiger != startNode && zeiger->posID != 0){delete zeiger;}
	//cerr << "PTree::getPrefixSubTree() END 3" << endl;
	return zeiger;
}



/**
 * LIKE : Pattern nur mit "_" und "%" am Ende<br/>
 *
 * p_string ist das Suchmuster, also anders als bei der Pr�fix-Suche<br/>
 */
KeyPairVector * PTree::select_LIKE(string& string_like){
//
// * 1. [X] getPrefixSubTree(string p_string) einbinden --> gibt CharNode* auf den Teilbaum zur�ck, der ein bestimmtes Pr�fix hat
// * 2. Suchmuster auseinandernehmen
// * 		--> [X] getPrefixFromString() --> aus "AAC_A_CF_" ==> "AAC" --> das n�chste ist dann entweder das Ende oder Wildcard
// * 3. checken, ob das ein Prefix-Pattern ist
// *
// */
	//cerr << "PTree::select_LIKE(" << string_like << ")..." << endl;
	int zeichenAnzahl = string_like.length();
	if( zeichenAnzahl == 0) return NULL;

	//bool isPrefixPattern = (string_like[string_like.length()-1] == '%');

	// Trivialfall...
	if(zeichenAnzahl == 1 && string_like[0] == '%'){
		KeyPairVector * kpv = new KeyPairVector;
		KeyPair kp(getRootNode()->getLexFirstMinChild(), getRootNode()->getLexMaxChild());
		kpv->push_back(kp);
		return kpv;
	}
	KeyPairVector * r = NULL;
	try{
		r = select_LIKE_rec(getRootNode(), string_like);
	}catch(...){}
	return r;

}

/**
 * Rekursive Funtion zum ermitteln der KeyPairs<br/>
 *
 * startNode --> aktueller Knoten<br/>
 * string_like --> Substring des LIKE-Statements<br/>
 *
 */
KeyPairVector * PTree::select_LIKE_rec(CharNode * startNode, string& string_like){
	//cerr << "PTree::select_LIKE_rec(" << string_like << ")..." << endl;
	//cerr << "startNode == " << *startNode << endl;
	// Pattern endet hier... mu� Matchen oder pa�t nicht
	int stringLikeLength = string_like.length();
	if(stringLikeLength == 0){
		if(startNode->hasKey() && !startNode->hasSuffix()){
			KeyPairVector * kpv = new KeyPairVector;
			KeyPair kp(startNode->getKey(), startNode->getKey());
			kpv->push_back(kp);
			return kpv;
		}
		return NULL;
	}

	// Pattern endet hier, aber als Prefix
	if(stringLikeLength == 1 && string_like[0] == '%'){
		// hier einfach den ganzen Teilbaum zur�ckgeben
		// getLexFirstMinChild
		// getLexMaxChild
		KeyPairVector * kpv = new KeyPairVector;
		KeyPair kp(startNode->getLexFirstMinChild(), startNode->getLexMaxChild());
		kpv->push_back(kp);
		//cerr << "end prefix" << endl;
		return kpv;
	}

	// hier mu� der Infix-Vergleich rein
	if(startNode->hasInfix()){
		//cerr << "startNode->hasInfix()" << endl;
		// infix und suchstring zeichen f�r zeichen vergleichen
		// bei wildcards ist ergebnis eagl, sonst kommt nur "==" weiter
		// bei "%" wird dann ggf. erfolgreich abgebrochen
		int infixLength = startNode->infixLength;
		string infix(startNode->getInfix());
		for(int i=0;i<infixLength && i<stringLikeLength;++i){
			if(string_like[i] != '_' && string_like[i] != '%'){
				if(string_like[i] == infix[i]){
					continue;
				}else{
					// hier Fehlgeschlagen!
					return NULL;
				}
			}else{
				if(string_like[i] == '%'){
					// hier erfolgreich!
					KeyPairVector * kpv = new KeyPairVector;
					KeyPair kp(startNode->getLexFirstMinChild(), startNode->getLexMaxChild());
					kpv->push_back(kp);
					return kpv;
				}
			}
		}// for
		// neue Rekursionsstufe, wenn infixLength =< stringLikeLength
		// vorher noch abchecken, ob der Infix oder der Suchstring am Ende war
		if(infixLength <= stringLikeLength){
			// kann hier die Standard-Schleife benutzen
			for(int i=0;i<MAXCHARS;++i){
				if(startNode->hasChild(i)){
					// hier noch das tempor�re Ergebnis speichern....
					CharNode * nextChild = startNode->getChild(i);
					string rest(string_like.substr(infixLength));
					KeyPairVector * ret_kpv = select_LIKE_rec(nextChild, rest);
					//delete nextChild;
					checkPosDelete(nextChild);
					return ret_kpv;
				}
			} // for
		}else{
			// Fehlschlag! (im Infix verendet!, aber ohne "%" am Ende)
			return NULL;
		}
	}// hasInfix()


	// normale F�lle: mitten im Pattern
	string prefix = getPrefixFromString(string_like);
	if(prefix.length() == 0){

		// an der ersten Stelle steht ein Wildcard --> f�r alle Kinder
		// des Knotens mu� das Muster gesucht werden
		KeyPairVector * kpv = new KeyPairVector;

		// Rest vom string_like f�r jedes Kind
		string rest = string_like.substr(1);

		if(startNode->hasSuffix()){
			//cerr << "select_LIKE_rec -> length() == 0 && hasSuffix()" << endl;
			// jetzt mu� der Suffix mit dem Rest komplett abgehandelt werden
			// 1. String-L�ngen vergleichen, wenn es kein Pr�fix-Match ist
			// 2. sonst suffix-L�nge k�rzen auf rest-L�nge
			// 3. alle Suffix-Zeichen an Wildcard-Positionen in Wildcards umbenennen
			bool isPrefixPattern = (string_like[string_like.length()-1] == '%');

			if(!isPrefixPattern){
				if(string_like.length() != startNode->suffixLength){
					// ohne prefix-Pattern ist exakter Match der Strings erforderlich --> also auch der L�nge!
					return NULL;
				}
			}
			// entscheiden, ob das '%' ggf. mit abgeschnitten wird
			int laenge = (isPrefixPattern? string_like.length() - 1 : string_like.length());
			string suffix_substring(startNode->getSuffix().substr(0,laenge));
			string rest_substring(string_like.substr(0,laenge));

			if(laenge > startNode->suffixLength){
				return NULL;
			}

			// suffix-substring f�r den Vergleich umschreiben
			for(int i=0;i<laenge;++i){
				if(rest_substring[i] == '_') suffix_substring[i] = '_';
			}

			if(rest_substring.compare(suffix_substring) == 0){
				KeyPair kp(startNode->getKey(), startNode->getKey());
				kpv->insert(kpv->end(),kp);
			}

		}
		if(startNode->hasChildren()){
			for(int i=0;i<MAXCHARS;++i){
				if(startNode->hasChild(i)){
					// hier noch das tempor�re Ergebnis speichern....
					CharNode * nextChild = startNode->getChild(i);
					KeyPairVector * new_kpv = select_LIKE_rec(nextChild, rest);
					//delete nextChild;
					checkPosDelete(nextChild);
					if(new_kpv != NULL){
						// ganzen Vector ans Ende anf�gen
						kpv->insert(kpv->end(), new_kpv->begin(), new_kpv->end());
						// und l�schen, wir ja nicht mehr gebraucht
						delete new_kpv;
					}
				}
			} // for
		} // if hasChildren()
		// kpv ist jetzt vollst�ndig und kann zur�ckgegeben werden
		return kpv;

	// Ende prefixLength == 0
	}else{

		// wenn's einen Suffix hat, dann auch keine Kinder mehr...
		if(startNode->hasSuffix()){
			//cerr << "(U)select_LIKE_rec -> length() == 0 && hasSuffix()" << endl;
			// jetzt mu� der Suffix mit dem Rest komplett abgehandelt werden
			// 1. String-L�ngen vergleichen, wenn es kein Pr�fix-Match ist
			// 2. sonst suffix-L�nge k�rzen auf rest-L�nge
			// 3. alle Suffix-Zeichen an Wildcard-Positionen in Wildcards umbenennen
			bool isPrefixPattern = (string_like[string_like.length()-1] == '%');

			if(!isPrefixPattern){
				if(string_like.length() != startNode->suffixLength){
					// ohne prefix-Pattern ist exakter Match der Strings erforderlich --> also auch der L�nge!
					return NULL;
				}
			}
			// entscheiden, ob das '%' ggf. mit abgeschnitten wird
			int laenge = (isPrefixPattern? string_like.length() - 1 : string_like.length());
			string suffix_substring(startNode->getSuffix().substr(0,laenge));
			string rest_substring(string_like.substr(0,laenge));

			// suffix-substring f�r den Vergleich umschreiben
			for(int i=0;i<laenge;++i){
				if(rest_substring[i] == '_') suffix_substring[i] = '_';
			}

			if(rest_substring.compare(suffix_substring) == 0){
				KeyPairVector * kpv = new KeyPairVector;
				KeyPair kp(startNode->getKey(), startNode->getKey());
				kpv->insert(kpv->end(),kp);
				return kpv;
			}
		}// startNode->hasSuffix()


		// ein Pr�fix ist am Anfang... Baum mu� abgestiegen werden
		// n�chste Zeilen:
		// der n�chste Knoten wird geholt; durch Infix oder Suffix kann der tats�chlich ben�tigte
		// Pr�fix variieren --> daher wird der Pr�fix neu gesetzt (via Referenz) und weiter unten nur
		// der tats�chlich verbrauchte in die substring-Berechnung einbezogen
		//
		//cerr << "prefix(v) == " << prefix << endl;
		int len_prefix_old = prefix.length();
		CharNode * nextNode = getPrefixSubTree(startNode, prefix);
		int len_prefix_new = prefix.length();
		// prefix wurde als Seiteneffekt vielleicht neu gesetzt
		// sieht irgendwie zu kompliziert aus...
		int len_prefix = (len_prefix_old == len_prefix_new? len_prefix_old:len_prefix_new );
		//cerr << "prefix(n) == " << prefix << endl;
		if(nextNode == NULL){
			// kein entsprechender Pfad
			return NULL;
		}else{
			// neuen Startknoten gefunden --> rekursiv weitermachen
			// Ergebis kann gleich weiterverwendet werden
			string rest(string_like.substr(len_prefix));
			KeyPairVector * kpv = select_LIKE_rec(nextNode, rest);
			//delete nextNode;
			checkPosDelete(nextNode);
			//cerr << "PTree::select_LIKE_rec(" << string_like << ") END" << endl;
			return kpv;
		}
	}
}// select_LIKE_rec()


/**
 * f�hrt die IOOrder-Methode aus. Lie�t den Baum depth-first und schreib die Knoten in dieser
 * Reihenfolge in einen neuen Baun; der ist dann IO-Optimiert gespeichert.
 */
/* static */ PTree* PTree::IOOrder(PTree * treeToOrder){
	//Logger logger(treeToOrder->name, treeToOrder->schema, string("IOOrder"));

	// neuen Baum erstellen (als temp markiert)
	string filename_baum_orig = treeToOrder->mPSpeicher->filename_baum;
	string filename_suffixe_orig = treeToOrder->mPSpeicher->filename_suffixe;

	string name_orig = treeToOrder->name;
	string schema_orig = treeToOrder->schema;
	string name_temp = treeToOrder->name + "temp";
	string schema_temp = treeToOrder->schema + "temp";

	//logger << "create new tree\n";
	PTree * treeNew = new PTree(name_temp, schema_temp,'N');
	//logger << "...OK\n";
	// test: Windows mitteilen, da� das File nicht fragmentiert werden soll
	// scheint aber zumindest in Verbindung mit dem gcc nichts zu bringen
	//treeNew->getRootNode()->mPSpeicher->file_baum.width(treeToOrder->getRootNode()->mPSpeicher->getBaumSize());

	//special_debug = true;
	cerr << "CharNode::IOOrder(..) ...\n";
	CharNode::IOOrder(treeToOrder->getRootNode(), treeNew->getRootNode());
	cerr << "...OK\n";
	//special_debug = true;

	string filename_baum_temp = treeNew->mPSpeicher->filename_baum;
	string filename_suffixe_temp = treeNew->mPSpeicher->filename_suffixe;

	// hiermit werden die Files geschlossen und die Puffer geleert
	delete treeToOrder;
	delete treeNew;

	//logger << "trees closed\n";

	// jetzt sollten zwei neue Files existieren (baum && suffixe)
	if(remove(filename_baum_orig.c_str())) ;//logger << "Fehler bei remove(" << filename_baum_orig << ")\n";
	if(remove(filename_suffixe_orig.c_str())) ;// logger << "Fehler bei remove(" << filename_suffixe_orig << ")\n";

	if(rename(filename_baum_temp.c_str(), filename_baum_orig.c_str())){
		//logger << "Fehler bei rename(" << filename_baum_temp << ", " << filename_baum_orig << ")\n";
		perror("Folgender Fehler trat auf");
		//filecopy(filename_baum_temp, filename_baum_orig);
		//remove(filename_baum_temp.c_str());
	}
	if(rename(filename_suffixe_temp.c_str(), filename_suffixe_orig.c_str())){
		//logger << "Fehler bei rename(" << filename_suffixe_temp << ", " << filename_suffixe_orig << ")\n";
		perror("Folgender Fehler trat auf");
		//filecopy(filename_suffixe_temp, filename_suffixe_orig);
		//remove(filename_suffixe_temp.c_str());
	}

	//logger << "PTree::IOOrder finished\n";
	// neues B�umchen zur�ckgeben
	return new PTree(name_orig, schema_orig, 'W');
}// IOOrder

void PTree::printInfixStatistics(){
	getRootNode()->printInfixStatistics();
}

void PTree::setStringLengths(CharNode * node, unsigned int actLength){
	unsigned int len(actLength);
	unsigned int min(UINT_MAX);
	unsigned int max(0);
	if(node->hasInfix()){
		len+=node->infixLength;
	}
//	else
	if(node->hasSuffix()){
		len+=node->suffixLength;
		min=len;
		max=len;
		node->setMinMax(min,max);
		node->writeNode();
//		cerr<<": "<<min<<" max: "<<max<<endl;
		return;
	}
//	else
	if(node->hasKey()){
		min=len;
		max=len;
	}

	for(int i = 0; i < MAXCHARS;++i){
		if(node->hasChild(i)){
			CharNode * child_node= node->getChild(i);
			setStringLengths(child_node,len+1);
			if(child_node->minLength < min) min=child_node->minLength;
			if(child_node->maxLength > max) max=child_node->maxLength;
			node->mPSpeicher->freeCharNode(child_node);
		}
	}

	node->setMinMax(min,max);
//	cerr<<"min: "<<min<<" max: "<<max<<endl;
	node->writeNode();
}

