
#ifndef _PSPEICHER_HPP_
#define _PSPEICHER_HPP_

class PSpeicher;

#ifdef USE_C_FILES
#include "stdio.h"
#else
#include <fstream>
#endif

#include "CharNode.hpp"
#include "DiskPagePool.hpp"
#include "SuffixDiskPagePool.hpp"

/**
 * Stellt die Speicherfunktionen zur Verf�gung und kontrolliert die Erzeugung von
 * neuen CharNode-Objekten.
 */
class PSpeicher{

	// Puffer f�r die Speicherung der gepackten Strings (damit mu� nicht jedes Mal Speicher allokiert werden)
	char * packBitsBuffer; // = new char[nsInfixStringLength+1];

	// true, wenn die variable Knotengr��e f�r neue Knoten benutzt werden soll
	bool modusVariableNodeSize;

public:

#ifdef USE_C_FILES
	FILE * c_file_baum;
	FILE * c_file_suffixe;

	//char buf_baum[PAGESIZE_ON_DISK+1];
	//char buf_suffixe[SUFFIX_PAGESIZE_ON_DISK+1];

#else
	fstream file_baum;
	fstream file_suffixe;
#endif

	char * buffer_baum;
	char * buffer_suffixe;

	string filename_baum;// = "baum.file" ;
	string filename_suffixe;// = "suffixe.file";

	DiskPagePool * diskPagePool; // wird mit file_baum initialisiert
	SuffixDiskPagePool * suffixDiskPagePool;

	PSpeicher(string name, string schema, char mode);
	~PSpeicher();

	// Blockweises lesen & schreiben

	// bildet die Konstruktoren von CharNode nach, damit alle zentral �ber die Speicherklasse laufen k�nnen
	// soll vor allem verhindern, da� andauernd neue Objekte erstellt werden (und gelesen werden)
	// Step1: alle CharNodes zentral �ber das Speicher-Objekt erstellen und l�schen
	// Step2: einfaches Caching hinzuf�gen (read-Caching)
	// Step3: Speicher auf Blockzugriffe umstellen
	CharNode * newCharNodeAppend();
	CharNode * newCharNodeByPos(POS_TYPE pos);
	CharNode * newCharNodeByKey(KEY_TYPE key);

	bool freeCharNode(CharNode * & node);

	// tempor�r als Member-Variable implementiert, d�rfte aber auf die dauer zu gro� werden
	// nimmt nur die Knoten mit g�ltiger posID auf
	map<POS_TYPE, CharNode* > allNodes;


	long getBaumSize();// Gr��e der Datei
	long getSuffixSize();

	string getIndexName(){return filename_baum;}
	string getSuffixeName(){return filename_suffixe;}

	void rename();

	void newReadWrite();
	void loadReadWrite();
	void loadRead();

	void deleteIndex(); // == DROP

	void writeBlockNode(CharNode * n);
	long writeSuffix(CharNode * n);

	void readNode(CharNode * n);
	void readSuffix(CharNode * n);
	string getExtSuffix(CharNode *n);

	void closeFiles();

	void setModeVariableNodeSize(){modusVariableNodeSize = true;}
	void setModeFixedNodeSize(){modusVariableNodeSize = false;}

	// einfach Ausgabe
	friend ostream& operator<<(ostream& stream, PSpeicher& p);

	static int internalSuffixReadCount;
	static int internalSuffixReadLastPos;
	static double internalSuffixReadDistanceSum;

	static int internalSuffixWriteCount;
	static int internalSuffixWriteLastPos;
	static double internalSuffixWriteDistanceSum;

	static ostream& printStatistics(ostream& stream);

};


#endif

