#include "PSpeicher.hpp"

int PSpeicher::internalSuffixReadCount = 0;
int PSpeicher::internalSuffixReadLastPos = 0;
double PSpeicher::internalSuffixReadDistanceSum = 0;

int PSpeicher::internalSuffixWriteCount = 0;
int PSpeicher::internalSuffixWriteLastPos = 0;
double PSpeicher::internalSuffixWriteDistanceSum = 0;


/**
 * Erstellt ein neues Objekt mit name, schema und mode (New, Write, Reas, Delete)
 *
 */
PSpeicher::PSpeicher(string name, string schema, char mode){

	// erstmal nur Knoten mit fester Gr��e
	modusVariableNodeSize = false;
	packBitsBuffer = new char[(nsInfixStringLength > nsIntSuffixStringLength?nsInfixStringLength:nsIntSuffixStringLength)+1];

	if(global_var_use_odci){
		filename_baum = ODCI_DATA_SUBDIR+"baum_"+name+"_"+schema+".file";
		filename_suffixe = ODCI_DATA_SUBDIR+"suffix_"+name+"_"+schema+".file";
	}else{
		filename_baum = DATA_SUBDIR+"baum_"+name+"_"+schema+".file";
		filename_suffixe = DATA_SUBDIR+"suffix_"+name+"_"+schema+".file";
	}

	switch(mode){
		case 'N' :
				newReadWrite();
				break;
		case 'W' : loadReadWrite();
				break;
		case 'R' : loadRead();
				break;
		case 'D' : deleteIndex();
				return;
				break;
		default:
			cerr << "PSpeicher::PSpeicher(,,) switch default (das kann ja nicht sein... :@ )" << endl;
			exit(-1);
	}

	// jetzt den Buffer f�r die Knoten initialisieren
#ifdef USE_C_FILES
	setbuf(c_file_baum, NULL);
	setbuf(c_file_suffixe, NULL);
	//setvbuf(c_file_baum, buf_baum, PAGESIZE_ON_DISK+1, _IOFBF);
	//setvbuf(c_file_suffixe, buf_suffixe, SUFFIX_PAGESIZE_ON_DISK+1, _IOFBF);
	diskPagePool = new DiskPagePool(c_file_baum);
	suffixDiskPagePool = new SuffixDiskPagePool(c_file_suffixe);
#else
	diskPagePool = new DiskPagePool(file_baum);
	suffixDiskPagePool = new SuffixDiskPagePool(file_suffixe);
#endif
}

/**
 * bereinigt die Puffer
 */
PSpeicher::~PSpeicher(){
	delete packBitsBuffer;
	delete diskPagePool;
	delete suffixDiskPagePool;
	closeFiles();
}

/**
 * Neuer Knoten f�r zum Anh�ngen an den Baum
 *
 */
CharNode * PSpeicher::newCharNodeAppend(){
	CharNode * ret = new CharNode();
	if(!ret){cerr << "new CharNode() == NULL" << endl;}
	++CharNode::internalNodeCountCreateOnDisk;
	//ret->posID = getBaumSize();
	ret->posID = diskPagePool->getAppendPos();
	ret->key = PTREE_NULLKEY;
	ret->mPSpeicher = this;

#ifdef USE_CACHE
	allNodes.insert(pair<POS_TYPE, CharNode*>(ret->posID, ret));
#endif
	return ret;
}

/**
 * liest einen Knoten aus der Knotendatei, gibt das Objekt zur�ck
 */
CharNode * PSpeicher::newCharNodeByPos(POS_TYPE p_pos){

	// find gibt iterator zur�ck
#ifdef USE_CACHE
	map<POS_TYPE, CharNode*>::iterator it = allNodes.find(p_pos);
	if(it != allNodes.end()){
		return (*it).second;
	}
#endif

	CharNode * ret = new CharNode();
	if(!ret){cerr << "new CharNode() == NULL" << endl;}
	ret->posID = p_pos;
	ret->key = PTREE_NULLKEY;
	ret->mPSpeicher = this;
	readNode(ret);

#ifdef USE_CACHE
	allNodes.insert(pair<POS_TYPE, CharNode*>(ret->posID, ret));
#endif

	return ret;
}

/**
 * Wieder nur ein Knoten f�r MIN/MAX-Nodes, ohne Referenz auf PSpeicher
 */
CharNode * PSpeicher::newCharNodeByKey(KEY_TYPE p_key){
	CharNode * ret = new CharNode();
	if(!ret){cerr << "new CharNode() == NULL" << endl;}
	ret->posID = PTREE_NULLPOS;
	ret->key = p_key;
	ret->mPSpeicher = NULL;
	return ret;
}

/**
 * node ist Referenz auf einen Zeiger, der dann gel�scht wird
 *
 */
bool PSpeicher::freeCharNode(CharNode * & node){
	// HIER WEITER =) 2007-04-18-22-17
	// Anpassung f�r map --> es darf ja nichts mehr gel�scht werden!!!
	// nur die Knoten mit posID == PTREE_NULLPOS

	if(node->posID == PTREE_NULLPOS){
		delete node;
		node = NULL;
		return true;
	}

	//if(node == NULL) return false;
#ifndef USE_CACHE
	delete node;
#endif
	node = NULL;
	return true;
}


/**
 * Gr��e der Baumdatei
 */
long PSpeicher::getBaumSize(){
#ifdef USE_C_FILES
	fseek(c_file_baum, 0, SEEK_END);
	return ftell(c_file_baum);
#else
	file_baum.seekg(0, ios::end);
	return file_baum.tellg();
#endif
}

/**
 * Gr��e der Suffixdatei
 */
long PSpeicher::getSuffixSize(){
#ifdef USE_C_FILES
	fseek(c_file_suffixe, 0, SEEK_END);
	return ftell(c_file_suffixe);
#else
	file_suffixe.seekg(0, ios::end);
	return file_suffixe.tellg();
#endif
}

/**
 * �ffnet die Dateien; �berschreibt ggf. vorhandene Files.
 */
void PSpeicher::newReadWrite(){
	// vorhandene Files �berschreiben
	filecreate(filename_baum);
	filecreate(filename_suffixe);

#ifdef USE_C_FILES
	c_file_baum = fopen(filename_baum.c_str(), "r+b");
	c_file_suffixe = fopen(filename_suffixe.c_str(), "r+b");
#else
	file_baum.open(filename_baum.c_str(), ios::in | ios::out | ios::binary);
	file_suffixe.open(filename_suffixe.c_str(), ios::in | ios::out | ios::binary);
#endif
}

/**
 * �ffnet die Dateien als read/write
 */
void PSpeicher::loadReadWrite(){
#ifdef USE_C_FILES
	c_file_baum = fopen(filename_baum.c_str(), "r+b");
	c_file_suffixe = fopen(filename_suffixe.c_str(), "r+b");
#else
	file_baum.open(filename_baum.c_str(), ios::in | ios::out | ios::binary);
	if(!file_baum){
		cerr << "file_baum not open!" << endl;
		exit(-1);
	}
	file_suffixe.open(filename_suffixe.c_str(), ios::in | ios::out | ios::binary);
	if(!file_suffixe){
		cerr << "file_suffixe not open!" << endl;
		exit(-1);
	}
#endif
}

/**
 * �ffnet die Datei im Lesemodus
 */
void PSpeicher::loadRead(){
#ifdef USE_C_FILES
	c_file_baum = fopen(filename_baum.c_str(), "rb");
	c_file_suffixe = fopen(filename_suffixe.c_str(), "rb");
#else
	file_baum.open(filename_baum.c_str(), ios::in | ios::binary);
	if(!file_baum){
		cerr << "file_baum not open!" << endl;
		exit(-1);
	}
	file_suffixe.open(filename_suffixe.c_str(), ios::in | ios::binary);
	if(!file_suffixe){
		cerr << "file_suffixe not open!" << endl;
		exit(-1);
	}
#endif
}

/**
 * L�scht die Index-Files
 */
void PSpeicher::deleteIndex(){
	remove(filename_baum.c_str());
	remove(filename_suffixe.c_str());
}

/**
 * Schlie�t die Files
 */
void PSpeicher::closeFiles(){
#ifdef USE_C_FILES
	fclose(c_file_baum);
	fclose(c_file_suffixe);
#else
	if(file_baum.is_open()){file_baum.close();if(file_baum.fail()){cerr << "Fehler beim Schlie�en von " << filename_baum << endl;}}
	if(file_suffixe.is_open()){file_suffixe.close();if(file_suffixe.fail()){cerr << "Fehler beim Schlie�en von " << filename_suffixe << endl;}}
#endif
}

/**
 * Schreibt einen Knoten ins File, Unterscheidung nach fester/fix L�nge
 */
void PSpeicher::writeBlockNode(CharNode * n){

	if(special_debug)cerr << "writeBlockNode(posID == " << n->posID << ")" << endl;
	//if(special_debug)cerr << *n << endl;
	// *if(special_debug)*/cerr << "optionByte == " << n->optionByte_toString() << endl;

	// nicht perfekt, aber was solls, 800 Bytes m�ssen reichen
	char * stuffBytesReservoir = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";

	// als Puffer
	char * internalSavedInfix = new char[nsInfixStringLength+1];

	bool mInternalNode = false; // key +suffixlength +suffixstart +childNodes (quasi die alte Knotengr��e)
	bool mSuffixNode = false; // key +suffixlength +suffixstart +suffix
	bool mInfixNode = false; // nextChildNode +infixLength +infix
	int infixChar = -1;
	bool mIsFixedSizeNode = false;

	if(n->testOption(NODE_OPTION_ISFIXED)){
		mIsFixedSizeNode = true;
	}

	if(special_debug)streamout(cerr, (int)n->optionByte);
	if(special_debug)streamout(cerr, mIsFixedSizeNode);

	// seek --> ausbauen, um die gr��e zu verwenden
	diskPagePool->seekp(n->posID);

	//cerr << "diskPagePool->getAppendPos() == " << diskPagePool->getAppendPos() << endl;

	// so, hier erstmal schauen, ob ein Knoten vorhanden ist;
	// wenn ja, dann auch schauen, ob der zu schreibende in den aktuellen reinpa�t
	// wenn nicht, dann indirektion anlegen --> mu� aber auch zu den fixen Knoten!
	if(diskPagePool->getAppendPos() > n->posID){
		diskPagePool->seekg(n->posID);
		// liegt nicht am Ende --> optionByte lesen, Gr��e untersuchen
		unsigned char tempOptionByte;
		diskPagePool->read((char*)&tempOptionByte, sizeof(unsigned char));
		// fixed? ok, genug platz
		// variable? gr��e berechnen (beide optionBytes)
		if(tempOptionByte == NODE_OPTION_INDIRECTION){
			if(special_debug)cerr << "(WRITE) READ INDIRECTION" << endl;
			//cerr << *n << endl;
			POS_TYPE newPos;
			diskPagePool->read((char*)&newPos, sizeof(POS_TYPE));
			diskPagePool->seekp(newPos);
			// keine weitere Option n�tig, da der umgeleitete Knoten definitiv fixedsized ist
		}else if(! ((tempOptionByte & NODE_OPTION_ISFIXED) == 0 ||
				getNodeSizeOnDisk(n->getOptionByte()) <= getNodeSizeOnDisk(tempOptionByte))){
			if(special_debug)cerr << "(WRITE) WRITE INDIRECTION" << endl;
			// zu schreibender Knoten pa�t also nicht in den aktuellen hinein...
			// 1. optionByte mit indirection schreiben
			tempOptionByte = NODE_OPTION_INDIRECTION;
			diskPagePool->write((char*)&tempOptionByte, sizeof(char));
			// 2. neue Position ermitteln && schreiben
			POS_TYPE newPos = diskPagePool->getAppendPos();
			diskPagePool->write((char*)&newPos, sizeof(POS_TYPE));
			// seekp auf neue Position
			diskPagePool->seekp(newPos);
			// verhindert, da� ggf. viele Indirektionenerfolgen; wenns nicht gleich pa�t, dann wird
			// die Knotengr��e auf fixed gesetzt
			n->setOption(NODE_OPTION_ISFIXED);
		}
	}

	if(n->optionByte == NODE_OPTION_INDIRECTION){
		cerr << "OPTIONBYTE INDIRECTION" << endl;
	}


	// zuerst mal die Optionen speichern
	//diskPagePool->write((char*)&bitFieldOption, sizeof(char));
	diskPagePool->write((char*)&n->optionByte, sizeof(char));
	if(special_debug)cerr << "optionByte == " << n->optionByte_toString() << endl;

	if(mIsFixedSizeNode){
		if(special_debug)cerr << "\twriting fix sized node" << endl;
		if(n->hasSuffix()){
			mSuffixNode = true;
		}else if(n->hasInfix()){
			mInfixNode = true;
			if(n->hasChild(0)){
				infixChar = 0;
			}else if(n->hasChild(1)){
				infixChar = 1;
			}else if(n->hasChild(2)){
				infixChar = 2;
			}else{// if(n->hasChild(3)){
				// kann hier nicht durchgepr�ft werden, weil sonst das tempor�re Schreiben fehlschl�gt
				infixChar = 3;
			}//else{
			//	cerr << "writeBlockNode: Infix but no child" << endl;
			//	exit(-1);
			//}
		}else{
			mInternalNode = true;
		}

		if(mInternalNode){
					diskPagePool->write((char*)&n->key, sizeof(KEY_TYPE));
					diskPagePool->write((char*)&n->suffixStart, sizeof(SUFFIXSTART_TYPE));
					diskPagePool->write((char*)&n->suffixLength, sizeof(LENGTH_TYPE));
					for(int i=0;i<MAXCHARS;++i){
						diskPagePool->write((char*)&n->childNodesPos[i], sizeof(POS_TYPE));
					}
					if(nsStuffBytesNormalNode > 0){
						diskPagePool->write(stuffBytesReservoir, nsStuffBytesNormalNode);
					}
					for(int i = 0; i<MAXCHARS;++i){
						diskPagePool->write((char*)&n->freqVector[i], sizeof(unsigned int));
					}
					diskPagePool->write((char*)&n->minLength,sizeof(unsigned int));
					diskPagePool->write((char*)&n->maxLength,sizeof(unsigned int));

		}
		if(mSuffixNode){
					//if(special_debug)cerr << "HIER(4)" << endl;
					diskPagePool->write((char*)&n->key, sizeof(KEY_TYPE));
					diskPagePool->write((char*)&n->suffixStart, sizeof(SUFFIXSTART_TYPE));
					diskPagePool->write((char*)&n->suffixLength, sizeof(LENGTH_TYPE));
					//diskPagePool->write(n->internalSavedSuffix, INTERNALSAVEDSUFFIXSIZE);

					if(packBitsCompression == true){
						// packBitsBuffer
						const string& s(n->getIntSuffix());
						const string& iss(packBits(s));
						memcpy((void*)packBitsBuffer, (void*)iss.c_str(), iss.length());
						diskPagePool->write(packBitsBuffer, nsIntSuffixSize); // ONDISK
					}else{
						if(n->internalSavedSuffix){
							diskPagePool->write(n->internalSavedSuffix, nsIntSuffixSize);
						}else{
							diskPagePool->write(stuffBytesReservoir, nsIntSuffixSize);
						}
					}
					if(nsStuffBytesSuffixNode > 0){
						diskPagePool->write(stuffBytesReservoir, nsStuffBytesSuffixNode);
					}
					for(int i = 0; i<MAXCHARS;++i){
						diskPagePool->write((char*)&n->freqVector[i], sizeof(unsigned int));
					}
					diskPagePool->write((char*)&n->minLength,sizeof(unsigned int));
					diskPagePool->write((char*)&n->maxLength,sizeof(unsigned int));
		}
		if(mInfixNode){
					diskPagePool->write((char*)&n->childNodesPos[infixChar], sizeof(POS_TYPE));
					diskPagePool->write((char*)&n->infixLength, sizeof(LENGTH_TYPE));

					//char internalSavedInfix[INTERNALSAVEDINFIXSIZE +1];
					//memcpy((void*)internalSavedInfix, (void*)n->suffix.c_str(), n->infixLength);
					//internalSavedInfix[n->infixLength] = 0;
					//diskPagePool->write(internalSavedInfix, INTERNALSAVEDINFIXSIZE);

					if(packBitsCompression_for_Infixes == true){
						const string& isi(packBits(n->suffix));
						memcpy((void*)packBitsBuffer, (void*)isi.c_str(), isi.length());
						diskPagePool->write(packBitsBuffer, nsInfixSize); //ONDISK
					}else{
						memcpy(internalSavedInfix, n->suffix.c_str(), n->infixLength);
						char c;
						for(int i=0; i<n->infixLength; ++i){
							c = *(internalSavedInfix+i);
							if(!(c=='A' ||c=='C' ||c=='G' ||c=='T')){
								cerr << "FEHLER; falscher Buchstabe! (writeBlockNode) INFIX == " << n->suffix << " (length==" << n->infixLength << ")" << endl;
								exit(-1);
							}
						}

						diskPagePool->write(internalSavedInfix, nsInfixSize); //ONDISK
					}
					if(nsStuffBytesInfixNode > 0){
						diskPagePool->write(stuffBytesReservoir, nsStuffBytesInfixNode);
					}
					for(int i = 0; i<MAXCHARS;++i){
						diskPagePool->write((char*)&n->freqVector[i], sizeof(unsigned int));
					}
					diskPagePool->write((char*)&n->minLength,sizeof(unsigned int));
					diskPagePool->write((char*)&n->maxLength,sizeof(unsigned int));
		}
	}
	else{// isVariableSizeNode
		if(special_debug)cerr << "\twriting variable sized node" << endl;

		// Variable Knotengr��e
		// wenn sich der Knoten pl�tzlich ausdehnt ist das nicht mehr so gut...
		// im Insert-Modus werden nur FL-Knoten eingef�gt, die VL-Knoten nicht �berschreiben d�rfen
		if(n->testOption(NODE_OPTION_HASKEY)){ // KEY schreiben
			diskPagePool->write((char*)&n->key, sizeof(KEY_TYPE));
		}
		if(n->testOption(NODE_OPTION_HASSUFFIX)){
			// suffix-l�nge
			diskPagePool->write((char*)&n->suffixLength, sizeof(LENGTH_TYPE));
			// suffix selbst
			if(packBitsCompression == true){
				const string& s(n->getIntSuffix());
				const string& iss(packBits(s));
				memcpy((void*)packBitsBuffer, (void*)iss.c_str(), iss.length());
				diskPagePool->write(packBitsBuffer, nsIntSuffixSize);
			}else{
				if(n->internalSavedSuffix){
					diskPagePool->write(n->internalSavedSuffix, nsIntSuffixSize);
				}else{
					diskPagePool->write(stuffBytesReservoir, nsIntSuffixSize);
				}
			}
			// suffix-startPos
			if(n->testOption(NODE_OPTION_SUFFIX_HASSUFFIXSTART)){
					diskPagePool->write((char*)&n->suffixStart, sizeof(SUFFIXSTART_TYPE));
			}

		}
		else{
			if(n->testOption(NODE_OPTION_HASCHAR_A)){ // POS -> A schreiben
				diskPagePool->write((char*)&n->childNodesPos[0], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASCHAR_C)){ // POS -> C schreiben
				diskPagePool->write((char*)&n->childNodesPos[1], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASCHAR_G)){ // POS -> G schreiben
				diskPagePool->write((char*)&n->childNodesPos[2], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASCHAR_T)){ // POS -> T schreiben
				diskPagePool->write((char*)&n->childNodesPos[3], sizeof(POS_TYPE));
			}
			// infix
			if(n->testOption(NODE_OPTION_HASINFIX)){
				// infix-l�nge
				diskPagePool->write((char*)&n->infixLength, sizeof(LENGTH_TYPE));
				// infix selbst
				if(packBitsCompression_for_Infixes == true){
					const string& isi(packBits(n->suffix));
					memcpy((void*)packBitsBuffer, (void*)isi.c_str(), isi.length());
					diskPagePool->write(packBitsBuffer, nsInfixSize); // ONDISK
				}else{
					memcpy(internalSavedInfix, n->suffix.c_str(), n->suffix.length());
					diskPagePool->write(internalSavedInfix, nsInfixSize); // ONDISK
				}
			}
		}
		// ende variable knotengr��e
		for(int i = 0; i<MAXCHARS;++i){
			diskPagePool->write((char*)&n->freqVector[i], sizeof(unsigned int));
		}
		diskPagePool->write((char*)&n->minLength,sizeof(unsigned int));
		diskPagePool->write((char*)&n->maxLength,sizeof(unsigned int));
	} // isFixedSizeNode

	delete internalSavedInfix;
	if(special_debug)cerr << "writeBlockNode(posID == " << n->posID << ") fertig" << endl;
}

/**
 * Schreibt den Suffix in die Suffix-Datei
 */
long PSpeicher::writeSuffix(CharNode * n){
	//if(special_debug)cerr << "writeSuffix(posID == " << n->posID << ")" << endl;

	if(n->suffixLength <= nsIntSuffixStringLength){
		// nur dann schreiben, wenn die Mindestl�nge erreicht ist
		return -2;
	}

	++internalSuffixWriteCount;
	long newpos;
	if(packBitsCompression == true){
		const string& ps(packBits(n->suffix.substr(nsIntSuffixStringLength)));
		//const string& ps(packBits(n->suffix));
		newpos = suffixDiskPagePool->getAppendPos(ps.length());
		suffixDiskPagePool->seekp(newpos);
		suffixDiskPagePool->write((char*)ps.c_str(), ps.length());
		return newpos * ALPHABET_COMPRESSION_FACTOR; // wg. Kompression
	}else{
		const string& ps(n->suffix.substr(nsIntSuffixStringLength));
		newpos = suffixDiskPagePool->getAppendPos(ps.length());
		suffixDiskPagePool->seekp(newpos);
		suffixDiskPagePool->write((char*)ps.c_str(), ps.length());
		return newpos;
	}
}

/**
 * liest einen Knoten aus der Datei, Positionsangabe befindet sich im �bergebenen CharNode
 */
void PSpeicher::readNode(CharNode * n){
	if(special_debug)cerr << "readNode(posID == " << n->posID << ")" << endl;
	//if(special_debug)cerr << "node == " << *n << endl;
	//if(special_debug)cerr << "optionByte == " << n->optionByte_toString() << endl;


	diskPagePool->seekg(n->posID);


	bool mInternalNode = false; // key +suffixlength +suffixstart +childNodes (quasi die alte Knotengr��e)
	bool mSuffixNode = false; // key +suffixlength +suffixstart +suffix
	bool mInfixNode = false; // nextChildNode +infixLength +infix
	int infixChar = -1;
	bool mIsFixedSizeNode = false;

	// gleich nach optionByte schreiben
	diskPagePool->read((char*)&n->optionByte, sizeof(char));
	//unsigned char bitFieldOption = n->optionByte; // lokale Kopie
	if(special_debug)cerr << "optionByte == " << n->optionByte_toString() << endl;


	// einfach so lange den Indirektionen folgen bis fertig
	while(/*n->testOptionComplete(NODE_OPTION_INDIRECTION)*/ n->getOptionByte() == NODE_OPTION_INDIRECTION ){
		cerr << "READ INDIRECTION" << endl;
		// jetzt einfach nur die neue Position auslesen
		POS_TYPE newPosID;
		diskPagePool->read((char*)&newPosID, sizeof(POS_TYPE));
		if(newPosID > diskPagePool->getAppendPos()) {
			cerr << "(readNode) newPosID > diskPagePool->getAppendPos()" << endl;
			exit(-1);
		}
		diskPagePool->seekg(newPosID);
		diskPagePool->read((char*)&n->optionByte, sizeof(char));
		// ... jetzt weiter im Text
	}


	if(n->testOption(NODE_OPTION_ISFIXED)){
		mIsFixedSizeNode = true;
	}
	if(special_debug)streamout(cerr, (int)n->optionByte);
	if(special_debug)streamout(cerr, mIsFixedSizeNode);
	if(mIsFixedSizeNode){
		if(special_debug)cerr << "\treading fix sized node" << endl;
		if(n->testOption(NODE_OPTION_HASSUFFIX)){
			mSuffixNode = true;
		}else if(n->testOption(NODE_OPTION_HASINFIX)){
			// kann jetzt nur noch InfixNode sein
			mInfixNode = true;
			if(n->testOption(NODE_OPTION_HASCHAR_A)){
				infixChar = 0;
			}else if(n->testOption(NODE_OPTION_HASCHAR_C)){
				infixChar = 1;
			}else if(n->testOption(NODE_OPTION_HASCHAR_G)){
				infixChar = 2;
			}else if(n->testOption(NODE_OPTION_HASCHAR_T)){
				infixChar = 3;
			}else{
				cerr << "ERROR in optionByte! Infix without link! optionByte == " << (int)n->optionByte << endl;
				exit(-1);
			}
		}else{
			mInternalNode = true;
		}
		if( mInternalNode){
					diskPagePool->read((char*)&n->key, sizeof(KEY_TYPE)); // 8
					diskPagePool->read((char*)&n->suffixStart, sizeof(SUFFIXSTART_TYPE)); // 4
					diskPagePool->read((char*)&n->suffixLength, sizeof(LENGTH_TYPE)); // 2
					for(int i=0;i<MAXCHARS;++i){
						diskPagePool->read((char*)&n->childNodesPos[i], sizeof(POS_TYPE)); // 16
					}
					for(int i = 0; i<MAXCHARS;++i){
						diskPagePool->read((char*)&n->freqVector[i], sizeof(unsigned int));
					}
					diskPagePool->read((char*)&n->minLength, sizeof(unsigned int));
					diskPagePool->read((char*)&n->maxLength, sizeof(unsigned int));
		}
		if(mSuffixNode){
					diskPagePool->read((char*)&n->key, sizeof(KEY_TYPE)); // 8
					diskPagePool->read((char*)&n->suffixStart, sizeof(SUFFIXSTART_TYPE)); // 4
					diskPagePool->read((char*)&n->suffixLength, sizeof(LENGTH_TYPE)); // 2

					if(n->internalSavedSuffix == NULL){
						n->internalSavedSuffix = new char[nsIntSuffixStringLength+1];
					}
					if(packBitsCompression == true){
						diskPagePool->read(packBitsBuffer, nsIntSuffixSize); // ONDISK
						// nur die L�nge spielt hier eine Rolle!
						LENGTH_TYPE s_length = (LENGTH_TYPE)n->suffixLength / (LENGTH_TYPE)4;
						LENGTH_TYPE mod_length =  (LENGTH_TYPE)n->suffixLength % (LENGTH_TYPE)4;
						if(mod_length > 0)++s_length;
						LENGTH_TYPE s_intlength = (n->suffixLength > nsIntSuffixStringLength?nsIntSuffixStringLength:n->suffixLength);

						///// ausgepackten String in den internen Speicher kopieren
						memcpy(
							(void*)n->internalSavedSuffix,
							(void*)unpackBits(
											packBitsBuffer,
											s_length,
											/*startAt*/ 0,
											/*l�nge interner suffix*/ s_intlength)
									.c_str(),
							s_intlength
							);
					}else{
						diskPagePool->read(n->internalSavedSuffix, nsIntSuffixSize);
						n->internalSavedSuffix[nsIntSuffixStringLength] = 0;
					}
					for(int i = 0; i<MAXCHARS;++i){
						diskPagePool->read((char*)&n->freqVector[i], sizeof(unsigned int));
					}
					diskPagePool->read((char*)&n->minLength, sizeof(unsigned int));
					diskPagePool->read((char*)&n->maxLength, sizeof(unsigned int));
		}
		if(mInfixNode){
					diskPagePool->read((char*)&n->childNodesPos[infixChar], sizeof(POS_TYPE)); // 4
					diskPagePool->read((char*)&n->infixLength, sizeof(LENGTH_TYPE)); // 2

					if(packBitsCompression_for_Infixes == true){
						diskPagePool->read(packBitsBuffer, nsInfixSize); // 24 // ONDISK
						LENGTH_TYPE s_length = (LENGTH_TYPE)n->infixLength / (LENGTH_TYPE)4;
						if(n->infixLength % 4 >0)++s_length;
						memcpy(
							(void*)packBitsBuffer,
							(void*)unpackBits(
											packBitsBuffer,
											s_length,
											0,
											n->infixLength)
										.c_str(),
							n->infixLength);
						packBitsBuffer[n->infixLength] = 0;
						n->suffix = string(packBitsBuffer, n->infixLength);
					}else{
						diskPagePool->read(packBitsBuffer, nsInfixSize);
						packBitsBuffer[n->infixLength] = 0;
						n->suffix = string(packBitsBuffer, n->infixLength);
					}
					for(int i = 0; i<MAXCHARS;++i){
						diskPagePool->read((char*)&n->freqVector[i], sizeof(unsigned int));
					}
					diskPagePool->read((char*)&n->minLength, sizeof(unsigned int));
					diskPagePool->read((char*)&n->maxLength, sizeof(unsigned int));
					if(special_debug) cerr << "INFIX == " << packBitsBuffer << " (length==" << n->infixLength << ")" << endl;
		}
		// ende fixed knotengr��e
	}else{// mIsFixedSizeNode
		if(special_debug)cerr << "\treading variable sized node" << endl;
		// ab hier variable Knotengr��e
		if(n->testOption(NODE_OPTION_HASKEY)){
			diskPagePool->read((char*)&n->key, sizeof(KEY_TYPE)); // 8
		}
		if(n->testOption(NODE_OPTION_HASSUFFIX)){
			// suffix-l�nge
			diskPagePool->read((char*)&n->suffixLength, sizeof(LENGTH_TYPE)); // 2

			///// ausgepackten String in den internen Speicher kopieren
			if(n->internalSavedSuffix == NULL){
				n->internalSavedSuffix = new char[nsIntSuffixStringLength+1];
			}
			if(packBitsCompression == true){
				diskPagePool->read(packBitsBuffer, nsIntSuffixSize); // ONDISK
				// nur die L�nge spielt hier eine Rolle!
				LENGTH_TYPE s_length = (LENGTH_TYPE)n->suffixLength / (LENGTH_TYPE)4;
				LENGTH_TYPE mod_length =  (LENGTH_TYPE)n->suffixLength % (LENGTH_TYPE)4;
				if(mod_length > 0)++s_length;
				LENGTH_TYPE s_intlength = (n->suffixLength > nsIntSuffixStringLength?nsIntSuffixStringLength:n->suffixLength);

				memcpy(
					(void*)n->internalSavedSuffix,
					(void*)unpackBits(
									packBitsBuffer,
									s_length,
									/*startAt*/ 0,
									/*l�nge interner suffix*/ s_intlength)
							.c_str(),
					s_intlength
					);
			}else{
				diskPagePool->read(n->internalSavedSuffix, nsIntSuffixSize);
				n->internalSavedSuffix[nsIntSuffixStringLength] = 0;
			}

			// ggf. noch die startPos
			if(n->testOption(NODE_OPTION_SUFFIX_HASSUFFIXSTART)){
				if(special_debug)streamout(cerr, nsIntSuffixStringLength);
				diskPagePool->read((char*)&n->suffixStart, sizeof(SUFFIXSTART_TYPE)); // 4
				if(special_debug)streamout(cerr, n->suffixStart);
			}else{
				// -2 --> nur interne Speicherung!
				//Wichtig hier zu setzen, wird ansonsten nicht beachtet!!!
				n->suffixStart = -2;
			}
		}else{ // hassuffix
			if(n->testOption(NODE_OPTION_HASCHAR_A)){
				diskPagePool->read((char*)&n->childNodesPos[0], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASCHAR_C)){
				diskPagePool->read((char*)&n->childNodesPos[1], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASCHAR_G)){
				diskPagePool->read((char*)&n->childNodesPos[2], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASCHAR_T)){
				diskPagePool->read((char*)&n->childNodesPos[3], sizeof(POS_TYPE));
			}
			if(n->testOption(NODE_OPTION_HASINFIX)){
				// infix-l�nge
				diskPagePool->read((char*)&n->infixLength, sizeof(LENGTH_TYPE));
				// infix selbst
				if(packBitsCompression_for_Infixes == true){
					diskPagePool->read(packBitsBuffer, nsInfixSize); // 24 // ONDISK
					LENGTH_TYPE s_length = (LENGTH_TYPE)n->infixLength / (LENGTH_TYPE)4;
					if(n->infixLength % 4 >0)++s_length;
					memcpy(
						(void*)packBitsBuffer,
						(void*)unpackBits(
										packBitsBuffer,
										s_length,
										0,
										n->infixLength)
									.c_str(),
						n->infixLength);
					packBitsBuffer[n->infixLength] = 0;
					n->suffix = string(packBitsBuffer, n->infixLength);
				}else{
					diskPagePool->read(packBitsBuffer, nsInfixSize);
					packBitsBuffer[n->infixLength] = 0;
					n->suffix = string(packBitsBuffer, n->infixLength);
				}
			}//infix

		}// else hassuffix
		for(int i = 0; i<MAXCHARS;++i){
			diskPagePool->read((char*)&n->freqVector[i], sizeof(unsigned int));
		}
		diskPagePool->read((char*)&n->minLength, sizeof(unsigned int));
		diskPagePool->read((char*)&n->maxLength, sizeof(unsigned int));
		// ende variabler teil
	}// mIsFixedSizeNode
	if(special_debug)cerr << "readNode(posID == " << n->posID << ") fertig" << endl;
}

/**
 * Liest den extern gespeicherten Suffix und f�gt diesen zum internen Suffix hinzu
 */
void PSpeicher::readSuffix(CharNode * n){
	if(special_debug)cerr << "readSuffix(posID == " << n->posID << ")" << endl;
	if(n->suffixStart < 0)return;

	if(packBitsCompression == true){
		if(special_debug)cerr << "readSuffix() packBits" << endl;
		char * r_suffix_packed = (char*)malloc((n->suffixLength/ALPHABET_COMPRESSION_FACTOR)+ALPHABET_COMPRESSION_FACTOR);
		LENGTH_TYPE extSuffixLength = n->suffixLength - nsIntSuffixStringLength;
		LENGTH_TYPE s_length = extSuffixLength / ALPHABET_COMPRESSION_FACTOR;
		LENGTH_TYPE mod_length = extSuffixLength % ALPHABET_COMPRESSION_FACTOR;
		LENGTH_TYPE mod_start = n->suffixStart % ALPHABET_COMPRESSION_FACTOR;
		if(mod_length + mod_start > 0){
			++s_length;
			if(mod_length + mod_start > (ALPHABET_COMPRESSION_FACTOR -1))++s_length;
		}

		//file_suffixe.seekg((int)n->suffixStart / (int)4);
		//file_suffixe.read(r_suffix_packed, s_length);

		suffixDiskPagePool->seekg((int)n->suffixStart / (int)ALPHABET_COMPRESSION_FACTOR);
		suffixDiskPagePool->read(r_suffix_packed, s_length);

		//n->setSuffix(unpackBits(r_suffix_packed, s_length, mod_start, n->suffixLength));
		//n->setSuffix(n->getIntSuffix().append(unpackBits(r_suffix_packed, s_length, mod_start, n->suffixLength)));
		n->setSuffix(n->getIntSuffix().append(unpackBits(r_suffix_packed, s_length, mod_start, extSuffixLength)));
		free(r_suffix_packed);
	}else{
		if(special_debug)cerr << "readSuffix() normal string" << endl;
		if(special_debug) streamout(cerr, n->suffixLength);
		if(special_debug) streamout(cerr, n->suffixStart);
		LENGTH_TYPE extSuffixLength = n->suffixLength - nsIntSuffixStringLength;
		if(special_debug) streamout(cerr, extSuffixLength);
		char * strBuffer = new char[(int)extSuffixLength+1];
		suffixDiskPagePool->seekg((unsigned int)n->suffixStart);
		suffixDiskPagePool->read(strBuffer, extSuffixLength); // nur der externe Teil ist gespeichert
		strBuffer[extSuffixLength] = 0;
		if(special_debug) streamout(cerr, strBuffer);

		string extSuffix(strBuffer, extSuffixLength);
		n->setSuffix(n->getIntSuffix().append(extSuffix));
		if(special_debug)cerr << "readSuffix() suffix(part) == " << extSuffix << endl;
		delete strBuffer;
	}
	// statistics
	++internalSuffixReadCount;
//	internalSuffixReadDistanceSum += abs(internalSuffixReadLastPos - n->suffixStart);
//	internalSuffixReadLastPos = n->suffixStart;

	if(special_debug)cerr << "readSuffix(posID == " << n->posID << ") fertig" << endl;
}

string PSpeicher::getExtSuffix(CharNode *n){
	if(special_debug)cerr << "readSuffix(posID == " << n->posID << ")" << endl;
	if(n->suffixStart < 0)return "";

	if(packBitsCompression == true){
		if(special_debug)cerr << "readSuffix() packBits" << endl;
		char * r_suffix_packed = (char*)malloc((n->suffixLength/ALPHABET_COMPRESSION_FACTOR)+ALPHABET_COMPRESSION_FACTOR);
		LENGTH_TYPE extSuffixLength = n->suffixLength - nsIntSuffixStringLength;
		LENGTH_TYPE s_length = extSuffixLength / ALPHABET_COMPRESSION_FACTOR;
		LENGTH_TYPE mod_length = extSuffixLength % ALPHABET_COMPRESSION_FACTOR;
		LENGTH_TYPE mod_start = n->suffixStart % ALPHABET_COMPRESSION_FACTOR;
		if(mod_length + mod_start > 0){
			++s_length;
			if(mod_length + mod_start > (ALPHABET_COMPRESSION_FACTOR -1))++s_length;
		}
		suffixDiskPagePool->seekg((int)n->suffixStart / (int)ALPHABET_COMPRESSION_FACTOR);
		suffixDiskPagePool->read(r_suffix_packed, s_length);

		string extSuffix(unpackBits(r_suffix_packed, s_length, mod_start, extSuffixLength));
		free(r_suffix_packed);
		return extSuffix;
	}else{
		if(special_debug)cerr << "readSuffix() normal string" << endl;
		if(special_debug) streamout(cerr, n->suffixLength);
		if(special_debug) streamout(cerr, n->suffixStart);
		LENGTH_TYPE extSuffixLength = n->suffixLength - nsIntSuffixStringLength;
		if(special_debug) streamout(cerr, extSuffixLength);
		char * strBuffer = new char[(int)extSuffixLength+1];
		suffixDiskPagePool->seekg((unsigned int)n->suffixStart);
		suffixDiskPagePool->read(strBuffer, extSuffixLength); // nur der externe Teil ist gespeichert
		strBuffer[extSuffixLength] = 0;
		if(special_debug) streamout(cerr, strBuffer);

		string extSuffix(strBuffer, extSuffixLength);
		return extSuffix;
	}
	return "";
	//if(special_debug)cerr << "readSuffix(posID == " << n->posID << ") fertig" << endl;

}

ostream& operator<<(ostream& stream, PSpeicher& p){
	return stream << "PSpeicher filename_baum== " << p.filename_baum << ", filename_suffixe== " << p.filename_suffixe << endl;
}

#define streamout(X,Y) X << #Y << " == " << Y << endl
ostream& PSpeicher::printStatistics(ostream& stream){
	stream << "PSpeicher::printStatistics()" << endl;
	streamout(stream, internalSuffixReadCount);
	streamout(stream, internalSuffixReadDistanceSum);
	streamout(stream, internalSuffixWriteCount);
	streamout(stream, internalSuffixWriteDistanceSum);
	return stream;
}


