#include <iostream>
#include "globals.hpp"
#include "Logger.hpp"

using namespace std;


Logger::Logger(string p_idxname, string p_idx_schema, string p_additional){
	if(global_var_use_odci){
		fileName = ODCI_DATA_SUBDIR + "log_" + p_idxname + "_" + p_idx_schema + "_" + p_additional + ".txt";
	}else{
		fileName = DATA_SUBDIR + "log_" + p_idxname + "_" + p_idx_schema + "_" + p_additional + ".txt";
	}
	f = fopen(fileName.c_str(), "w"); // wird immer überschrieben
	setbuf(f,NULL);
//	if(f){
//		 //okay
//	}else{
//		//aua!
//		throw -99;
//	}
}

Logger::~Logger(){
	if(f){fclose(f);}
}

void Logger::flush(){
	//if(f){fflush(f);}
}

void Logger::close(){
	//if(f){fclose(f);}
}

Logger& operator<<(Logger& logger, const string& p_string){
	if(logger.f)fprintf(logger.f,"%s",p_string.c_str());
	return logger;
}
Logger& operator<<(Logger& logger, const char * p_char){
	if(logger.f)fprintf(logger.f,"%s",p_char);
	return logger;
}
Logger& operator<<(Logger& logger, const int p_int){
	if(logger.f)fprintf(logger.f,"%d",p_int);
	return logger;
}
Logger& operator<<(Logger& logger, const long p_long){
	//if(logger.f)fprintf(logger.f,"%d",p_long);///////////////////////
	if(logger.f)fprintf(logger.f,"%d",(int)p_long);
	return logger;
}
Logger& operator<<(Logger& logger, const double p_double){
	if(logger.f)fprintf(logger.f,"%f",p_double);
	return logger;
}

