#include "globals.hpp"
#include "PTree.hpp"
#include "CharNode.hpp"
#include "Index.hpp"
#include "Watch.h"
#include <string>
#include <vector>

#define INITIALTABLESIZE 5000
#define checkPosCompDelete_ext(zeiger, zeiger_to_compare) if(zeiger != NULL && zeiger->posID != 0 && zeiger != zeiger_to_compare){zeiger->mPSpeicher->freeCharNode(zeiger);}
#define debug false
#define trefferdebug false

class ELA_Join {
	PTree *left;
	PTree *right;
	Index *leftIndex;
	Index *rightIndex;
	int treshold;
	vector < vector<int> > table;
	int **elaTable;
	int tableWidth;
	int tableHeigth;
	char * leftstr;
	char *rightstr;
	bool fvfilter;
	bool lengthfilter;
	bool qgramfilter;

	KeyPairVector kpv;
	TIDPairVector tpv;

public:
	ELA_Join(PTree *lefttree, PTree *righttree, int tresh, bool lenf, bool fvect, bool qgr){
		if (lefttree->mPSpeicher->getBaumSize()<righttree->mPSpeicher->getBaumSize()){
			left=lefttree;
			right=righttree;
		}
		else{
			left=righttree;
			right=lefttree;
		}
		treshold=tresh;
		elaTable = NULL;
		elaTable = new int*[INITIALTABLESIZE];
		fvfilter=fvect;
		lengthfilter=lenf;
		qgramfilter=qgr;
		leftstr = new char[INITIALTABLESIZE];
		rightstr = new char[INITIALTABLESIZE];
		tableWidth=INITIALTABLESIZE;
		tableHeigth=INITIALTABLESIZE;
		for (int i = 0; i < INITIALTABLESIZE;++i){
			elaTable[i]=NULL;
			elaTable[i]=new int[INITIALTABLESIZE];
			elaTable[i][0]=i;
			elaTable[0][i]=i;
		}
	}
	ELA_Join(Index *p_left_index, Index *p_right_index, int k_val, bool lenf, bool fvect,bool qgr) :
			leftIndex(p_left_index), rightIndex(p_right_index), treshold(k_val) {
				if(!p_left_index || !p_right_index) exit(-1);
				//make sure, that the left tree is the smallest
				if (p_left_index->getTree()->mPSpeicher->getBaumSize()<p_right_index->getTree()->mPSpeicher->getBaumSize()){
					left=p_left_index->getTree();
					right=p_right_index->getTree();
				}
				else{
					left=p_right_index->getTree();;
					right=p_left_index->getTree();
				}
				elaTable = NULL;
				elaTable = new int*[INITIALTABLESIZE];
				fvfilter=fvect;
				lengthfilter=lenf;
				qgramfilter=qgr;
				leftstr = new char[INITIALTABLESIZE];
				rightstr = new char[INITIALTABLESIZE];
				tableWidth=INITIALTABLESIZE;
				tableHeigth=INITIALTABLESIZE;
				for (int i = 0; i < INITIALTABLESIZE;++i){
					elaTable[i]=NULL;
					elaTable[i]=new int[INITIALTABLESIZE];
					elaTable[i][0]=i;
					elaTable[0][i]=i;
				}
			}
	int doTestJoin(string name_left, string name_right, int k,bool lf,bool ff, bool qgr);
	int join();
	KeyPairVector& doJoin_Trees();

private:
	int eLA(char a, char b, int pos_x, int pos_y);
	int kBand(char a, char b, int pos_x, int pos_y);
	void joinrecursive(CharNode *left, CharNode *right, int last_pos_left, int last_pos_right, int smallest_value_left, int smallest_value_right);
	char * resizeSeq(char * str, int length, int add);
	int ** resizeHeight(int length, int ** table);
	int ** resizeWidth(int length, int ** table);
	void compareLeftKeyNodeWithRightTree(CharNode* left, CharNode * right, int last_pos_right, int lastindexleft,bool isbigger);
	void compareRightKeyNodeWithLeftTree(CharNode * left, CharNode * right, int last_pos_left, int lastindexright,bool isbigger);
	void printtable(int left, int right);
	void printMatch(int left, int right);
	bool evalFreqVector(CharNode * left, CharNode * right, int posLeft, int posRight);
	bool evalFreqVectorForTwoSuffixes(CharNode * left, CharNode * right);
	bool evalFreqVectorForSuffix(CharNode * treenode, CharNode * suffnode, int posTree, int posSuffix);
	bool matchInternalQGrams(string& suffix, bool left, int firstpos,int lastindex);
	unsigned char hashUnsignedChar(char c);
};

extern "C" {
	int itf_ODCITableStart(char * schemaName, char * leftIndexName, char * rightIndexName, char ** rowids);
}
/**
 * Führt den Join für die TableFunction aus.
 *
 *
 */
int itf_ODCITableStart(char * schemaName, char * leftIndexName, char * rightIndexName, char ** rowids, int k){

	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Objekt bauen
	Index index_left(string(leftIndexName), string(schemaName),'W');
	Index index_right(string(rightIndexName), string(schemaName),'W');

	ELA_Join doJoin_Trees(&index_left, &index_right,k,true,true,true);

	return 0; // quasi fehler; eigentlich: leeres Ergebnis
}

KeyPairVector& ELA_Join::doJoin_Trees(){
	// Ergebnismenge leeren
	kpv.clear();
	// die rootNodes werden nicht gelöscht...!!!
	joinrecursive(left->getRootNode(),right->getRootNode(),0,0,0,0);

	return kpv;
}

//computes the simple Levensthein-Distance where the penalty for a mismatch is 1
int ELA_Join::eLA(char left, char right, int pos_left, int pos_right){
		int x(elaTable[pos_left-1][pos_right]+1);
		int y(elaTable[pos_left][pos_right-1]+1);
		int z(elaTable[pos_left-1][pos_right-1]);
		if (left!=right) z+=1;
		int returnval= x > y ? y : x;
		if(returnval>z) returnval=z;
		return returnval;
}

int ELA_Join::kBand(char left, char right, int pos_left, int pos_right){
	if(left == right) return elaTable[pos_left-1][pos_right-1];
	else return elaTable[pos_left-1][pos_right-1]+1;
}

bool ELA_Join::evalFreqVector(CharNode * left, CharNode * right, int posLeft, int posRight){

	int lengthdiff = abs((left->infixLength+left->suffixLength+posLeft)-(right->infixLength+right->suffixLength+posRight));
	if ((abs((int)left->freqVector[0]-(int)right->freqVector[0])-lengthdiff)>treshold) return false;
	if ((abs((int)left->freqVector[1]-(int)right->freqVector[1])-lengthdiff)>treshold) return false;
	if ((abs((int)left->freqVector[2]-(int)right->freqVector[2])-lengthdiff)>treshold) return false;
	if ((abs((int)left->freqVector[3]-(int)right->freqVector[3])-lengthdiff)>treshold) return false;
	else return true;
}

void ELA_Join::printtable(int l, int r){
	//TODO: zum testen reicht erstmal INITIALTABLESIZE, müsste aber noch geändert werden
	for(int i = 0; i < l;++i){
		for (int j = 0; j < r;++j){
			cerr << elaTable[i][j]<<" ";
		}
		cerr<<endl;
	}
}

void ELA_Join::joinrecursive(CharNode *left, CharNode *right, int last_pos_left, int last_pos_right, int smallest_value_left, int smallest_value_right){
	//smallest_value_left -> kleinster Wert in letzter berechneter Zeile der Matrix
	//smallest_value_right -> kleinster Wert in letzter berechneter Spalte der Matrix
	//last_pos_left -> Index der letzten berechneten Zeile der Matrix
	//last_pos_right -> Index der letzten berechneten Spalte der Matrix

	if ((smallest_value_left > treshold)&&(smallest_value_right> treshold)) {
		return;
	}
/////////Knoten left hat Infix
	if (left->hasInfix()){

		int leftInfixLength(left->infixLength);

		//berechne Matrix für infixLeft
		int infixpos(0);
		int val_right(smallest_value_right);
		int last(last_pos_left+leftInfixLength);
		for (int i = last_pos_left+1; i <= last;++i){
			leftstr[i]=left->getInfixRef()[infixpos++];
			int val_left(elaTable[i][0]);

			for (int j = 1; j<=last_pos_right;++j) {
				if (abs(i-j)>treshold) 	continue;
				elaTable[i][j]=kBand(leftstr[i],rightstr[j],i,j);
				if(elaTable[i][j] < val_left) val_left =  elaTable[i][j] ;
			}

			if(abs(i-last_pos_right)<=treshold){
				if (elaTable[i][last_pos_right]<val_right) val_right=elaTable[i][last_pos_right];
			}

			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if ((val_left > treshold)&&(val_right> treshold)) {
				return;
			}
		}

		//berechne Matrix für Kinder von left
		for (int i = 0; i < MAXCHARS; ++i){
			int lastleft(last_pos_left+leftInfixLength+1);
			int valri(val_right);
			if(left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				if(lengthfilter){
					if (child_left->minLength > right->maxLength) {
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
					if (right->minLength > child_left->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(child_left, right, lastleft, last_pos_right)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

				int val_left(elaTable[lastleft][0]);
				leftstr[lastleft]=unhashChar(i);
				for (int j = 1; j<=last_pos_right;++j) {
					if (abs(lastleft-j)>treshold) continue;
					elaTable[lastleft][j]=kBand(leftstr[lastleft],rightstr[j],lastleft,j);
					if(elaTable[lastleft][j] < val_left) val_left=elaTable[lastleft][j];
				}

				if(abs(lastleft-last_pos_right)<=treshold){
					if (elaTable[lastleft][last_pos_right]<valri) valri = elaTable[lastleft][last_pos_right];
				}

				if ((val_left > treshold)&&(valri> treshold)){
					left->mPSpeicher->freeCharNode(child_left);
					continue;
				}

				joinrecursive(child_left,right,lastleft,last_pos_right, val_left, valri);
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
	}
/////////Ende left hat Infix

/////////Knoten right hat Infix
	else if (right->hasInfix()){
		int rightInfixLength(right->infixLength);

		//berechne Matrix für infixRight
		int val_left(smallest_value_left);
		int infixpos(0);
		int last(last_pos_right+rightInfixLength);
		for (int i = last_pos_right+1; i <= last;++i){
			rightstr[i]=right->getInfixRef()[infixpos++];
			int val_right(elaTable[0][i]);

			for (int j = 1; j<=last_pos_left;++j) {
				if (abs(j-i)>treshold) continue;
				elaTable[j][i]=kBand(leftstr[j],rightstr[i],j,i);
				if(elaTable[j][i] < val_right) val_right= elaTable[j][i];
			}

			if(abs(last_pos_left-i)<=treshold){
				if(elaTable[last_pos_left][i]<val_left) val_left=elaTable[last_pos_left][i];
			}

			//kleinster Wert in letzter berechneter Spalte der Matrix ist größer als tresh -> stopp
			if ((val_right > treshold)&&(val_left> treshold)) {
				return;
			}
		}

		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			int valle(val_left);
			int lastright(last_pos_right+rightInfixLength+1);
			if(right->hasChild(i)){
				CharNode * child_right = right->getChild(i);
				if(lengthfilter){
					if (left->minLength > child_right->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
					if (child_right->minLength > left->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(left, child_right, last_pos_left, lastright)){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}

				int val_right(elaTable[0][lastright]);
				rightstr[lastright]=unhashChar(i);
				for (int j = 1; j<=last_pos_left;++j) {
					if (abs(j-lastright)>treshold) continue;
					elaTable[j][lastright]=kBand(leftstr[j],rightstr[lastright],j,lastright);
					if(elaTable[j][lastright] < val_right) val_right=elaTable[j][lastright];
				}

				if(abs(last_pos_left-lastright)<=treshold){
					if (elaTable[last_pos_left][lastright]<val_left) valle = elaTable[last_pos_left][lastright];
				}

				if ((val_right > treshold)&&(valle> treshold)) {
					right->mPSpeicher->freeCharNode(child_right);
					continue;
				}

				joinrecursive(left,child_right,last_pos_left,lastright, valle, val_right);
				right->mPSpeicher->freeCharNode(child_right);
			}
		}
	}
/////////Ende right hat Infix

/////////Left hat Suffix
	else if(left->hasSuffix()){

		string suffix(left->getIntSuffix());
		int suffixLength(left->suffixLength);

		//berechne Matrix für suffix
		int val_left(0);
		int suffpos(0);
		int val_right(smallest_value_right);
		for (int i = last_pos_left+1; i <= last_pos_left+suffixLength;++i){
			if(suffpos == (nsIntSuffixStringLength)){
				// nur genau einmal ausführen!
				suffix = left->getSuffix();
			}
			leftstr[i]=suffix[suffpos++];

			val_left = elaTable[i][0];
			for (int j = 1; j<=last_pos_right;++j) {
				if(abs(i-j)>treshold)continue;


				elaTable[i][j]=kBand(leftstr[i],rightstr[j],i,j);
				if(elaTable[i][j] < val_left) val_left=elaTable[i][j];
			}

			if(abs(i-last_pos_right)<=treshold){

				if (elaTable[i][last_pos_right]<val_right) val_right=elaTable[i][last_pos_right];
			}

			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if ((val_left > treshold)&&(val_right> treshold)) {
				return;
			}
		}

		if (val_left>treshold){
			compareLeftKeyNodeWithRightTree(left, right, last_pos_right,last_pos_left+suffixLength,true);
		}
		else{
			compareLeftKeyNodeWithRightTree(left, right, last_pos_right,last_pos_left+suffixLength,false);
		}
	}

/////////Right hat Suffix
	else if(right->hasSuffix()){

		string suffix(right->getIntSuffix());
		int suffixLength(right->suffixLength);

		//berechne Matrix für suffix
		int suffpos(0);
		int val_right(0);
		int val_left(smallest_value_left);
		int last(last_pos_right+suffixLength);
		for (int i = last_pos_right+1; i <=last ;++i){
			if(suffpos == (nsIntSuffixStringLength)){
				// nur genau einmal ausführen!
				suffix = right->getSuffix();
			}
			rightstr[i]=suffix[suffpos++];

			val_right = elaTable[0][i];
			for (int j = 1; j<=last_pos_left;++j) {
				if(abs(j-i)>treshold) continue;


				elaTable[j][i]=kBand(leftstr[j],rightstr[i],j,i);
				if(elaTable[j][i] < val_right) val_right= elaTable[j][i];
			}
			if(abs(last_pos_left-i)<=treshold){

				if(elaTable[last_pos_left][i]<val_left)val_left=elaTable[last_pos_left][i];
			}

			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if ((val_right > treshold)&&(val_left> treshold)){
				return;
			}
		}

		if (val_right > treshold){
			compareRightKeyNodeWithLeftTree(left, right,last_pos_left,last_pos_right+suffixLength,true);
		}
		else{
			compareRightKeyNodeWithLeftTree(left, right,last_pos_left,last_pos_right+suffixLength,false);
		}
	}
/////////Ende right hat Suffix

/////////left ist innerer Knoten mit Schlüssel
	else if(left->hasKey()){
		if (smallest_value_left>treshold)
			compareLeftKeyNodeWithRightTree(left, right, last_pos_right,last_pos_left,true);
		else
			compareLeftKeyNodeWithRightTree(left, right, last_pos_right,last_pos_left,false);

		//Untersuche auch die Kinder von left
		for (int i = 0; i < MAXCHARS; ++i){
			int val_right(smallest_value_right);
			int lastleft(last_pos_left+1);
			if(left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				if(lengthfilter){
					if (child_left->minLength > right->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
					if (right->minLength > child_left->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(child_left, right, lastleft, last_pos_right)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				int val_left(elaTable[lastleft][0]);
				leftstr[lastleft]=unhashChar(i);
				for (int j = 1; j<=last_pos_right;++j) {
					if(abs(lastleft-j)>treshold)continue;


					elaTable[lastleft][j]=kBand(leftstr[lastleft],rightstr[j],lastleft,j);
					if(elaTable[lastleft][j] < val_left) val_left= elaTable[lastleft][j];
				}

				if(abs(lastleft-last_pos_right)<=treshold){

					if(elaTable[lastleft][last_pos_right]<val_right) val_right=elaTable[lastleft][last_pos_right];
				}

				if ((val_left > treshold)&&(val_right> treshold)){
					left->mPSpeicher->freeCharNode(child_left);
					continue;
				}

				joinrecursive(child_left,right,lastleft,last_pos_right, val_left, val_right);
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
	}
/////////Ende left ist innerer Knoten mit Schlüssel

/////////right ist innerer Knoten mit Schlüssel
	else if(right->hasKey()){
		if (smallest_value_right > treshold){
			compareRightKeyNodeWithLeftTree(left, right,last_pos_left,last_pos_right,true);
		}
		else{
			compareRightKeyNodeWithLeftTree(left, right,last_pos_left,last_pos_right,false);
		}
		//Untersuche auch die Kinder von right
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			int val_left(smallest_value_left);
			int lastright(last_pos_right+1);
			if(right->hasChild(i)){
				CharNode * child_right = right->getChild(i);
				if(lengthfilter){
					if (left->minLength > child_right->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
					if (child_right->minLength > left->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(left, child_right, last_pos_left, lastright)){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				int val_right(elaTable[0][lastright]);
				rightstr[lastright]=unhashChar(i);
				for (int j = 1; j<=last_pos_left;++j) {
					if(abs(j-lastright)>treshold)continue;


					elaTable[j][lastright]=kBand(leftstr[j],rightstr[lastright],j,lastright);
					if(elaTable[j][lastright] < val_right) val_right=elaTable[j][lastright];
				}

				//adjust smallest_value_right if necessary
				if(abs(last_pos_left-lastright)<=treshold){

					if (elaTable[last_pos_left][lastright]<val_left) val_left= elaTable[last_pos_left][lastright];
				}

				if ((val_right > treshold)&&(val_left> treshold)){
					//if(debug) cerr << "(val_right > treshold)&&(smallest_value_left> treshold).next."<<endl;
					right->mPSpeicher->freeCharNode(child_right);
					continue;
				}

				joinrecursive(left,child_right,last_pos_left,lastright, val_left, val_right);
				right->mPSpeicher->freeCharNode(child_right);
			}
		}
	}
/////////Ende right ist innerer Knoten mit Schlüssel

/////////links o. rechts haben Kinder
	else {
		//berechne Matrix für Kinder von left
		for (int i = 0; i < MAXCHARS; ++i){
			int val_right(smallest_value_right);
			int lastleft(last_pos_left+1);
			if(left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				if(lengthfilter){
					if (child_left->minLength > right->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
					if (right->minLength > child_left->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(child_left, right, lastleft, last_pos_right)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

				int val_left(elaTable[lastleft][0]);
				leftstr[lastleft]=unhashChar(i);
				for (int j = 1; j<=last_pos_right;++j) {
					if(abs(lastleft-j)>treshold) continue;


					elaTable[lastleft][j]=kBand(leftstr[lastleft],rightstr[j],lastleft,j);
					if(elaTable[lastleft][j] < val_left) val_left=elaTable[lastleft][j];
				}

				//adjust smallest_value_right
				if(abs(lastleft-last_pos_right)<=treshold){

					if(elaTable[lastleft][last_pos_right]<val_right) val_right=elaTable[lastleft][last_pos_right];
				}

				if ((val_left > treshold)&&(val_right> treshold)) {
					left->mPSpeicher->freeCharNode(child_left);
					continue;
				}


				//berechne Matrix für Kinder von right
				for (int j = 0; j < MAXCHARS; ++j){
					int valle(val_left);
					int lastright(last_pos_right+1);
					if(right->hasChild(j)){

						CharNode * child_right = right->getChild(j);
						if(lengthfilter){
							if (child_left->minLength > child_right->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
							if (child_right->minLength > child_left->maxLength){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}
						if(fvfilter){
							if(!evalFreqVector(child_left, child_right, lastleft, lastright)){
								right->mPSpeicher->freeCharNode(child_right);
								continue;
							}
						}

						val_right = elaTable[0][lastright];
						rightstr[lastright]=unhashChar(j);
						for (int k = 1; k<=lastleft;++k) {
							if(abs(k-lastright)>treshold) continue;


							elaTable[k][lastright]=kBand(leftstr[k],rightstr[lastright],k,lastright);
							if(elaTable[k][lastright] < val_right) val_right=elaTable[k][lastright];
						}

						//adjust lastleft if necessary
						if(abs(lastleft-lastright)<=treshold){

							if(elaTable[lastleft][lastright]<valle)valle=elaTable[lastleft][lastright];
						}

						if ((val_right > treshold)&&(valle> treshold)) {
							right->mPSpeicher->freeCharNode(child_right);
							continue;
						}

						joinrecursive(child_left,child_right,lastleft,lastright, valle, val_right);
						right->mPSpeicher->freeCharNode(child_right);
					}
				}
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
	}
/////////Ende links/rechts haben Kinder


}

void ELA_Join::compareLeftKeyNodeWithRightTree(CharNode *left, CharNode * right, int last_pos_right, int lastindexleft, bool isbigger){

	if (right->hasInfix()){
		int rightInfixLength(right->infixLength);
		//berechne Matrix für infixRight
		bool bigger(isbigger);
		int infixpos(0);
		int last(last_pos_right+rightInfixLength);
		for (int i = last_pos_right+1; i <= last;++i){
			rightstr[i]=right->getInfixRef()[infixpos++];

			int val_right(elaTable[0][i]);
			for (int j = 1; j<=lastindexleft;++j) {
				if(abs(j-i)>treshold) continue;


				elaTable[j][i]=kBand(leftstr[j],rightstr[i],j,i);
				val_right = elaTable[j][i] < val_right ? elaTable[j][i] : val_right;
			}

			//adjust isbigger
			if(bigger){
				if(abs(lastindexleft-i)<=treshold) {

					if (elaTable[lastindexleft][i]<=treshold){
						bigger=false;
						continue;
					}
				}
				//kleinster Wert in letzter berechneter Spalte der Matrix ist größer als tresh -> stopp
				if (val_right > treshold) {
					return;
				}
			}
		}

		bool bb(bigger);
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			int lastright(last_pos_right+rightInfixLength+1);
			if(right->hasChild(i)){
				CharNode * child_right = right->getChild(i);
				if(lengthfilter){
					if (left->minLength > child_right->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
					if (child_right->minLength > left->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(left, child_right, lastindexleft,lastright)) continue;
				}

				int val_right(elaTable[0][lastright]);
				rightstr[lastright]=unhashChar(i);
				for (int j = 1; j<=lastindexleft;++j) {
					if(abs(j-lastright)>treshold) continue;


					elaTable[j][lastright]=kBand(leftstr[j],rightstr[lastright],j,lastright);
					if(elaTable[j][lastright] < val_right) val_right=elaTable[j][lastright];
				}
				if(abs(lastindexleft-lastright)<=treshold) {

					if((elaTable[lastindexleft][lastright]<=treshold)&&bb) bb=false;
				}

				if (bigger && (val_right > treshold)) {
					right->mPSpeicher->freeCharNode(child_right);
					continue;
				}

				compareLeftKeyNodeWithRightTree(left,child_right,lastright,lastindexleft,bb);
				right->mPSpeicher->freeCharNode(child_right);
			}
		}
	}

	else if(right->hasSuffix()){
		int length(right->suffixLength);
		if(abs(lastindexleft-(last_pos_right+length))>treshold){
			//cerr << "(2)last cell is bigger"<<endl;
			return;
		}
		string suffix(right->getIntSuffix());

		if(qgramfilter){
			if(!matchInternalQGrams(suffix, false, lastindexleft-length+1,lastindexleft-length+1+suffix.length())) return;
		}

		//berechne Matrix für suffix
		int suffpos(0);
		int last(last_pos_right+length);
		for (int i = last_pos_right+1; i <= last;++i){
			if(suffpos == (nsIntSuffixStringLength)){
				// nur genau einmal ausführen!
				suffix = right->getSuffix();
				if(qgramfilter){
					if(!matchInternalQGrams(suffix, false, lastindexleft-length+1,lastindexleft))return;
				}
			}
			rightstr[i]=suffix[suffpos++];

			int val_right(elaTable[0][i]);
			for (int j = 1; j<=lastindexleft;++j) {
				if(abs(j-i)>treshold) continue;


				elaTable[j][i]=kBand(leftstr[j],rightstr[i],j,i);
				if(elaTable[j][i] < val_right) val_right=elaTable[j][i];
			}
			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if (isbigger && (val_right > treshold)) {
//				cerr << "mismatch in right suffix, pos "<<i<<"/"<<last<<endl;
				return;
			}
		}

		if(abs(lastindexleft-(last_pos_right+length))<=treshold){
			//Treffer!!Mache was Schönes

			if (elaTable[lastindexleft][last_pos_right+length]<=treshold){
				KeyPair kp(left->getKey(), right->getKey());
				kpv.push_back(kp);
//				printMatch(lastindexleft,last_pos_right+length);
				return;
			}
		}
	}

	else if(right->hasKey()){
		if(abs(lastindexleft-last_pos_right)<=treshold){
			KeyPair kp(left->getKey(), right->getKey());
			kpv.push_back(kp);
//			printMatch(lastindexleft, last_pos_right);
		}

		//weiter mit Kindern von right
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			bool bigger(isbigger);
			int lastright(last_pos_right+1);
			if(right->hasChild(i)){
				CharNode * child_right = right->getChild(i);
				if(lengthfilter){
					if (left->minLength > child_right->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
					if (child_right->minLength > left->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(left, child_right, lastindexleft,lastright)){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}

				int val_right(elaTable[0][lastright]);
				rightstr[lastright]=unhashChar(i);
				for (int j = 1; j<=lastindexleft;++j) {
					if(abs(j-lastright)>treshold)continue;


					elaTable[j][lastright]=kBand(leftstr[j],rightstr[lastright],j,lastright);
					if(elaTable[j][lastright] < val_right) val_right= elaTable[j][lastright];
				}

				if(bigger){
					//adjust isbigger if necessary
					if(abs(lastindexleft-lastright)<=treshold){

						if(elaTable[lastindexleft][lastright]<=treshold){
							bigger=false;
						}
					}
					if(bigger&&(val_right>treshold)){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}

				compareLeftKeyNodeWithRightTree(left, child_right,lastright,lastindexleft,bigger);
				right->mPSpeicher->freeCharNode(child_right);
			}
		}
	}

	else if(right->hasChildren()){
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			bool bigger(isbigger);
			int lastright(last_pos_right+1);
			if(right->hasChild(i)){
				CharNode * child_right = right->getChild(i);
				if(lengthfilter){
					if (left->minLength > child_right->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
					if (child_right->minLength > left->maxLength){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(left, child_right, lastindexleft,lastright)){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}
				int val_right(elaTable[0][lastright]);
				rightstr[lastright]=unhashChar(i);
				for (int j = 1; j<=lastindexleft;++j) {
					if(abs(j-lastright)>treshold)continue;


					elaTable[j][lastright]=kBand(leftstr[j],rightstr[lastright],j,lastright);
					if(elaTable[j][lastright] < val_right) val_right= elaTable[j][lastright];
				}

				if(bigger){
					if(abs(lastindexleft-lastright)<=treshold){
						//adjust isbigger if necessary

						if(elaTable[lastindexleft][lastright]<=treshold){
							bigger=false;
						}
					}
					if (bigger&&(val_right>treshold)){
						right->mPSpeicher->freeCharNode(child_right);
						continue;
					}
				}

				compareLeftKeyNodeWithRightTree(left, child_right,lastright,lastindexleft,bigger);
				right->mPSpeicher->freeCharNode(child_right);
			}
		}
	}
}


void ELA_Join::compareRightKeyNodeWithLeftTree(CharNode * left,CharNode * right, int last_pos_left, int lastindexright, bool isbigger){

	if (left->hasInfix()){
		int leftInfixLength(left->infixLength);
		//berechne Matrix für infixRight
		int infixpos(0);
		bool bigger(isbigger);
		int last(last_pos_left+leftInfixLength);
		for (int i = last_pos_left+1; i <= last;++i){
			leftstr[i]=left->getInfixRef()[infixpos++];

			int val_left(elaTable[i][0]);
			for (int j = 1; j<=lastindexright;++j) {
				if(abs(i-j)>treshold)continue;


				elaTable[i][j]=kBand(leftstr[i],rightstr[j],i,j);
				if(elaTable[i][j] < val_left) val_left=elaTable[i][j];
			}

			//adjust isbigger
			if(bigger){
				if(abs(i-lastindexright)<=treshold){

					if (elaTable[i][lastindexright]<=treshold){
						bigger=false;
						continue;
					}
				}
				//kleinster Wert in letzter berechneter Spalte der Matrix ist größer als tresh -> stopp
				if (val_left > treshold) {
					return;
				}
			}
		}


		bool bb(bigger);
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			int lastleft = last_pos_left+leftInfixLength+1;
			if(left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				if(lengthfilter){
					if (child_left->minLength > right->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
					if (right->minLength > child_left->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(child_left, right, lastleft,lastindexright)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

				int val_left(elaTable[lastleft][0]);
				leftstr[lastleft]=unhashChar(i);
				for (int j = 1; j<=lastindexright;++j) {
					if(abs(lastleft-j)>treshold) continue;


					elaTable[lastleft][j]=kBand(leftstr[lastleft],rightstr[j],lastleft,j);
					if(elaTable[lastleft][j] < val_left) val_left=elaTable[lastleft][j];
				}
				if(abs(lastleft-lastindexright)<=treshold){

					if((elaTable[lastleft][lastindexright]<=treshold)&&bb) bb=false;
				}
				if (bigger && (val_left > treshold)) {
					left->mPSpeicher->freeCharNode(child_left);
					continue;
				}
				compareRightKeyNodeWithLeftTree(child_left,right,lastleft,lastindexright,bb);
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
	}

	else if(left->hasSuffix()){
		int length(left->suffixLength);
		if(abs((last_pos_left+length)-lastindexright)>treshold){
			return;
		}
		string suffix(left->getIntSuffix());

		if(qgramfilter){
			if(!matchInternalQGrams(suffix, true, lastindexright-length+1,lastindexright-length+1+suffix.length())) return;
		}

		//berechne Matrix für suffix
		int suffpos(0);
		int last(last_pos_left+length);
		for (int i = last_pos_left+1; i <= last;++i){
			if(suffpos==(nsIntSuffixStringLength)){
				suffix=left->getSuffix();
				if(qgramfilter){
					if(!matchInternalQGrams(suffix, true, lastindexright-length+1,lastindexright)) return;
				}
			}
			leftstr[i]=suffix[suffpos++];

			int val_left(elaTable[i][0]);
			for (int j = 1; j<=lastindexright;++j) {
				if(abs(i-j)>treshold)continue;
				elaTable[i][j]=kBand(leftstr[i],rightstr[j],i,j);
				if(elaTable[i][j] < val_left) val_left=elaTable[i][j];
			}
			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if (isbigger && (val_left > treshold)) {
//				cerr << "mismatch in left suffix, pos "<<i<<"/"<<last<<endl;
				return;
			}
		}

		if(abs((last_pos_left+length)-lastindexright)<=treshold){
			//Treffer!!Mache was Schönes
			KeyPair kp(left->getKey(), right->getKey());
			kpv.push_back(kp);
			return;
//			printMatch(last_pos_left+length,lastindexright);

		}
	}

	else if(left->hasKey()){
		//auf jeden Fall ein Treffer, treshold wurde schon vor Rek.abstieg geprüft
		if(abs(last_pos_left-lastindexright)<=treshold){
//			printMatch(last_pos_left,lastindexright);
			KeyPair kp(left->getKey(), right->getKey());
			kpv.push_back(kp);
		}

		//weiter mit Kindern von right
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			bool bigger(isbigger);
			int lastleft(last_pos_left+1);
			if(left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				if(lengthfilter){
					if (child_left->minLength > right->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
					if (right->minLength > child_left->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(child_left, right, lastleft, lastindexright)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

				int val_left(elaTable[lastleft][0]);
				leftstr[lastleft]=unhashChar(i);
				for (int j = 1; j<=lastindexright;++j) {
					if(abs(lastleft-j)>treshold)continue;


					elaTable[lastleft][j]=kBand(leftstr[lastleft],rightstr[j],lastleft,j);
					if(elaTable[lastleft][j] < val_left) val_left=elaTable[lastleft][j];
				}

				if(bigger){
					if(abs(lastleft-lastindexright)<=treshold){
						//adjust isbigger if necessary

						if(elaTable[lastleft][lastindexright]<=treshold){
							bigger=false;
						}
					}
					if(bigger && (val_left>treshold)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

				compareRightKeyNodeWithLeftTree(child_left,right,lastleft,lastindexright,bigger);
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
	}

	else if(left->hasChildren()){
		//berechne Matrix für Kinder von right
		for (int i = 0; i < MAXCHARS; ++i){
			bool bigger(isbigger);
			int lastleft(last_pos_left+1);
			if(left->hasChild(i)){
				CharNode * child_left = left->getChild(i);
				if(lengthfilter){
					if (child_left->minLength > right->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
					if (right->minLength > child_left->maxLength){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}
				if(fvfilter){
					if(!evalFreqVector(child_left, right, lastleft,lastindexright)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

				int val_left(elaTable[lastleft][0]);
				leftstr[lastleft]=unhashChar(i);
				for (int j = 1; j<=lastindexright;++j) {
					if(abs(lastleft-j)>treshold)continue;


					elaTable[lastleft][j]=kBand(leftstr[lastleft],rightstr[j],lastleft,j);
					if(elaTable[lastleft][j] < val_left) val_left=elaTable[lastleft][j];
				}
				if(bigger){
					if(abs(lastleft-lastindexright)<=treshold){
						//adjust isbigger if necessary

						if(elaTable[lastleft][lastindexright]<=treshold){
							bigger=false;
						}
					}
					if(bigger && (val_left>treshold)){
						left->mPSpeicher->freeCharNode(child_left);
						continue;
					}
				}

//				if (evalFreqVector(child_left->freqVector, right->freqVector,lastleft-lastindexright))
				compareRightKeyNodeWithLeftTree(child_left,right,lastleft,lastindexright,bigger);
				left->mPSpeicher->freeCharNode(child_left);
			}
		}
	}
}

void ELA_Join::printMatch(int last_pos_left, int last_pos_right){
	//cout << "Match with ela="<<elaTable[last_pos_left][last_pos_right]<<endl;
//	int fv[]={0,0,0,0};
	for (int i= 1; i <= last_pos_left; ++i){
		cout << leftstr[i];
//		fv[hashChar(leftstr[i])]++;
	}
	cout<<endl;
//	cout<<"\n"<<fv[0]<<"\t"<<fv[1]<<"\t"<<fv[2]<<"\t"<<fv[3]<<endl;
//	for (int i= 1; i <= last_pos_right; ++i) cout << rightstr[i];
//	cout<<endl;
}


bool ELA_Join::matchInternalQGrams(string& suffix, bool is_left, int firstpos, int lastpos){
	if(lastpos-firstpos<4)return true;
	if(suffix.length()<4)return true;
	char * suff_right;
	if (!is_left) suff_right = leftstr;
	else suff_right = rightstr;
	int q = 4;
	int size = (int)pow(MAXCHARS,q);
	int qgramleft[size];//256
	bool seenleft[size];
	bool seenright[size];
	int allowed_mismatches = (suffix.length()-q+1)-(suffix.length()-1-(treshold-1)*q);
	//int allowed_mismatches=treshold*4;
	int mismatches(0);
	memset(qgramleft, -1, size * sizeof(int));
	memset(seenleft, 0, size * sizeof(bool));
	memset(seenright, 0, size * sizeof(bool));

	int left(0);
	int right(0);
	if (firstpos<1)firstpos=1;

	left = hashChar(suffix[0]);
	left = left | (hashChar(suffix[1])<<2);
	left = left | (hashChar(suffix[2])<<4);
	left = left | (hashChar(suffix[3])<<6);
	qgramleft[left]=1;
	seenleft[left]=true;
	int j=2;
	for(unsigned int i=4;i<suffix.length();++i){
		left=left>>2;
		left = left | (hashChar(suffix[i])<<6);
		++j;
		if (!seenleft[left]){
			qgramleft[left]=j;
			seenleft[left]=true;
		}
	}

	right = hashChar(suff_right[firstpos]);
	right = right | (hashChar(suff_right[firstpos+1])<<2);
	right = right | (hashChar(suff_right[firstpos+2])<<4);
	right = right | (hashChar(suff_right[firstpos+3])<<6);

	j=1;
	for(int i=firstpos+4;i<=lastpos;++i){
		if(mismatches>allowed_mismatches) return false;
		if(!seenleft[right]) ++mismatches;
		else{
			if(!seenright[right]){
			seenright[right]=true;
			if(abs(qgramleft[right]-j)>treshold) ++mismatches;
			}
		}
		j++;
		right=right>>2;
		right = right | (hashChar(suff_right[i])<<6);
	}


	if(mismatches>allowed_mismatches) return false;
	else return true;
}


char * ELA_Join::resizeSeq(char * str, int length, int add){
	char * newstr = new char [length+add];
	for (int i = 0; i < length;++i){
		newstr[i]=str[i];
	}
	delete[] str;
	return newstr;
}

int ** ELA_Join::resizeHeight(int length, int ** table){
	int ** newTable = new int* [tableHeigth+length];
	for (int i = 0; i < tableHeigth+length;++i){
		newTable[i]=new int [tableWidth];
		newTable[i][0]=i;
	}
	for (int i = 0; i < tableHeigth;++i){
		for (int j = 0; j < tableWidth;++j){
			newTable[i][j]=table[i][j];
		}
		delete[] table[i];
	}

	tableHeigth += length;
	delete[] table;

	return newTable;
}

int ** ELA_Join::resizeWidth(int length, int ** table){
	int ** newTable = new int* [tableHeigth];
	for (int i = 0; i < tableHeigth;++i){
		newTable[i]=new int [tableWidth+length];
		for (int j = 0; j < tableWidth;++j){
			newTable[i][j]=table[i][j];
		}
		delete[] table[i];
	}
	for (int i = tableWidth; i < tableWidth+length;++i){
			newTable[0][i]=i;
		}
	delete[] table;
	tableWidth += length;
	return newTable;
}



int ELA_Join::join(){
	//cerr << "initial table" <<endl;
//	printtable();
	joinrecursive(left->getRootNode(),right->getRootNode(),0,0,0,0);
	//cerr << "done" << endl;
	return 0;
}

int doTestJoin(string name_left, string name_right, int k,bool lf,bool ff,bool qgr){
	Index * left = new Index(name_left,string("_"), 'W');
	Index * right = new Index(name_right,string("_"), 'W');

//	cerr << "left:" << endl;
//	left->getTree()->getRootNode()->print();;
//	cerr << "right:" << endl;
//	right->getTree()->getRootNode()->print();



	ELA_Join j(left, right, k,lf,ff,qgr);
	KeyPairVector& kpv = j.doJoin_Trees();
	for(KeyPairVector::iterator it = kpv.begin(); it != kpv.end(); ++it){
		cerr << "Joined Pair < " << (*it).first << ", " << (*it).second << " >" << endl;
	}
	CharNode::printRuntimeStats(cerr);
	PSpeicher::printStatistics(cerr);
//	j.join();

	delete left;
	delete right;

	return 0;
}


int main(int argc, char ** argv){
	// ./elajoin.out AdbEST_part1_native_stripped.dat BdbEST_part1_native_stripped.dat OJ k1
	Watch watch;
	// F - File insert
	// I - IOOrder
	// S - Statistics

	char operation = 0;
	char * fileNameA = "";
	char * fileNameB = "";
	char * destSubDir = "";
	bool fvect=false;
	bool lenfilter=false;
	bool qgram = false;
	int k = 0;
	char * note = ""; // eine Notiz, die dann an die Ausgabe weitergegeben wird
	int suffixSize = DEFAULT_INTERNALSAVEDSUFFIXSIZE; // _ONDISK;
	int infixSize = DEFAULT_INTERNALSAVEDINFIXSIZE; //b_ONDISK;
	int nodePageSize = DEFAULT_PAGESIZE_ON_DISK;
	int suffixPageSize = DEFAULT_SUFFIX_PAGESIZE_ON_DISK;
	int nodePagesInBuffer = DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY;
	int suffixPagesInBuffer = DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY;

	for(int i=1; i < argc; ++i){

		switch(*argv[i]){

			case 'O': // Operation
				operation = argv[i][1];
				break;
			case 's': // suffix size
				suffixSize = atoi(&(argv[i][1]));
				break;
			case 'i': // infix size
				infixSize = atoi(&(argv[i][1]));
				break;

			case 'S': // suffix page size
				suffixPageSize = atoi(&(argv[i][1]));
				break;
			case 'P': // node page size
				nodePageSize = atoi(&(argv[i][1]));
				break;
			case 'f'://use frequency vector filtering: default: false
				fvect=true;
				break;
			case 'l'://use length filtering: default: false
				lenfilter=true;
				break;
			case 'q'://use qgrams:default:false
				qgram=true;
				break;
			case 'T': // suffix pages in buffer
				suffixPagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'Q': // node pages in buffer;
				nodePagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'A': // FileName A
				fileNameA = &argv[i][1];
				break;
			case 'B': // FileName B
				fileNameB = &argv[i][1];
				break;
			case 'k':
				k = atoi(&(argv[i][1]));
				break;
			case 'D': // Destination subdir // unused
				destSubDir = &argv[i][1];
				break;
			case 'C':
				if(argv[i][1] == '+')packBitsCompression = true;
				if(argv[i][1] == '-')packBitsCompression = false;
				break;
			case 'c':
				if(argv[i][1] == '+')packBitsCompression_for_Infixes = true;
				if(argv[i][1] == '-')packBitsCompression_for_Infixes = false;
				break;
			case 'N': // Notiz
				note = &argv[i][1];
				break;
			default:
				break;
		}
	}

	switch(operation){
		case 'J':{
			doTestJoin(string(fileNameA), string(fileNameB),k,lenfilter,fvect,qgram);
			break;}
		default:
			break;
	}



	return 0;
}
