
#ifndef _CONTAINER_SIMPLE_HPP_
#define _CONTAINER_SIMPLE_HPP_

#include <iostream>
#include <fstream>
#include <string>
#include <map>
#include <vector>
#include "stdlib.h"///////////////
#include "string.h"
#include "globals.hpp"

using namespace std;

typedef pair<KEY_TYPE, string> ContainerPair;
typedef pair<KEY_TYPE, POS_TYPE> ContainerIndexPair;

typedef multimap<KEY_TYPE, string> ContainerBlock;
typedef multimap<KEY_TYPE, POS_TYPE> ContainerBlockIndex;

typedef ContainerBlock::iterator ContainerBlockIterator;
typedef ContainerBlockIndex::iterator ContainerBlockIndexIterator;

typedef pair<ContainerBlockIterator,ContainerBlockIterator> ContainerBlockIteratorPair;


/**
 * Implementiert den einfachen Container. Zum Erstellen werden die Daten komplett im RAM gehalten
 * und dann geschrieben, für Leseoperationen wird ein Zusätzlicher Index benutzt.
 */
class Container_simple {
	// Container ansich
	ContainerBlock container;
	// Index für den Container
	ContainerBlockIndex containerindex;
	bool isLoaded;

	// Name des Containers (für die Datei)
	string container_idxname;
	string container_idxschema;
	string container_file_name;
	string container_indexfile_name;

	char modus;

	// filestream für den Container
	fstream container_file;
	fstream container_indexfile;

public:

	// C'tor --> öffnet die entsprechende Container-Datei
	//Container_simple(string p_container_name, char p_modus);
	/**
	 * erstellt einen neuen Container mit name, schema und modus
	 */
	Container_simple(string p_name, string p_schema, char p_modus);
	~Container_simple();

	/**
	 * fügt einen Schlüssel und die zugehörige rowid ein
	 */
	void insert(KEY_TYPE key, string& p_TID);
	/**
	 * löscht alle Einträge dieses Schlüssels
	 */
	void erase(KEY_TYPE key); // löscht alle pairs mit key
	/**
	 * löscht nur den Eintrag des Schlüssels, der die angegebene rowid hat.
	 */
	void erase(KEY_TYPE key, string& p_TID); // löscht alle pairs mit key, p_TID --> sollte nur genau eins sein, da TID unique!

	/**
	 * prüft, ob ein Schlüssel vorhanden ist
	 */
	bool find(KEY_TYPE key); // wenn ein Schlüssel vorhanden ist, dann true

	/**
	 * holt die rowids für einen einzelnen Schlüssel
	 */
	void get(StringVector& sv, KEY_TYPE key);
	/**
	 * holt die rowids für eine range
	 */
	void getRange(StringVector& sv, KEY_TYPE key_from, KEY_TYPE key_to);
	/**
	 * holt die rowids für mehrere ranges
	 */
	void getRange(StringVector& sv, KeyPairVector& kpv); // quasi MultiRange

	/**
	 * gibt die Anzahl der verschiedenen Schlüssel zurück
	 */
	int getNumberOfDistinctKeys();
	/**
	 * tauscht den Schlüssel aus, ohne die rowid zu ändern
	 */
	void updateKey(KEY_TYPE oldKey, KEY_TYPE newKey);
	/**
	 * tauscht viele Schlüssel aus
	 */
	void updateKeys(AlterKeysMap& map_alterkeys); // soll sich um den massenhaften update der Keys kümmern


	//void output_container();
	void save(){ writeContainer();}
	void load(){ readContainer();}

private:

	KEY_TYPE getPreviousKey(KEY_TYPE key);
	KEY_TYPE getNextKey(KEY_TYPE key);
	void checkCreateFile();
	void openContainerFile();
	int  getContainerFileSize();
	int  getContainerIndexFileSize();


	// liest den kompletten Container ein
	// einfach das ganze File lesen und die einzelnen Daten einfügen
	void readContainer(int startpos = -1);
	// Index einlesen
	void readContainerIndex();
	// schreibt den Kompletten Container in die Datei
	bool writeContainer();

	// Lesen das Containers aus dem Array
	void charArrayToContainerBlock(ContainerBlock& cb, char * charArray, int size);
	// Vorbereitung zum Schreiben
	char * containerToCharArray(ContainerBlock& cb);

};

#endif

