#ifndef _CHARNODE_HPP_
#define _CHARNODE_HPP_

// f�r vc++, hinweis auf int als bool
#ifdef _WIN32
	#pragma warning(disable:4800)	// int als bool verwenden
#endif

class CharNode;

#include "globals.hpp"
#include "PSpeicher.hpp"
#include "math.h"


/**
 * OptionByte-EInstellungen.
 */
#define NODE_OPTION_HASKEY 1U
#define NODE_OPTION_HASSUFFIX 2U
#define NODE_OPTION_HASINFIX 4U
#define NODE_OPTION_HASCHAR_A 8U
#define NODE_OPTION_HASCHAR_C 16U
#define NODE_OPTION_HASCHAR_G 32U
#define NODE_OPTION_HASCHAR_T 64U
#define NODE_OPTION_ISFIXED 128U
#define NODE_OPTION_INDIRECTION (NODE_OPTION_HASSUFFIX & NODE_OPTION_HASINFIX)
	// indirection, wenn hasSuffix && hasInfix == optionByte + posID
#define NODE_OPTION_SUFFIX_HASSUFFIXSTART 8U
	// �berschrieben f�r Suffix; wenn Suffix komplett im Knoten, dann kein startPos notwendig
	// wenn Suffix vorhanden, aber intern gespeichert, dann SuffixStart == -2

/**
 * Berechnet die Gr��e des Knotens f�r die variablen Knoten auf der Grundlage des Optionbytes
 */
extern int getNodeSizeOnDisk(unsigned char p_optionByte);

/**
 * Implementiert die Knoten-Klasse.
 */
class CharNode {
	// BitField �ber den Aufbau des Knotens
	unsigned char optionByte;

	/**
	 * Zugriffsopertionen f�r das OptionByte
	 */
	void setOption(unsigned char nodeOption){optionByte |= nodeOption;}
	bool testOption(unsigned char nodeOption){return optionByte & /* bitand */ nodeOption;}
	bool testOptionComplete(unsigned char nodeOption){return (optionByte & nodeOption) == nodeOption;}
	void unsetOption(unsigned char nodeOption){optionByte = (optionByte  & nodeOption) ^ optionByte;}
	void updateOptionByte();
	unsigned char getOptionByte(){return optionByte;}
	void setOptionByte(unsigned char p_optionByte){optionByte = p_optionByte;}

	string optionByte_toString();

public:

	// link auf den Container
	KEY_TYPE key;

	// Position des Suffix in der Suffixdatei
	SUFFIXSTART_TYPE suffixStart;

	// L�nge des Suffix'
	LENGTH_TYPE suffixLength;
	// L�nge des Infix'
	LENGTH_TYPE infixLength;

	// Links auf die Kindknoten
	POS_TYPE childNodesPos[MAXCHARS];
	unsigned int freqVector[4];
	unsigned int minLength;
	unsigned int maxLength;

	// Speicherplatz f�r den Teil des Suffix, der im Knoten gespeichert wird und nicht im Suffix-File
	// VisualC++ kann das nicht, daher als normaler Pointer
	//char internalSavedSuffix[INTERNALSAVEDSUFFIXSIZE+1];
	char * internalSavedSuffix;

private:
	// das ist der Suffix als String-Objekt
	/**
	 * String-Objekt zur leichteren Handhabung.
	 * Hat zwei Funktionen:
	 * 1. Speichert den kompletten Suffix (wenn geladen)
	 * 2. Speichert den Infix, so vorhanden
	 * --> da beide XOR sind, geht das
	 */
	string suffix;
public:
	// Position des Knotens in der Knotendatei
	POS_TYPE posID;

	// hier noch die darunterliegende Speicherklasse referenzieren
	PSpeicher * mPSpeicher;

	// PSpeicher generiert exclusiv die Knoten, darf daher auch exclusiv zugreifen
	friend class PSpeicher;

private:
	/**
	 * C'tors alle privat, damit mu� das Interface von PSpeicher genutzt werden
	 */
	CharNode(PSpeicher * p_PSpeicher);
	CharNode(PSpeicher * p_PSpeicher, POS_TYPE p_posID);
	CharNode(KEY_TYPE p_key);
	CharNode();

	// in Index.cpp --> Testroutine wg. Erstellung von Knoten (Timer)
	//friend int testTimeToCreate(int anzahl);

public:

	/**
	 * entsorgt im Wesentlichen den Speicher f�r das interne Suffix
	 */
	~CharNode();

private:
	// f�r die Infix-Verarbeitung
	// Infix sieht immer so aus: INFIX-{char}-INFIX-{char}-....
	// INFIX == [(number * MAXINFLEN + 1),MAXINFLEN]
	// {char}== [(MAXINFLEN*number)+(number)] // [(INFIXLEN+1)*number - 1]
	// gibt den n-ten Teil eines Infix' zur�ck
	// beginnt mit 1
	static string getInfixPart(const string& p_string, int number);
	// gibt den n-ten Infix-Trenner zur�ck (also den Teil, der durch die PosID abgebildet wird
	// beginnt mit 1
	static char getInfixSeparator(const string& p_string, int number);

public:
	// entpackt anz zeichen aus dem Suffix, wobei mit 0 angefangen wird,
	// bei anz=2 werden also 3 neue Knoten erstellt: [0],[1] (die beiden ausgepackten Zeichen und [2] f�r den neuen Suffix
	// gibt den Zeiger auf das letzte ausgepackte Zeichen zur�ck
	CharNode* unPackSuffixAndFollow(int anz);

	// entpackt Zeichen aus dem Suffix f�r anz=2 werden nur die ersten beiden Zeichen ausgepackt, der Suffix landet dann an [1]
	CharNode* unPackSuffixAndFollowBevorConcat(int anz);

	// Zugriffsfunktionen auf die Kinder
	bool hasChildren();
	bool hasChild(int c){return childNodesPos[c] != PTREE_NULLPOS;}
	CharNode * getChild(POS_TYPE pos);
	void addChild(int pos, POS_TYPE p_posID){childNodesPos[pos] = p_posID;}
	void deleteChild(POS_TYPE pos){childNodesPos[pos] = PTREE_NULLPOS;}

	// inline-Wrapper, addChild() und setChildPos() sind gleich
	POS_TYPE getChildPos(int pos){return childNodesPos[pos];}
	void setChildPos(int pos, POS_TYPE p_posID){childNodesPos[pos] = p_posID;}

	// suffix-funktionen
	bool hasSuffix(){return suffixLength != 0;}
	const string& getSuffix(); // dann halt nicht inline...
	string getIntSuffix(){return internalSavedSuffix?string(internalSavedSuffix,(suffixLength>nsIntSuffixStringLength)?nsIntSuffixStringLength:suffixLength):string("");}
	void deleteSuffix(){
		for(unsigned int i = 0; i < suffix.length();++i){
			freqVector[hashChar(suffix[i])]--;
		}
		suffix.clear();
		suffixLength=0;
		if(internalSavedSuffix)internalSavedSuffix[0]=0;
	}
	void setSuffix(const string& p_string);

	// da der Infix per Default im Knoten gespeichert wird mu� hier auch kein dynamisches Laden rein
	bool hasInfix(){return infixLength != 0;}
	void setInfix(const string& p_string){suffix = p_string;infixLength = p_string.length();}
	string getInfix(){return suffix;}
	string& getInfixRef(){return suffix;}
	void deleteInfix(){
		for(unsigned int i =0; i<infixLength;++i){
			freqVector[hashChar(suffix[i])]--;
		}
		suffix.clear();
		/* = "";*/
		infixLength = 0;
	}

	// vergleicht den Suffix mit einem anderen string
	int suffixCompareTo(const string& compTo);
	// vergleicht den Suffix mit dem Suffix eines anderen Knotens
	// --> nutzt dabei die interne Speicherung der Suffixe aus!
	int suffixCompareTo(CharNode * compTo);
	// mit startPosition --> wird f�r den Join gebraucht
	int suffixCompareTo_withStartPos(CharNode * compTo, int startPos);

	// Key-Handling
	bool hasKey(){return key != PTREE_NULLKEY; }
	KEY_TYPE  getKey(){return key;}
	void setKey(KEY_TYPE p_key){key = p_key;}
	void deleteKey(){key = PTREE_NULLKEY;}


	int countChildren();
	bool isLeave(){return hasChildren() == false;}
	bool isBranch(){return countChildren() > 1;}

	// Funktionen direkt auf dem aktuellen Knoten
	// gibt u.U. MIN oder MAX zur�ck, je nachdem wo man mit der Suche anf�ngt
	CharNode * getLexLastChild();
	CharNode * getLexFirstChild();
	CharNode * getLexPreviousChild(POS_TYPE pos);
	CharNode * getLexNextChild(POS_TYPE pos);

	// gleich Funktionen wie oben, hier jedoch mit Positionsangaben
	POS_TYPE getLexLastChildPos();
	POS_TYPE getLexFirstChildPos();
	POS_TYPE getLexPreviousChildPos(POS_TYPE pos);
	POS_TYPE getLexNextChildPos(POS_TYPE pos);

	// holt einen Schl�ssel aus dem Baum, ggf. auch mit rekursivem Abstieg
	// firstmin == das lex. kleinste == das erste ganz Links
	KEY_TYPE getLexFirstMinChild();
	KEY_TYPE getLexMinChild();
	KEY_TYPE getLexFirstMaxChild();
	// max == das lex. gr��te == das letzte ganz rechts
	KEY_TYPE getLexMaxChild();


	/**
	 * Zugriff zum Speicherinterface (PSpeicher)
	 * entweder nur Knoten schreiben oder auch mit Suffix
	 * IOOrder-Funktionen sind f�r das Schreiben variabler Knoten speziell ausgestattet
	 */
	void writeNode();
	void writeNodeAndSuffix();
	void writeNode_IOOrder();
	void writeNodeAndSuffix_IOOrder();


	/* numeriert die Keys des Baumes neu */
	void alterKeys(KEY_TYPE& keyToUse, KEY_TYPE interval, AlterKeysMap& map_alterkeys);

	/* ordnet einen Baum neu an --> einen Baum in den anderen */
	static void IOOrder(CharNode * sourceNode, CharNode * destinationNode);


	// debug-Funktion
	// checkt, ob die Knoten korrekt durchnumeriert sind
	KEY_TYPE checkNodeNumbering(KEY_TYPE lastKey, POS_TYPE lastKeyNodePos);

	// Baumorientierte Ausgabe (rekursiv �ber die Knoten)
	// Schneidet die Suffixe auf eine L�nge von 20 Zeichen wg. �bersichtlichkeit
	int print();

	// einfach Ausgabe eines Knotens
	friend ostream& operator<<(ostream& stream, CharNode& n);


	// Statistik-Funktionen
	int getNumberOfNodes();
	int getNumberOfKeys();
	int getNumberOfSuffixes();
	int getSuffixesLength();    // Summe aller Suffix-L�ngen

	void printStatistics(ostream& stream);
	static ostream& printRuntimeStats(ostream& stream);

	void printInfixStatistics();
	void printInfixStatistics_rec(); // rekursiver Teil

	// nur f�r die print()-Ausgabe
	static int indent;

	// schauen, ob memory-leaks auftreten
	static int internalNodeCount;
	static int internalNodeCountCreate;
	static int internalNodeCountDelete;
	static int internalNodeCountCreateOnDisk;

	// kann die Knoten ausgeben, die am Ende wider erwarten doch �brig sind
	//static set<pair<int, string> > internalActiveNodes;
	//static set<int> activeNodes;
	//set<pair<int, string> >& getInternalActiveNodes(){return internalActiveNodes;};

	// Laufzeitstatistik �ber die Wirksamkeit der Internen Suffixe
	static unsigned int internalSuffixIntCompCount;  // interne Vergleiche (also alle)
	static unsigned int internalSuffixExtCompCount;  // Vergleich mit externem Suffix (also nur die mit getSuffix()

	// Baum-Statistik
	static int aktBaumTiefe;
	static int maxBaumTiefe;

	// infix-Statistik (veraltet)
	static int infixCount;
	static vector<int> histogramm; // --> L�ngste Infix-Ketten finden
	void setFreqVect(unsigned int vector[]);
	void addOneToFreqVectPos(int pos);
	void substrOneFromFreqVectPos(int pos);
	void setMinMax(unsigned int min, unsigned int max);

private:
	/**
	 * interne Variablen f�r die Statistik-Funktion
	 */
	static int cNodes;
	static int cChildren;
	static int cKeys;
	static int cSuffixes;
	static int cInfixes;
	static int cWithoutSuffix;
	static int cSuffLen;
	static int cSuffLenExtern; // nur die auf die Platte geschriebenen Suffix-Anteile
	static int cSuffLenIntern; // nur die intern gespeicherten Anteile
	static int cSuffLenInternOnly; // nur die komplett intern gespeicherten Suffixe
	static int cSuffInternOnly; // suffixStart == -2
	static int cSuffToBeSavedInternally;
	static int cSuffExtern; // suffixStart >=0
	static int cInfixLen;
	static int cInternalNodeWithoutKey;
	// wie viele Abzweigungen?
	static int cBranch_Leave;
	static int cBranch_One;
	static int cBranch_Two;
	static int cBranch_Three;
	static int cBranch_Four;
	void getAllStatisticValuesRec();

};

#ifdef _WIN32
	#pragma warning(default:4800)	// int als bool verwenden
#endif

#endif

