
#include "CharNode.hpp"

//statische Variablen
int CharNode::indent = 0;

int CharNode::internalNodeCount = 0;
int CharNode::internalNodeCountCreate = 0;
int CharNode::internalNodeCountDelete = 0;
int CharNode::internalNodeCountCreateOnDisk = 0;

unsigned int CharNode::internalSuffixIntCompCount = 0;
unsigned int CharNode::internalSuffixExtCompCount = 0;

//set<pair<int, string> > CharNode::internalActiveNodes;
//set<int> CharNode::activeNodes;



int CharNode::cNodes = 0;
int CharNode::cChildren = 0;
int CharNode::cKeys = 0;
int CharNode::cSuffixes = 0;
int CharNode::cInfixes = 0;
int CharNode::cWithoutSuffix = 0;  // Leave ohne Suffix
int CharNode::cSuffInternOnly = 0; // suffixStart == -2
int CharNode::cSuffExtern = 0; // suffixStart >=0
int CharNode::cSuffLen = 0;
int CharNode::cSuffLenExtern = 0; // nur die auf die Platte geschriebenen Suffix-Anteile
int CharNode::cSuffLenIntern = 0; // nur die intern gespeicherten Anteile
int CharNode::cSuffLenInternOnly = 0; // nur die komplett intern gespeicherten Suffixe
int CharNode::cSuffToBeSavedInternally = 0; // L�nge INTERNALSAVEDSUFFIXSIZE + 16 (4*sizeof(STARTPOS_TYPE))
int CharNode::cInfixLen = 0;
int CharNode::cInternalNodeWithoutKey = 0;
// wie viele Abzweigungen?
int CharNode::cBranch_Leave = 0;
int CharNode::cBranch_One = 0;
int CharNode::cBranch_Two = 0;
int CharNode::cBranch_Three = 0;
int CharNode::cBranch_Four = 0;

int CharNode::aktBaumTiefe = 0;
int CharNode::maxBaumTiefe = 0;


int CharNode::infixCount = 0;
vector<int> CharNode::histogramm(3001);

/**
 * Erstellt ein neues Knoten-Objekt.
 * Aus der �bergebenen posID wird der Knoten von der Platte gelesen.
 */

CharNode::CharNode(PSpeicher * p_PSpeicher, POS_TYPE p_posID){
	++internalNodeCount;
	++internalNodeCountCreate;

	mPSpeicher = p_PSpeicher;
	posID = p_posID;

	suffix = "";
	suffixStart = -1;
	suffixLength = 0;
	infixLength = 0;
	internalSavedSuffix = NULL;

	for(int i=0;i<MAXCHARS;++i){
		setChildPos(i, PTREE_NULLPOS);
		freqVector[i]=0;
	}
	minLength =UINT_MAX;
	maxLength =0;

	mPSpeicher->readNode(this);
	//cerr << " ... finished" << endl;

}

/**
 * Erstellt einen leeren Knoten, der auch auf Platte geschrieben werden kann.
 * Die posID wird mit der Gr��e der Baumdatei initialisiert (also ganz ans Ende geschrieben).
 */
CharNode::CharNode(PSpeicher * p_PSpeicher){
		++internalNodeCount;
		++internalNodeCountCreate;
		++internalNodeCountCreateOnDisk;

		setOptionByte((unsigned char)NODE_OPTION_ISFIXED);
		mPSpeicher = p_PSpeicher;
		key = PTREE_NULLKEY;
		suffixStart = -1;
		suffixLength = 0;
		infixLength = 0;
		suffix = "";
		internalSavedSuffix = NULL;

		posID = mPSpeicher->getBaumSize();
		// wird mit der Dateigr��e initialisiert, also ganz ans Ende geschrieben

		// hier noch die childNodes mit Nullen initialisieren
		// bis der Befehl steht, erstmal mit Schleife
		for(int i=0;i<MAXCHARS;++i){
			setChildPos(i, PTREE_NULLPOS);
			freqVector[i]=0;
		}
		minLength =UINT_MAX;
		maxLength =0;
	}

/**
 *  C'tor f�r MIN und MAX-Nodes<br/>
 *  Haben keine posID
 */
CharNode::CharNode(KEY_TYPE p_key){
	++internalNodeCount;
	++internalNodeCountCreate;

	key = p_key;
	suffixStart = -1;
	suffixLength = 0;
	infixLength = 0;
	suffix = "";
	internalSavedSuffix = NULL;
	posID = PTREE_NULLPOS;
	for(int i=0;i<MAXCHARS;++i){
		setChildPos(i, PTREE_NULLPOS);
		freqVector[i]=0;
	}
	minLength =UINT_MAX;
	maxLength =0;
}

/**
 * Nur f�r PSpeicher gedacht
 */
CharNode::CharNode(){
	++internalNodeCount;
	++internalNodeCountCreate;

	setOptionByte((unsigned char)NODE_OPTION_ISFIXED);
	posID = PTREE_NULLPOS;
	key = PTREE_NULLKEY;
	suffixStart = -1;
	suffixLength = 0;
	infixLength = 0;
	suffix = "";
	internalSavedSuffix = NULL;
	for(int i=0;i<MAXCHARS;++i){
		setChildPos(i, PTREE_NULLPOS);
		freqVector[i]=0;
	}
	minLength =UINT_MAX;
	maxLength =0;
}


/*
 * Destructor. Mit DEBUG-Code.
 */
CharNode::~CharNode(){

	if(internalSavedSuffix != NULL){
		delete internalSavedSuffix;
	}
	--internalNodeCount;
	++internalNodeCountDelete;
}

/**
 * Schreibt das OptionByte neu; gedacht f�r kurz vor IOOrder!
 * die Eigenschaft Variable/Fixed bleibt unber�hrt!
 *
 */
void CharNode::updateOptionByte(){
	if(hasKey()){setOption(NODE_OPTION_HASKEY);}else{unsetOption(NODE_OPTION_HASKEY);}
	if(hasSuffix()){
		setOption(NODE_OPTION_HASSUFFIX);
		unsetOption(NODE_OPTION_HASINFIX+NODE_OPTION_HASCHAR_A+NODE_OPTION_HASCHAR_C+NODE_OPTION_HASCHAR_G+NODE_OPTION_HASCHAR_T);
		if(suffixStart != -2){  // -2 == internOnly
			setOption(NODE_OPTION_SUFFIX_HASSUFFIXSTART);
		}
	}else{
		unsetOption(NODE_OPTION_HASSUFFIX);
		if(hasInfix()){setOption(NODE_OPTION_HASINFIX);}else{unsetOption(NODE_OPTION_HASINFIX);}
		if(hasChild(0)){setOption(NODE_OPTION_HASCHAR_A);}else{unsetOption(NODE_OPTION_HASCHAR_A);}
		if(hasChild(1)){setOption(NODE_OPTION_HASCHAR_C);}else{unsetOption(NODE_OPTION_HASCHAR_C);}
		if(hasChild(2)){setOption(NODE_OPTION_HASCHAR_G);}else{unsetOption(NODE_OPTION_HASCHAR_G);}
		if(hasChild(3)){setOption(NODE_OPTION_HASCHAR_T);}else{unsetOption(NODE_OPTION_HASCHAR_T);}
	}
}

/**
 * Gibt die gefundenen Optionen als String formatiert zur�ck
 */
string CharNode::optionByte_toString(){
	string ret("[");
	if(/*testOptionComplete(NODE_OPTION_INDIRECTION)*/optionByte == NODE_OPTION_INDIRECTION){return "[ IND ]";}
	if(testOption(NODE_OPTION_ISFIXED)){ret += "FIXED ";}else{ret+="VAR ";};
	if(testOption(NODE_OPTION_HASKEY))ret += "KEY ";
	if(testOption(NODE_OPTION_HASSUFFIX)){ret += "SUFFIX ";
		if(testOption(NODE_OPTION_SUFFIX_HASSUFFIXSTART))ret += "+START ";}
	else{
		if(testOption(NODE_OPTION_HASINFIX))ret += "INFIX ";
		if(testOption(NODE_OPTION_HASCHAR_A))ret += "A ";
		if(testOption(NODE_OPTION_HASCHAR_C))ret += "C ";
		if(testOption(NODE_OPTION_HASCHAR_G))ret += "G ";
		if(testOption(NODE_OPTION_HASCHAR_T))ret += "T ";
	}
	return ret += "]";
}

/**
 * Gibt das entsprechende "Kind" zur�ck
 * (pos == 0 f�r Infix-Anfragen --> das kann sp�ter noch hinzukommen, derzeit kein Nutzen)
 */
CharNode * CharNode::getChild(POS_TYPE pos){
	return mPSpeicher->newCharNodeByPos(childNodesPos[pos]);
}

/**
 * Augabe des Knotens auf einem ostream
 */
ostream& operator<<(ostream& stream, CharNode& n){
		stream << "CharNode:\n\tposID = " << n.posID
		<< "\n\tkey = " << n.key
		<< "\n\tsuffixStart = " << n.suffixStart
		<< "\n\tsuffixLength = " << n.suffixLength
		<< "\n\tsuffix = " << n.getSuffix()
		<< "\n\tinfixLength = " << n.infixLength
		<< "\n\thasInfix = " << n.hasInfix()
		<< "\ntminLength = "<<n.minLength
		<< "\ntmaxLength = "<<n.maxLength
		<< "\n\tfreqVector= ["<<n.freqVector[0]<<", "<<n.freqVector[1]<<", "<<n.freqVector[2]<<", "<<n.freqVector[3]<<"]";
		for (int i=0;i<MAXCHARS;++i){
			//if (n.childNodesPos[i] != PTREE_NULLPOS){
				stream << "\n\tchildNodesPos[" << unhashChar(i) << "] = " << n.getChildPos(i)/*childNodesPos[i]*/;
			//}
		}
		return stream << endl;
}


/**
 * Der Suffix wird erst beim Zugriff geladen
 */
const string& CharNode::getSuffix(){
	//if(special_debug)cerr << "getSuffix() start" << endl;
	if(suffixStart == -2 && suffixLength > 0 && suffix.length()==0){
		// Suffix ist rein intern gespeichert
		suffix = getIntSuffix(); // der interne Suffix ist in jedem Fall immer vor dem externen Suffix vorhanden
		// setSuffix w�re hier zu viel des Guten
	}else
	if(suffixStart >= 0 && suffixLength > 0 && suffix.length()==0) mPSpeicher->readSuffix(this);
	//if(special_debug)cerr << "getSuffix() end" << endl;
	return suffix;
}

/**
 * Setzt das Suffix; auch den intern gespeicherten Teil
 *
 */
void CharNode::setSuffix(const string& p_string){
		suffix = p_string;
		suffixLength = p_string.size();

		if(internalSavedSuffix == NULL){
			internalSavedSuffix = new char[nsIntSuffixStringLength+1];
		}
		for(int i=0;i < nsIntSuffixStringLength && i<suffixLength;++i){
			internalSavedSuffix[i] = suffix[i];
		}
		if(suffixLength > nsIntSuffixStringLength){
			internalSavedSuffix[nsIntSuffixStringLength] = 0;
		}else{
			internalSavedSuffix[suffixLength] = 0;
		}
	}

/**
 * Gibt die Laufzeitstatistik aus.
 */
ostream& CharNode::printRuntimeStats(ostream& stream){
	stream << "CharNode::printRuntimeStats()" << endl;
	stream << "internalNodeCount == " << internalNodeCount << endl;
	stream << "internalNodeCountCreate == " << internalNodeCountCreate << endl;
	stream << "internalNodeCountCreateOnDisk == " << internalNodeCountCreateOnDisk << endl;
	stream << "internalNodeCountDelete == " << internalNodeCountDelete << endl;
	stream << "internalSuffixIntCompCount == " << internalSuffixIntCompCount << endl;
	stream << "internalSuffixExtCompCount == " << internalSuffixExtCompCount << endl;
	return stream;
}

/**
 * Gibt den n-ten Infix-Teil eines Strings zur�ck; damit l��t sich ein String bequem auf
 * mehrere Infixe aufteilen. Ein Zeichen bleibt immer als Zwischenst�ck �brig, mit dem
 * die Knoten aneinandergereiht werden.
 */
string CharNode::getInfixPart(const string& p_string, int number){
	//return p_string.substr((INTERNALSAVEDINFIXSIZE+1)*(number - 1), INTERNALSAVEDINFIXSIZE);
	return p_string.substr((nsInfixStringLength+1)*(number - 1), nsInfixStringLength);
}

/**
 * Gibt den n-ten Infix-Zwischenteil zur�ck
 * Beginnt mit 1
 */
char CharNode::getInfixSeparator(const string& p_string, int number){
	if(p_string.length() >= (unsigned int)((nsInfixStringLength+1)*number - 1)){
		return p_string[(nsInfixStringLength+1)*number - 1];
	}else{
		return 0;
	}
}

/**
 * Packt n+1 Zeichen aus dem Suffix aus.
 * F�r anz==0 wird das erste Zeichen ausgepackt.
 * Wenn m�glich, wird der Zeiger auf den als vorletztes erstellten Knoten zur�ckgegeben.
 */
CharNode* CharNode::unPackSuffixAndFollow(int anz){
	//if(special_debug)cerr << "unPackSuffixAndFollow(anz == " << anz << ")" << endl;
	//cerr << "*this:" << endl << *this << endl;

	CharNode * zeiger = this;
	CharNode * r_zeiger = this;

	CharNode * neuesKind;
	CharNode * neuesKind_Node1;
	CharNode * neuesKind_Node2;

	string suf = getSuffix(); // lokale Kopie des Strings
	int sufStart = zeiger->suffixStart;
	int sufLength = zeiger->suffixLength;
	KEY_TYPE m_key = zeiger->getKey();

	//zeiger->setSuffix("");
	zeiger->deleteSuffix();
	zeiger->deleteKey();
	zeiger->suffixLength = 0;
	zeiger->suffixStart = -1;

	// infix kann anz-1 zeichen lang sein
	// start Infixbehandlung
	if(anz-1 > 0){
		if(special_debug)cerr << "INFIX START" << endl;
		int newInfixLength = anz-1;

		// gesamter Neuer Infix
		const string& newInfix = suf.substr(0,newInfixLength);
		const string& rest = suf.substr(newInfixLength);

		//if(special_debug){
		//	cerr << "neue Infix-L�nge == " << newInfixLength << endl;
		//	cerr << "newInfix         == " << newInfix << endl;
		//	cerr << "rest             == " << rest << endl;
		//}

		// so viele Infix-Knoten bauen wie n�tig
		int iInfixNumber = 1;
		//if(special_debug)cerr << "InfixSeparator == " << getInfixSeparator(newInfix, iInfixNumber) << endl;
		while(getInfixSeparator(newInfix, iInfixNumber) != 0){
			//if(special_debug){
			//	cerr << "InfixSeparator == " << getInfixSeparator(newInfix, iInfixNumber) << endl;
			//	cerr << "InfixPart      == " << getInfixPart(newInfix, iInfixNumber) << endl;
			//}
			const string s(getInfixPart(newInfix, iInfixNumber));
			zeiger->setInfix(s);
			for (int i =0; i < s.length();++i){
				zeiger->addOneToFreqVectPos(hashChar(s[i]));
			}
			CharNode * newChild = mPSpeicher->newCharNodeAppend();
			newChild->setFreqVect(zeiger->freqVector);
			newChild->addOneToFreqVectPos(hashChar(getInfixSeparator(newInfix, iInfixNumber)));
			newChild->writeNode();
			zeiger->addChild(hashChar(getInfixSeparator(newInfix, iInfixNumber)),newChild->posID);
			zeiger->writeNode();
			//if(special_debug) cerr << *zeiger << endl;
			checkPosCompDelete(zeiger, this);
			zeiger = newChild;
			++iInfixNumber;
		}
		const string& restinfix = getInfixPart(newInfix, iInfixNumber);
		//if(special_debug)cerr << "RestInfix == " << restinfix << endl;
		if(restinfix.length() > 0){
			zeiger->setInfix(restinfix);
			for(unsigned int i =0; i< restinfix.length();++i){
				zeiger->addOneToFreqVectPos(hashChar(restinfix[i]));
			}
		}
		zeiger->writeNode();

		// R�ckgabe-Knoten
		neuesKind_Node1 = mPSpeicher->newCharNodeAppend();
		neuesKind_Node1->setFreqVect(zeiger->freqVector);
		neuesKind_Node1->addOneToFreqVectPos(hashChar(rest[0]));
		neuesKind_Node1->writeNode();
		zeiger->addChild(hashChar(rest[0]), neuesKind_Node1->posID);
		zeiger->writeNode();

		//if(special_debug) cerr << *zeiger << endl;

		neuesKind_Node2 = mPSpeicher->newCharNodeAppend();
		neuesKind_Node2->setFreqVect(neuesKind_Node1->freqVector);
		neuesKind_Node2->addOneToFreqVectPos(hashChar(rest[1]));
		neuesKind_Node1->addChild(hashChar(rest[1]), neuesKind_Node2->posID);
		neuesKind_Node1->writeNode();

		neuesKind_Node2->setKey(m_key);
		const string& neuerSuffix = rest.substr(2); // die ersten beiden sind ja schon weg
		if(neuerSuffix.length() > 0){
			neuesKind_Node2->setSuffix(neuerSuffix);
			// hier dann noch ausrechnen, wo der Suffix in der Datei steht
			//neuesKind_Node2->suffixLength = neuesKind_Node2->getSuffix().length(); // das hier macht setSuffix schon
			if(neuerSuffix.length() > (unsigned int)nsIntSuffixStringLength){
				neuesKind_Node2->suffixStart = sufStart + sufLength - neuesKind_Node2->suffixLength;
			}else{
				neuesKind_Node2->suffixStart = -2;
			}
			for(unsigned int i =0; i < neuerSuffix.length();++i){
				neuesKind_Node2->addOneToFreqVectPos(hashChar(neuerSuffix[i]));
			}
		}
		neuesKind_Node2->writeNode();
		checkPosDelete(neuesKind_Node2);

		if(special_debug)cerr << "INFIX END" << endl;
		if(special_debug)cerr << "unPackSuffixAndFollow(anz == " << anz << ") finished" << endl;
		//cerr << *zeiger << endl;
		//cerr << *neuesKind_Node1 << endl;
		//cerr << *neuesKind_Node2 << endl;

		//if(special_debug){
		//	zeiger->print();
		//	cerr << endl;
		//}
		checkPosCompDelete(zeiger, this);
		return neuesKind_Node1;
	}// Ende Infixbehandlung

	int pos;
	for(int i=0; i<=anz; ++i){
		pos = hashChar(suf[i]);
		neuesKind = mPSpeicher->newCharNodeAppend();
		zeiger->addChild(pos, neuesKind->posID); // ge�ndert... Zeiger�bergabe auf posID
		neuesKind->setFreqVect(zeiger->freqVector);
		neuesKind->addOneToFreqVectPos(pos);

		// jetzt beide Knoten speichern...
		zeiger->writeNode();
		neuesKind->writeNode();

		// ist hier problematisch, da ich nicht wei� ob ich zeiger l�schen kann
		// wenn der zeiger nicht durch r_zeiger referenziert wird, durch wen sonst?
		checkPosCompDelete(zeiger, r_zeiger);

		zeiger = neuesKind; // hier weiter einf�gen

		// vorletzter Zeiger wird zur�ckgegeben
		if(i<anz){
			// aufr�umen; aber verhindern, da� der rootNode gel�scht wird
			// r_zeiger == zeiger kann eigentlich nicht auftreten, wenn, dann r_zeiger == this, und das wird abgefangen
			if(r_zeiger != NULL && r_zeiger != this && r_zeiger->posID != 0 && r_zeiger != zeiger){
				mPSpeicher->freeCharNode(r_zeiger);
			}
			r_zeiger = zeiger;
		}
	}
	zeiger->setKey(m_key);
	const string& neuerSuffix = suf.substr(anz+1);

	if(neuerSuffix.length() > 0){
		zeiger->setSuffix(neuerSuffix);
		// hier dann noch ausrechnen, wo der Suffix in der Datei steht
		//zeiger->suffixLength = zeiger->getSuffix().length();
		//zeiger->suffixLength = neuerSuffix.length(); // macht setSuffix
		if(neuerSuffix.length() > (unsigned int)nsIntSuffixStringLength){
			zeiger->suffixStart = sufStart + sufLength - zeiger->suffixLength;
		}else{
			zeiger->suffixStart = -2;
		}
		for (unsigned int i = 0; i<neuerSuffix.length();++i){
			zeiger->addOneToFreqVectPos(hashChar(neuerSuffix[i]));
		}
	}
	// zeiger jetzt speichern
	zeiger->writeNode();

	// mal den zeiger l�schen, falls der nicht gleich r_zeiger (und this)
	checkPosComp2Delete(zeiger, this, r_zeiger);

	if(special_debug)cerr << "unPackSuffixAndFollow(anz == " << anz << ") finished" << endl;
	return r_zeiger;
}


/**
 * Packt n Zeichen eines Suffix aus.
 * Erstellt die neuen Knoten und gibt einen Zeiger auf den erstellten letzten zur�ck.
 * Der urspr�ngliche Key und der Restsuffix werden wieder gesetzt.
 *
 */
CharNode* CharNode::unPackSuffixAndFollowBevorConcat(int anz){
	//if(special_debug)cerr << "unPackSuffixAndFollowBevorConcat(anz == " << anz << ")" << endl;
	//cerr << "this:" << endl << *this << endl;

	CharNode * zeiger = this;
	CharNode * neuesKind = NULL;

	string suf(zeiger->getSuffix()); // lokale Kopie des Strings
	int sufStart = zeiger->suffixStart;
	int sufLength = zeiger->suffixLength;
	KEY_TYPE m_key = zeiger->getKey();

	//zeiger->setSuffix("");
	zeiger->deleteSuffix();
	zeiger->deleteKey();
	zeiger->suffixLength = 0;
	zeiger->suffixStart = -1;

	if(anz-1 > 0){
		if(special_debug)cerr << "INFIX START" << endl;
		int newInfixLength = anz-1;

		// gesamter Neuer Infix
		const string& newInfix = suf.substr(0,newInfixLength);
		const string& rest = suf.substr(newInfixLength);

		//if(special_debug){
		//	cerr << "neue Infix-L�nge == " << newInfixLength << endl;
		//	cerr << "newInfix         == " << newInfix << endl;
		//	cerr << "rest             == " << rest << endl;
		//}

		// so viele Infix-Knoten bauen wie n�tig
		int iInfixNumber = 1;
		if(special_debug)cerr << "InfixSeparator == " << getInfixSeparator(newInfix, iInfixNumber) << endl;
		while(getInfixSeparator(newInfix, iInfixNumber) != 0){
			//if(special_debug)cerr << "InfixSeparator == " << getInfixSeparator(newInfix, iInfixNumber) << endl;
			//if(special_debug)cerr << "InfixPart      == " << getInfixPart(newInfix, iInfixNumber) << endl;
			string s(getInfixPart(newInfix, iInfixNumber));
			zeiger->setInfix(s);
			for(unsigned int i = 0; i<s.length();++i){
				zeiger->addOneToFreqVectPos(hashChar(s[i]));
			}
			CharNode * newChild = mPSpeicher->newCharNodeAppend();
			newChild->setFreqVect(zeiger->freqVector);
			newChild->addOneToFreqVectPos(hashChar(getInfixSeparator(newInfix, iInfixNumber)));
			newChild->writeNode();
			zeiger->addChild(hashChar(getInfixSeparator(newInfix, iInfixNumber)),newChild->posID);
			zeiger->writeNode();
			//if(special_debug)cerr << *zeiger << endl;
			checkPosCompDelete(zeiger, this);
			zeiger = newChild;
			++iInfixNumber;
		}
		const string& restinfix = getInfixPart(newInfix, iInfixNumber);
		//string restinfix = getInfixPart(newInfix, iInfixNumber);

		//if(special_debug)cerr << "RestInfix == " << restinfix << endl;

		if(restinfix.length() > 0){
			zeiger->setInfix(restinfix);
			for(unsigned int i = 0; i<restinfix.length();++i){
				zeiger->addOneToFreqVectPos(hashChar(restinfix[i]));
			}
		}
		zeiger->writeNode();

		neuesKind = mPSpeicher->newCharNodeAppend();
		neuesKind->setFreqVect(zeiger->freqVector);
		neuesKind->addOneToFreqVectPos(hashChar(rest[0]));
		zeiger->addChild(hashChar(rest[0]), neuesKind->posID);
		zeiger->writeNode();
		checkPosCompDelete(zeiger, this);

		neuesKind->setKey(m_key);
		const string& neuerSuffix = rest.substr(1);
		if(neuerSuffix.length() > 0){
			neuesKind->setSuffix(neuerSuffix);
			// hier dann noch ausrechnen, wo der Suffix in der Datei steht
			//neuesKind->suffixLength = neuesKind->getSuffix().length();
			if(neuerSuffix.length() > (unsigned int)nsIntSuffixStringLength){
				neuesKind->suffixStart = sufStart + sufLength - neuesKind->suffixLength;
			}else{
				neuesKind->suffixStart = -2;
			}
			for(unsigned int i = 0; i<neuerSuffix.length();++i){
				neuesKind->addOneToFreqVectPos(hashChar(neuerSuffix[i]));
			}
		}
		neuesKind->writeNode();

//		if(special_debug)cerr << "INFIX END" << endl;
//		if(special_debug)cerr << "unPackSuffixAndFollowBevorConcat(anz == " << anz << ") finished" << endl;

		return neuesKind;
	}// Ende Infixbehandlung


//	if(special_debug)cerr << "unPackSuffixAndFollowBevorConcat: kein Infix behandelt" << endl;
	int pos;
	for(int i=0; i<anz; ++i){
		pos = hashChar(suf[i]);
		neuesKind = mPSpeicher->newCharNodeAppend();
		neuesKind->setFreqVect(zeiger->freqVector);
		neuesKind->addOneToFreqVectPos(pos);
		zeiger->addChild(pos, neuesKind->posID);// ge�ndert von Zeiger�bergabe auf posID

		// jetzt beide Knoten speichern...
		zeiger->writeNode();
		neuesKind->writeNode();

		checkPosCompDelete(zeiger, this);
		zeiger = neuesKind; // hier weiter einf�gen
	}

//	if(special_debug)cerr << "unPackSuffixAndFollowBevorConcat: fertig mit traversieren bzw. Pfad generieren" << endl;
	zeiger->setKey(m_key);
	const string& neuerSuffix = suf.substr(anz);

	if(neuerSuffix.length() > 0){
		zeiger->setSuffix(neuerSuffix);
		// hier dann noch ausrechnen, wo der Suffix in der Datei steht
		//zeiger->suffixLength = zeiger->getSuffix().length();
		// verzweigung, da u.U. der Suffix komplett im Knoten steht
		if(neuerSuffix.length() > (unsigned int)nsIntSuffixStringLength){
			zeiger->suffixStart = sufStart + sufLength - zeiger->suffixLength;
		}else{
			zeiger->suffixStart = -2;
		}
		for(unsigned int i = 0; i<neuerSuffix.length();++i){
			zeiger->addOneToFreqVectPos(hashChar(neuerSuffix[i]));
		}
	}else{
		zeiger->deleteSuffix();
	}
	// zeiger jetzt speichern
	zeiger->writeNode();

//	if(special_debug)cerr << "unPackSuffixAndFollowBevorConcat(anz == " << anz << ") finished" << endl;
	return zeiger;
}

/**
 * Schreibt nur den Knoten auf die Platte.
 */
void CharNode::writeNode(){
	updateOptionByte(); // NEU VAR
	mPSpeicher->writeBlockNode(this);
}

/**
 * Schreibt den Knoten und den Suffix auf Platte.
 *
 */
void CharNode::writeNodeAndSuffix(){
	updateOptionByte(); // NEU VAR
	if(suffixLength > 0){
		suffixStart = mPSpeicher->writeSuffix(this);
//		for(int i=0;i<suffix.length();++i){
//			freqVector[hashChar(suffix[i])]++;
//		}
	}
	mPSpeicher->writeBlockNode(this);
}

/**
 * IOOrder Spezialversion --> f�hrt kein Update auf das OptionByte aus
 *
 * Schreibt nur den Knoten auf die Platte.
 */
void CharNode::writeNode_IOOrder(){
	if(posID == 0 ){
		setOption(NODE_OPTION_ISFIXED);
		updateOptionByte();
//		cerr<<"here"<<endl;
	}else{
		unsetOption(NODE_OPTION_ISFIXED);
//		cerr<<"here1"<<endl;
	}
	mPSpeicher->writeBlockNode(this);
//	cerr<<"here2"<<endl;
}

/**
 * IOOrder Spezialversion --> f�hrt kein Update auf das OptionByte aus
 *
 * Schreibt den Knoten und den Suffix auf Platte.
 *
 */
void CharNode::writeNodeAndSuffix_IOOrder(){
	if(posID == 0 ){
		setOption(NODE_OPTION_ISFIXED);
		updateOptionByte();
	}else{
		unsetOption(NODE_OPTION_ISFIXED);
	}
	if(suffixLength > 0){
		suffixStart = mPSpeicher->writeSuffix(this);
	}
	mPSpeicher->writeBlockNode(this);
}


/**
 * True, wenn der Knoten weiter verzweigt
 */
bool CharNode::hasChildren(){
	for(int i=0;i<MAXCHARS;++i){
		if (hasChild(i)) return true;
	}
	return false;
}

// z�hlt die Kinder
int CharNode::countChildren(){
	int ret = 0;
	for(int i=0;i<MAXCHARS;++i){
		if(hasChild(i))++ret;
	}
	return ret;
}

/**
 * Baum ausgeben.
 */
int CharNode::print(){
	indent += 2;
	for(int i=0;i<MAXCHARS;++i){
		if(hasChild(i)){
			for(int j=0; j<indent;++j){
				cerr << " ";
			}
			CharNode * myNode = mPSpeicher->newCharNodeByPos(getChildPos(i));

			cerr << unhashChar(i);
			if(myNode->hasKey()){
				cerr << "*(" << myNode->getKey() << ")";
			}
			if(myNode->hasSuffix()){
				cerr << " suffix(" << (myNode->getSuffix().substr(0,20)) << ")(s==" << myNode->suffixLength << ")" << endl;
			}else
			if(myNode->hasInfix()){
				cerr << " infix[" << (myNode->getInfix()) << "](s==" << myNode->infixLength << ")" << endl;
			}else{
				cerr << endl;
			}

			myNode->print();

			// delete geht hier, da die Knoten nicht verbunden sind
			mPSpeicher->freeCharNode(myNode);
		}
	}
	indent -= 2;
	return 0;
}


/**
 * Durchsucht die unmittelbaren Kinder des Knotens<br/>
 *
 * @return den lexikographisch kleinsten existenten KindKnoten
 * @throws Exception
 */
CharNode * CharNode::getLexFirstChild() {
	// wenn es die root ist? Dann MIN AUSGEBEN
	if (posID == 0){
		return mPSpeicher->newCharNodeByKey(PTREE_MIN);
	}
	for (int i = 0; i < MAXCHARS; ++i){
		if (hasChild(i)){
			return mPSpeicher->newCharNodeByPos(getChildPos(i));
		}
	}
	return NULL;
}

/**
 * Durchsucht die unmittelbaren Kinder des Knotens<br/>
 *
 * @return den lexikographisch kleinsten existenten KindKnoten (Position)
 * @throws Exception
 */
POS_TYPE CharNode::getLexFirstChildPos() {
	// wenn es die root ist? Dann MIN AUSGEBEN
	if (posID == 0){
		return PTREE_POSTYPE_MIN;
	}
	for (int i = 0; i < MAXCHARS; ++i){
		if (hasChild(i)){
			return getChildPos(i);
		}
	}
	return PTREE_NULLPOS;
}

/**
 * Gibt den lex. gr��ten Kindknoten zur�ck<br/>
 * return: (CharNode*) Knoten
 */
CharNode * CharNode::getLexLastChild(){
	// ist das der Rootknoten?
	if(posID == 0){
		return mPSpeicher->newCharNodeByKey(PTREE_MAX);
	}
	for(int i= MAXCHARS-1;i>=0;--i){
		// mit Dateiposition
		if(hasChild(i)){
			return mPSpeicher->newCharNodeByPos(getChildPos(i));
		}
	}
	return NULL;
}

/**
 * Gibt den lex. gr��ten Kindknoten zur�ck
 * return: POS_TYPE Knoten
 */
POS_TYPE CharNode::getLexLastChildPos(){
	// ist das der Rootknoten?
	if(posID == 0){
		return PTREE_POSTYPE_MAX;
	}
	for(int i= MAXCHARS-1;i>=0;--i){
		// mit Dateiposition
		if(hasChild(i)){
			return getChildPos(i);
		}
	}
	return PTREE_NULLPOS;
}

/*
 * lexikographisch gr��ter Knoten, der kleiner ist als p_pos
 */
CharNode * CharNode::getLexPreviousChild(int p_pos){
		// wenn es die root ist? Dann MIN AUSGEBEN
		if (posID == 0 && p_pos == 0){
			return mPSpeicher->newCharNodeByKey(PTREE_MIN);
		}

		for (int i = p_pos - 1; i >= 0; --i){
			if (hasChild(i)){
				return mPSpeicher->newCharNodeByPos(getChildPos(i));
			}
		}
		return NULL;
}


/*
	pos_ID des lexikographisch gr��ten Knoten, der kleiner ist als p_pos
*/
POS_TYPE CharNode::getLexPreviousChildPos(int p_pos){
		if (posID == 0 && p_pos == 0){
			return PTREE_POSTYPE_MIN; // --> hier mu� dann ggf. newCharNodeByKey() verwendet werden
		}

		for (int i = p_pos - 1; i >= 0; --i){
			if (hasChild(i)){
				return getChildPos(i);
			}
		}
		return PTREE_NULLPOS;
}


/*
	lexikographisch kleinster Knoten, der gr��er ist als p_pos
*/
CharNode * CharNode::getLexNextChild(int p_pos){
		// wenn es die root ist? Dann MAX AUSGEBEN
		if (posID == 0 && p_pos == MAXCHARS-1){
			return mPSpeicher->newCharNodeByKey(PTREE_MAX);
		}

		for (int i = p_pos + 1; i < MAXCHARS; ++i){
			if (hasChild(i)){
				return mPSpeicher->newCharNodeByPos(getChildPos(i));
			}
		}
		return NULL;
}

/*
	pos_ID des lexikographisch gr��ten Knoten, der kleiner ist als p_pos
*/
POS_TYPE CharNode::getLexNextChildPos(int p_pos){
		if (posID == 0 && p_pos == MAXCHARS-1){
			return PTREE_POSTYPE_MAX; // --> hier mu� dann ggf. newCharNodeByKey() verwendet werden
		}

		for (int i = p_pos + 1; i < MAXCHARS; ++i){
			if (hasChild(i)){
				return getChildPos(i);
			}
		}
		return PTREE_NULLPOS;
}




/**
 * lexikographisch kleinsten Knoten der einen String repr�sentiert
 */
KEY_TYPE CharNode::getLexFirstMinChild(){
	CharNode * zeiger = this;
	CharNode * tmp;
	while(!zeiger->hasKey()){
		tmp = zeiger->getLexFirstChild();
		checkPosCompDelete(zeiger, this);
		zeiger = tmp;
	}
	KEY_TYPE ret = zeiger->getKey();
	checkPosCompDelete(zeiger, this);
	return ret;
}

/**
 * Sucht den am weitesten links stehenden Knoten des Baumes
 *
 */
KEY_TYPE CharNode::getLexMinChild(){
	CharNode * zeiger = this;
	CharNode * tmp;
	KEY_TYPE ret;
	while(zeiger->hasChildren()){
		tmp = zeiger->getLexFirstChild();
		checkPosCompDelete(zeiger, this);
		zeiger = tmp;
	}
	ret = zeiger->getKey();
	checkPosCompDelete(zeiger, this);
	return ret;
}


/**
 * Sucht den am weitesten rechts stehenden Key (ist der lex. Gr��te)
 *
 */
KEY_TYPE CharNode::getLexMaxChild(){
	CharNode * zeiger = this;
	CharNode * tmp;
	KEY_TYPE ret;
	while(zeiger->hasChildren()){
		tmp = zeiger->getLexLastChild();
		checkPosCompDelete(zeiger, this);
		zeiger = tmp;
	}
	ret = zeiger->getKey();
	checkPosCompDelete(zeiger, this);
	return ret;
}

/**
 * Holt den Key, der als erstes an der rechten Seite des Baumes vorkommt
 *
 */
KEY_TYPE CharNode::getLexFirstMaxChild(){
	CharNode * zeiger = this;
	CharNode * tmp;
	while(!zeiger->hasKey()){
		tmp = zeiger->getLexLastChild();
		checkPosCompDelete(zeiger, this);
		zeiger = tmp;
	}
	KEY_TYPE ret = zeiger->getKey();
	checkPosCompDelete(zeiger, this);
	return ret;
}

/**
 * Z�hlt die Knoten im Teilbaum. (inclusive rootKnoten)
 */
int CharNode::getNumberOfNodes(){
	int num = 1;
	for(int i=0; i<MAXCHARS; ++i){
		if(hasChild(i)){
			CharNode * tempNode = mPSpeicher->newCharNodeByPos(getChildPos(i));
			num += tempNode->getNumberOfNodes();
			mPSpeicher->freeCharNode(tempNode);
		}
	}
	return num;
}

/**
 * Gibt die Anzahl der Keys im akt. Teilbaum zur�ck.
 */
int CharNode::getNumberOfKeys(){
	int num = 0;
	if(hasKey()){
		num = 1;
	}
	for(int i=0; i<MAXCHARS; ++i){
		if(hasChild(i)){
			CharNode * tempNode = mPSpeicher->newCharNodeByPos(getChildPos(i));
			num += tempNode->getNumberOfKeys();
			mPSpeicher->freeCharNode(tempNode);
		}
	}
	return num;
}

/**
 * Gibt die Anzahl aller Suffixe im akt. Teilbaum zur�ck.
 */
int CharNode::getNumberOfSuffixes(){
	int num = 0;
	if(hasSuffix()){
		num = 1;
	}
	for(int i=0; i<MAXCHARS; ++i){
		if(hasChild(i)){
			CharNode * tempNode = mPSpeicher->newCharNodeByPos(getChildPos(i));
			num += tempNode->getNumberOfSuffixes();
			mPSpeicher->freeCharNode(tempNode);
		}
	}
	return num;
}

/**
 * Berechnet die L�nge aller Suffixe im Teilbaum.
 */
int CharNode::getSuffixesLength(){
	int num = 0;
	if(hasSuffix()){
		num = suffixLength;
	}
	for(int i=0; i<MAXCHARS; ++i){
		if(hasChild(i)){
			CharNode * tempNode = mPSpeicher->newCharNodeByPos(getChildPos(i));
			num += tempNode->getSuffixesLength();
			mPSpeicher->freeCharNode(tempNode);
		}
	}
	return num;
}

void CharNode::printStatistics(ostream& stream){
	cNodes = 0;
	cChildren = 0;
	cKeys = 0;
	cSuffixes = 0;
	cInfixes = 0;
	cWithoutSuffix = 0;
	cSuffLen = 0;
	cInfixLen = 0;
	// wie viele Abzweigungen?
	cBranch_Leave = 0;
	cBranch_One = 0;
	cBranch_Two = 0;
	cBranch_Three = 0;
	cBranch_Four = 0;

	// Baumtiefe
	aktBaumTiefe = 0;
	maxBaumTiefe = 0;

	getAllStatisticValuesRec();

	stream << "Subtree statistics:" << endl << "current node: << " << *this << endl;
	streamout(stream, cNodes);
	streamout(stream, cChildren);
	streamout(stream, cKeys);
	streamout(stream, cWithoutSuffix);
	streamout(stream, cInternalNodeWithoutKey);
	stream << endl;
	streamout(stream, cSuffixes);
	streamout(stream, cSuffLen);
	streamout(stream, cInfixes);
	streamout(stream, cInfixLen);
	stream << endl;
	streamout(stream, cSuffInternOnly);
	streamout(stream, cSuffExtern);
	streamout(stream, cSuffLenIntern);
	streamout(stream, cSuffLenExtern);
	streamout(stream, cSuffLenInternOnly);
	streamout(stream, cSuffToBeSavedInternally);
	stream << endl;
	streamout(stream, maxBaumTiefe);
	stream << endl;
	streamout(stream, cBranch_Leave);
	streamout(stream, cBranch_One);
	streamout(stream, cBranch_Two);
	streamout(stream, cBranch_Three);
	streamout(stream, cBranch_Four);
	stream << endl;
}

/**
 * Berechnet die Statistischen Werte neu (f�r den Subtree)
 * (rekursiv)
 */
void CharNode::getAllStatisticValuesRec(){

	++cNodes;
	int temp_countChildren = countChildren();
	cChildren += temp_countChildren;
	switch (temp_countChildren){
		case (0): ++cBranch_Leave; break;
		case (1): ++cBranch_One; break;
		case (2): ++cBranch_Two; break;
		case (3): ++cBranch_Three; break;
		case (4): ++cBranch_Four; break;
		default: cerr << "ERROR countChildren() == " << temp_countChildren << endl; exit(-1);
	}
	if(hasKey()) ++cKeys;
	if(hasSuffix()){
		++cSuffixes;
		cSuffLen += suffixLength;
		if(suffixStart == -2){
			++cSuffInternOnly;
			cSuffLenInternOnly += suffixLength;
			cSuffLenIntern += suffixLength;
		}else if(suffixStart >=0){
			++cSuffExtern;
			cSuffLenExtern += suffixLength - nsIntSuffixStringLength;
			cSuffLenIntern += nsIntSuffixStringLength;
		}
		if(suffixLength > nsIntSuffixStringLength && suffixLength <= nsIntSuffixStringLength + 16){
			++cSuffToBeSavedInternally;
		}
	}else if(hasInfix()){
		++cInfixes;
		cInfixLen += infixLength;
	}else{
		++cWithoutSuffix;
	}
	if(!hasKey() && !hasInfix()) ++cInternalNodeWithoutKey;

	for(int i=0;i<MAXCHARS;++i){
		if(hasChild(i)){
			CharNode * tempNode = mPSpeicher->newCharNodeByPos(getChildPos(i)/*childNodesPos[i]*/);
			if(++aktBaumTiefe > maxBaumTiefe) maxBaumTiefe = aktBaumTiefe;
			tempNode->getAllStatisticValuesRec();
			--aktBaumTiefe;
			mPSpeicher->freeCharNode(tempNode);
		}
	}// for
}

/**
 * Numeriert den ganzen Baum neu!<br/>
 *
 * Seiteneffekte:<br/>
 * - keyToUse wird neu nesetzt --> wird um das Intervall incrementiert<br/>
 *   ---> wird in Rekursion aufgerufen, daher ist Seiteneffekt sehr n�tzlich<br/>
 * - AlterKeysMap wird um das ge�nderte Key-Paar erg�nzt; durch eine Exception<br/>
 *   wird das Ganze an den Container weitergegeben (im Index selbst)<br/>
 */
void CharNode::alterKeys(KEY_TYPE& keyToUse, KEY_TYPE interval, AlterKeysMap& map_alterkeys){

	if(hasKey()){
		KEY_TYPE oldKey = getKey();
		KEY_TYPE newKey = keyToUse;
		map_alterkeys.insert(map_alterkeys.end(),KeyPair(oldKey, newKey)); // wird dann am Ende en bloc an den Container weitergegeben
		setKey(keyToUse);
		keyToUse += interval;
		writeNode();
	}
	for(int i=0; i<MAXCHARS; ++i){
		if(hasChild(i)){
			CharNode * tempNode = mPSpeicher->newCharNodeByPos(getChildPos(i));
			tempNode->alterKeys(keyToUse, interval, map_alterkeys);
			mPSpeicher->freeCharNode(tempNode);
		}
	}

}
/**
 * Soll den Baum neu anordnen und Speicherplatz freigeben
 */
void CharNode::IOOrder(CharNode * sourceNode, CharNode * destinationNode){
//	cerr<<"next"<<endl;
	destinationNode->setKey(sourceNode->getKey());
//	cerr<<"next1"<<endl;
	if(sourceNode->hasSuffix()){
//		cerr<<"next2"<<endl;
		destinationNode->setSuffix(sourceNode->getSuffix());
//		cerr<<"next3"<<endl;
	}
//	cerr<<"next4"<<endl;
	if(sourceNode->hasInfix()){
//		cerr<<"next5"<<endl;
		destinationNode->setInfix(sourceNode->getInfix());
//		cerr<<"next6"<<endl;
	}
//	cerr<<"next7"<<endl;
	destinationNode->setMinMax(sourceNode->minLength,sourceNode->maxLength);
//	cerr<<"next8"<<endl;
	destinationNode->freqVector[0]=sourceNode->freqVector[0];
//	cerr<<"next9"<<endl;
	destinationNode->freqVector[1]=sourceNode->freqVector[1];
//	cerr<<"next10"<<endl;
	destinationNode->freqVector[2]=sourceNode->freqVector[2];
//	cerr<<"next11"<<endl;
	destinationNode->freqVector[3]=sourceNode->freqVector[3];
//	cerr<<"next11"<<endl;

	for(int i=0;i<MAXCHARS;++i){
		if(sourceNode->hasChild(i)){
			CharNode * newDestinationChild = destinationNode->mPSpeicher->newCharNodeAppend();
			destinationNode->addChild(i, newDestinationChild->posID);
			CharNode * sourceNodeChild = sourceNode->getChild(i);
//			newDestinationChild->setOption(sourceNodeChild->getOptionByte()); // setOption --> Op=="|="
			newDestinationChild->setOptionByte(sourceNodeChild->getOptionByte()); // ganzes Byte kopieren!
			newDestinationChild->setOption(NODE_OPTION_ISFIXED);
//			newDestinationChild->writeNode_IOOrder();
			newDestinationChild->writeNode();
			IOOrder(sourceNodeChild, newDestinationChild);
			sourceNode->mPSpeicher->freeCharNode(sourceNodeChild);
			destinationNode->mPSpeicher->freeCharNode(newDestinationChild);
		}
	}
//	destinationNode->writeNodeAndSuffix_IOOrder();
	destinationNode->writeNodeAndSuffix();
}

/**
 * Vergleich den Suffix des aktuellen Knotens mit einem string<br/>
 * --> zuerst interner Vergleich, dann "externer" durch ggf. Nachladen des Suffix von der Platte
 *
 */
int CharNode::suffixCompareTo(const string& compTo){
	if(suffixLength <= 0){
		if(compTo.length()>0){
			return -1;
		}else{
			return 0;
		}
	}
	++internalSuffixIntCompCount;
	// nur dann nur intern Vergleichen, wenn beide Strings max. 16 Chars gro� sind
	if(suffixLength <= (unsigned int)nsIntSuffixStringLength && compTo.length()<= (unsigned int)nsIntSuffixStringLength){
		return getIntSuffix().compare(compTo);
	}

	// erstmal intern Vergleichen
	int ret = getIntSuffix().compare(compTo.substr(0,nsIntSuffixStringLength));
	if( ret == 0){
		// hier ist der erste Vergleich positiv, also mu� der Suffix sp�testens jetzt nachgeladen werden
		++internalSuffixExtCompCount;
		return getSuffix().compare(compTo);
	}else{
		// Entscheidung ist gefallen, brauche den Rest nicht mehr zu vergleichen
		return ret;
	}
}


/**
 * Vergleich den Suffix des aktuellen Knotens mit einem anderen Knoten<br/>
 * --> zuerst werden die intern gespeicherten Suffixe vergleichen, dann wird ggf. nachgeladen
 */
int CharNode::suffixCompareTo(CharNode * compTo){
	if(suffixLength <= 0){
		if(compTo->suffixLength > 0){
			return -1;
		}else{
			return 0;
		}
	}
	if(compTo->suffixLength <=0){
		return 1;
	}
	++internalSuffixIntCompCount;
	int ret = getIntSuffix().compare(compTo->getIntSuffix());
	if(ret == 0){
		++internalSuffixExtCompCount;
		return getSuffix().compare(compTo->getSuffix());
	}else{
		return ret;
	}

}

/**
 * Suffix-Vergleich wie oben, nur da� beim Suffix von compTo erst ab einer gewissen Position angefangen wird
 */
int CharNode::suffixCompareTo_withStartPos(CharNode * compTo, int startPos){
	//cerr << "suffixCompareTo_withStartPos" << endl;
	if(suffixLength <= 0){
		if(compTo->suffixLength > 0){
			return -1;
		}else{
			return 0;
		}
	}
	if( (compTo->suffixLength - startPos) <=0){
		return 1;
	}

	int compToIntSuffixPartLength = (nsIntSuffixStringLength < compTo->suffixLength? nsIntSuffixStringLength : compTo->suffixLength) - startPos;

	if(compToIntSuffixPartLength > 0){
		//cerr << "( 1 1 )" << endl;
		++internalSuffixIntCompCount;
		const string& compToIntSuffixPart(compTo->getIntSuffix().substr(startPos));
		const string& curNodeIntSuffixPart(getIntSuffix().substr(0,compToIntSuffixPartLength));
		int ret = curNodeIntSuffixPart.compare(compToIntSuffixPart);
		if(ret == 0){
			//cerr << "( 1 2 )" << endl;
			++internalSuffixExtCompCount;
			return getSuffix().compare(compTo->getSuffix().substr(startPos));
		}
		return ret;
	}else{
		// erstmal den einen Suffix laden
		//cerr << "( 2 1 )" << endl;
		const string& curNodeIntSuffix(getIntSuffix());
		const string& compToSuffix(compTo->getSuffix().substr(startPos));
		const string& compToSuffixSubstring(compToSuffix.substr(0,curNodeIntSuffix.length()));
		int ret = compToSuffixSubstring.compare(curNodeIntSuffix);
		if(ret == 0){
			//cerr << "( 2 2 )" << endl;
			++internalSuffixExtCompCount;
			return getSuffix().compare(compToSuffix);
		}
		return ret;
	}
}


/**
 * Traversiert den Baum und schaut, da� die Reihenfolge der Keys auch korrekt ist
 */
KEY_TYPE CharNode::checkNodeNumbering(KEY_TYPE lastKey, POS_TYPE lastKeyNodePos){
	//if(special_debug){
	//	cerr << "checkNodeNumbering: " <<  *this << endl;
	//}
	if(hasKey()){
		if(lastKey >= getKey()){
			cerr << "check: lastKey >= getKey()!!" << endl << *this << endl;
			cerr << "lastKey == " << lastKey << endl;
			cerr << "lastKeyNodePos == " << lastKeyNodePos << endl;
			if(lastKeyNodePos != PTREE_NULLPOS){
				CharNode * lastKeyNode = mPSpeicher->newCharNodeByPos(lastKeyNodePos);
				cerr << "lastKeyNode == " << endl << *lastKeyNode << endl;
				cerr << "lastKeyNode == " << endl << lastKeyNode->print() << endl;
			}
			exit(-1);
		}
		lastKey = getKey();
		lastKeyNodePos = posID;
	}
	for(int i = 0; i<MAXCHARS;++i){
		if(hasChild(i)){
			CharNode * temp = getChild(i);
			lastKey = temp->checkNodeNumbering(lastKey, lastKeyNodePos);
			checkPosDelete(temp);
		}
	}
	return lastKey;
}

// startet das rekursive Absuchen des Baumes nach der L�nge der Infix-Ketten
void CharNode::printInfixStatistics(){

	// alles im Vector auf 0 setzen
	for(vector<int>::iterator it = histogramm.begin();it!=histogramm.end();++it){
		*it = 0;
	}

	infixCount = -1;
	printInfixStatistics_rec();

	cerr << "InfixStatistik:" << endl;

	int sum_knoten_in_infixen = 0;
	int sum_einzusparende_knoten = 0;
	int sum_knoten_intinfix = 0;
	int sum_knoten_intinfix_zuviel = 0;

	// jetzt nur noch den Vector ausgeben
	for(int i=1; i <= 3000;++i){
		int val = histogramm[i];
		if(val > 0){
			sum_knoten_in_infixen += val;
			sum_einzusparende_knoten += (i*val);
			sum_knoten_intinfix += (int)(ceil((double)i / (double)22.0) * val);
			sum_knoten_intinfix_zuviel += ((int)(ceil((double)i / (double)22.0) * val) - val);

			cerr << "Kettenl�nge \t" << i << ":\t" /*<< cerr.width(5)*/ << val
				<< "\t, einzusparende Knoten: " << (i*val)
				<< "\tintInfix-Methode (#Knoten): " << (ceil((double)i / (double)22.0) * val)
				<< "\t/ " << val << "\t+ " <<  ((ceil((double)i / (double)22.0) * val) - val)
				<<  endl;
		}
	}

	cerr << "Zusammenfassung:" << endl;
	streamout(cerr, sum_knoten_in_infixen);
	streamout(cerr, sum_einzusparende_knoten);
	streamout(cerr, sum_knoten_intinfix);
	streamout(cerr, sum_knoten_intinfix_zuviel);
}

void CharNode::printInfixStatistics_rec(){ // rekursiver Teil
	if(countChildren() == 1 && !hasKey()){
		++infixCount;
	}else{
		if(infixCount > 0){
			histogramm[infixCount] = histogramm[infixCount] + 1;
			infixCount = -1; // zur�cksetzen, da die Infix-Kette zuende ist
		}
	}
	for(int i=0;i<MAXCHARS;++i){
		if(hasChild(i)){
			CharNode * childNode = getChild(i);
			childNode->printInfixStatistics_rec();
			checkPosDelete(childNode);
		}
	}
}


/***
 * Berechnet die Knotengr��e auf der Platte laut optionByte
 */
int getNodeSizeOnDisk(unsigned char p_optionByte){
	if(p_optionByte & NODE_OPTION_ISFIXED) return nsNodeSizeOnDisk;
	int ret = 0;
	if(p_optionByte & NODE_OPTION_HASKEY) ret += sizeof(KEY_TYPE);
	if(p_optionByte & NODE_OPTION_HASSUFFIX){
		ret += sizeof(LENGTH_TYPE) + nsIntSuffixSize;
		if(p_optionByte & NODE_OPTION_SUFFIX_HASSUFFIXSTART) ret += sizeof(SUFFIXSTART_TYPE);
	}else{
		if(p_optionByte & NODE_OPTION_HASINFIX) ret += nsInfixSize;
		if(p_optionByte & NODE_OPTION_HASCHAR_A) ret += sizeof(POS_TYPE);
		if(p_optionByte & NODE_OPTION_HASCHAR_C) ret += sizeof(POS_TYPE);
		if(p_optionByte & NODE_OPTION_HASCHAR_G) ret += sizeof(POS_TYPE);
		if(p_optionByte & NODE_OPTION_HASCHAR_T) ret += sizeof(POS_TYPE);
	}
	return ret + sizeof(unsigned char);
}

void CharNode::setFreqVect(unsigned int vector[]){
	for(int i = 0;i<MAXCHARS;++i){
		freqVector[i]=vector[i];
	}
}

void CharNode::addOneToFreqVectPos(int pos){
	freqVector[pos]++;
}

void CharNode::substrOneFromFreqVectPos(int pos){
	freqVector[pos]--;
}

void CharNode::setMinMax(unsigned int min, unsigned int max){
	minLength=min;
	maxLength=max;
}
