
#include "globals.hpp"
#include "PTree.hpp"
#include "CharNode.hpp"
#include "Index.hpp"
#include "Watch.h"
#include <list>

#define INITIALTABLESIZE 5000
#define debug false

class ApproxSearch {

	PTree * tree;
	Index * index;
	char * treestr;
	int k;
	bool freqf;
	bool lenf;
	bool qgrf;
	int * freqVector;

public:
	int **elaTable;
	unsigned int patternlength;
	ApproxSearch(PTree *lefttree,int tresh,bool freqfilter, bool lengthfilter, bool qgramfilter){
		tree=lefttree;
		k=tresh;
		treestr = new char[INITIALTABLESIZE];
		freqf = freqfilter;
		if(freqf) {
			freqVector= new int [MAXCHARS];
			for(int i=0;i<MAXCHARS;++i) freqVector[i]=0;
		}
		lenf=lengthfilter;
		qgrf=qgramfilter;
	}

	ApproxSearch(Index *p_left_index, int k_val,bool freqfilter, bool lengthfilter, bool qgramfilter) :
		index(p_left_index),  k(k_val) {
		if(!p_left_index) {
//			cerr <<"exit."<<endl;
			exit(-1);
		}
		tree = p_left_index->getTree();
		treestr = new char[INITIALTABLESIZE];
		freqf = freqfilter;
		if(freqf) {
			freqVector= new int [MAXCHARS];
			for(int i=0;i<MAXCHARS;++i) freqVector[i]=0;
		}
		lenf=lengthfilter;
		qgrf=qgramfilter;
//		cerr<<"done"<<endl;
	}
	ApproxSearch(PTree *lefttree,int tresh, bool ela, int length,bool freqfilter, bool lengthfilter, bool qgramfilter){
		tree=lefttree;
		k=tresh;
		patternlength=length;
		treestr = new char[INITIALTABLESIZE];
		if(ela){
			elaTable = new int*[INITIALTABLESIZE];
			for (int i = 0; i < INITIALTABLESIZE;++i){
				elaTable[i]=NULL;
				elaTable[i]=new int[length+1];
				elaTable[i][0]=i;
			}
			for (int i = 0; i <length+1;++i){
				elaTable[0][i]=i;
			}

		}
		freqf = freqfilter;
		if(freqf) {
			freqVector= new int [MAXCHARS];
			for(int i=0;i<MAXCHARS;++i) freqVector[i]=0;
		}
		lenf=lengthfilter;
		qgrf=qgramfilter;
	}

	ApproxSearch(Index *p_left_index, int k_val, bool ela, int length, bool freqfilter, bool lengthfilter, bool qgramfilter) :
		index(p_left_index),  k(k_val) {
		if(!p_left_index) exit(-1);
		tree = p_left_index->getTree();
		treestr = new char[INITIALTABLESIZE];
		patternlength=length;
		if(ela){
			elaTable = new int*[INITIALTABLESIZE];
			for (int i = 0; i < INITIALTABLESIZE;++i){
				elaTable[i]=NULL;
				elaTable[i]=new int[length+1];
				elaTable[i][0]=i;
			}
			for (int i = 0; i <length+1;++i){
				elaTable[0][i]=i;
			}

		}
		freqf = freqfilter;
		if(freqf) {
			freqVector= new int [MAXCHARS];
			for(int i=0;i<MAXCHARS;++i) freqVector[i]=0;
		}
		lenf=lengthfilter;
		qgrf=qgramfilter;
	}

	int kmSearch(string& pattern);
	int elaSearch(string& pattern);
	int bigTestKMSearch(string name_tree, string name_patterns, int k, bool freqfilter, bool lengthfilter);
	//int	doTestELASearch(string(fileNameA),string(fileNameB),k);
	int	smallTestKMSearch(string name_tree, string pattern, int k, bool freqfilter, bool lengthfilter);
	//int searchELA(string(fileNameA), string(pattern),k);

private:
	void kmRec(CharNode * left,int posLeft, int posInfixLeft, string& pattern, int& patternLength, unsigned int posPattern, int mismatches);
	void elaRec(CharNode * left, int last_pos_left, string &pattern, int& patternLength);
	void printMatch(int left, int right);
	void printELAMatch(int left, int right);
	int kBand(char left, char right, int pos_left, int pos_right);
	void printtable(int l, int r);
	bool evalFreqVector(CharNode * treenode, int posTree, int posPattern);
	bool matchInternalQGrams(string& suffix, string& pattern);
};


/**
 * Interface
 * - indexName
 * - indexSchema
 * - int Operation
 * - char * cmpVal
 * - char ** returned_rowids (zeiger auf ein RowID-Feld)
 * - int treshold
 *
 * In den Scan-Context:
 * - Pointer auf Feld
 * - int Gesamtgröße
 * - Pointer auf aktuelle Position
 *
 */
int itf_ODCIIndexAppx(
		char * indexName,
		char * schemaName,
		char * operationType,
		char * cmpVal,
		char ** rowids,
		int k){

	if(!operationType) return -10101;
	if(!cmpVal) return -10102;
	if(!k) return -10104;
	if(!rowids) return -10103;


	FILE * f = fopen("/usr/lib/oracle/xe/oradata/idxdata/log_itf_ODCIIndexAppx.log","w");
	if(f){
		fprintf(f, "indexName == %s\n" , indexName);
		fprintf(f, "schemaName == %s\n" , schemaName);
		fprintf(f, "operationType == %s\n" , operationType);
		fprintf(f, "cmpVal == %s\n" , cmpVal);
		fprintf(f, "treshold == %d\n" , k);
		//fclose(f);
	}


	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index * i = new Index(string(indexName), string(schemaName),'W');

	// Rückgabewerte der Selektoren
	StringVector * sv = NULL;

	if(strcmp(operationType, "k")==0){
		ApproxSearch s(i, k, false, true, false);
		string s_cmpVal((string)cmpVal);
		s.kmSearch(s_cmpVal);
		if(f)fprintf(f,"sv = i.kmSearch(s_cmpVal);\n");
	}else
	if(strcmp(operationType, "K")==0){
		ApproxSearch s(i, k, false, true, false);
		string s_cmpVal((string)cmpVal);
		s.kmSearch(s_cmpVal);
		//sv = i.select_eq(string(cmpVal));
		if(f)fprintf(f,"sv = i.kmSearch(s_cmpVal);\n");
	}else
	if(strcmp(operationType, "e")==0){;
		string s_cmpVal("Z"+(string)cmpVal);
		ApproxSearch s(i, k, true,s_cmpVal.length(), false, true,true);
		if(debug) cerr <<"calling elaSearch("<<cmpVal<<")"<<endl;
		s.elaSearch(s_cmpVal);
		if(f)fprintf(f,"sv = i.elaSearch(s_cmpVal);\n");

	}else
	if(strcmp(operationType, "E")==0){
		string s_cmpVal("Z"+(string)cmpVal);
		ApproxSearch s(i, k, true,s_cmpVal.length(), false, true,true);
		if(debug) cerr <<"calling elaSearch("<<cmpVal<<")"<<endl;
		s.elaSearch(s_cmpVal);
		if(f)fprintf(f,"sv = i.elaSearch(s_cmpVal);\n");

	}else{
		//Default
		// noch eine exception werfen...
		return -10109;
	}

	// sv? -> toChar* (field) : NULL;

	if(sv != NULL && sv->size() > 0){
		int sizeSV = sv->size();
		int sizeField = (sizeSV + 1)*CONTAINER_TID_SIZE; // für die NULL am Ende
		char * rid = (char*)malloc(sizeField);
		char * cPos = rid;
		char * emptyEntry = "emptyEntryNULLNULL";

		if(f)fprintf(f,"sizeSV == %d\n", sizeSV);
		if(f)fprintf(f,"sizeField == %d\n", sizeField);

		for(StringVector::iterator it = sv->begin(); it != sv->end(); ++it){
			memcpy(cPos, it->c_str(), CONTAINER_TID_SIZE);
			cPos += CONTAINER_TID_SIZE;
			if(f)fprintf(f,"it->c_str() == %s\n", it->c_str());
			if(f)fprintf(f,"cPos == %d\n", cPos);
		}
		memcpy(cPos, emptyEntry, CONTAINER_TID_SIZE);
		delete sv;
		// Pointer auf das Feld zurückgeben
		*rowids = rid;
		if(f)fclose(f);
		return sizeSV;
	}

	if(f)fclose(f);

	// sv löschen, falls vorhanden (sollte nicht)
	if(sv) delete sv;
	// und beenden (nichts gefunden)
	if(sv->size() == 0){
		return 0;
	}
	return -10104;
}

int bigTestKMSearch(string name_tree, string name_patterns, int k, bool freqfilter, bool lengthfilter){
		Index * idx = new Index(name_tree,string("_"), 'W');
		ApproxSearch s(idx, k, freqfilter, lengthfilter, false);
		fstream m_stream(name_patterns.c_str());
		if(!m_stream){
			cerr << "file " << name_patterns << " not found!" << endl;
			return false;
		}
		list<string> dest;
		string str;
		while (!m_stream.eof()){
			getline(m_stream,str);
			//ignore empty lines
			if (str.empty()) continue;
			dest.push_back(str);
		}

		for (list<string>::iterator i = dest.begin();i != dest.end();++i){
			s.kmSearch(*i);
		}
		delete idx;
		return 0;
}

int smallTestKMSearch(string name_tree, string pattern, int k, bool freqfilter, bool lengthfilter){
	Index * idx = new Index(name_tree,string("_"), 'W');
	ApproxSearch s(idx, k, freqfilter, lengthfilter, false);
	if(debug) cerr <<"calling kmSearch("<<pattern<<")"<<endl;
	s.kmSearch(pattern);
	delete idx;
	return 0;
}

int bigTestELASearch(string name_tree, string name_patterns, int k, bool freqfilter, bool lengthfilter, bool qgramfilter){
		Index * idx = new Index(name_tree,string("_"), 'W');
		ApproxSearch s(idx, k, true, INITIALTABLESIZE-1, freqfilter, lengthfilter, qgramfilter);
		fstream m_stream(name_patterns.c_str());
		if(!m_stream){
			cerr << "file " << name_patterns << " not found!" << endl;
			return false;
		}
		list<string> dest;
		string str;
		while (!m_stream.eof()){
			getline(m_stream,str);
			//ignore empty lines
			if (str.empty()) continue;
			dest.push_back("Z"+str);
		}
		for (list<string>::iterator i = dest.begin();i != dest.end();++i){
			s.patternlength=(*i).length();
			if(debug) cerr <<"calling elaSearch("<<*i<<")"<<endl;
			s.elaSearch(*i);

		}
		delete idx;
		return 0;

}

int smallTestELASearch(string name_tree, string pattern, int k, bool freqfilter, bool lengthfilter,bool qgramfilter){
	Index * idx = new Index(name_tree,string("_"), 'W');
	ApproxSearch s(idx, k, true, pattern.length()+1, freqfilter, lengthfilter,qgramfilter);
	string newpatt("Z"+pattern);

	if(debug) cerr <<"calling elaSearch("<<newpatt<<")"<<endl;
	s.elaSearch(newpatt);
	delete idx;
	return 0;

}

int ApproxSearch::kmSearch(string& pattern){
	CharNode * root = tree->getRootNode();
	int patternLength = pattern.length();

	//apply length filtering if desired
	if(lenf){
		if(debug) cerr<<"min: "<<root->minLength<<"\tmax: "<<root->maxLength<<endl;
		if(abs(root->minLength)>patternLength) return 0;
		if (abs(root->maxLength)<patternLength) return 0;
	}
	if(freqf){
		for(unsigned int i = 1; i < pattern.length();++i){
			freqVector[hashChar(pattern[i])]++;
		}
	}
	if(debug)cerr <<"fvect: "<<freqVector[0]<<" "<<freqVector[1]<<" "<<freqVector[2]<<" "<<freqVector[3]<<endl;

	kmRec(tree->getRootNode(),0,0,pattern,patternLength,0,0);
	return 0;
}

int ApproxSearch::elaSearch(string& pattern){
	CharNode * root = tree->getRootNode();
	int patternLength = pattern.length()-1;

	//apply length filtering if desired
	if(lenf){
		if(abs((int)root->minLength-k)>patternLength) return 0;
		if (abs((int)root->maxLength+k)<patternLength) return 0;
	}
	if(freqf){
		for(unsigned int i = 1; i < pattern.length();++i){
			freqVector[hashChar(pattern[i])]++;
		}
	}

	if (debug) cerr<<"passed filter"<<endl;
	elaRec(tree->getRootNode(),1,pattern,patternLength);
	return 0;
}

void ApproxSearch::printMatch(int left, int right){
	//cout<<"Treffer mit "<<mismatches<<" Mismatches"<<endl;
	for (int i = 0; i < left;++i){
		cout<<treestr[i];
	}
	cout<<endl;
//	for (int i = 0; i < right;++i){
//		cout<<rightstr[i];
//	}
//	cout<<"\n======================"<<endl;
}

void ApproxSearch::printELAMatch(int left, int right){
	//cout<<"Treffer mit "<<mismatches<<" Mismatches"<<endl;
	for (int i = 1; i < left;++i){
		cout<<treestr[i];
	}
	cout<<endl;
}

bool ApproxSearch::evalFreqVector(CharNode * treenode, int posTree, int posPattern){
	int lengthdiff;
	if(treenode->hasInfix()){
		lengthdiff = (treenode->infixLength+posTree)-posPattern;
	}
	else if(treenode->hasSuffix()){
			lengthdiff = (treenode->suffixLength+posTree)-posPattern;
	}
	else{
		lengthdiff = posTree-posPattern;
	}

	int vect[4];
	vect[0]=((int)treenode->freqVector[0]-(int)freqVector[0]);
	vect[1]=((int)treenode->freqVector[1]-(int)freqVector[1]);
	vect[2]=((int)treenode->freqVector[2]-(int)freqVector[2]);
	vect[3]=((int)treenode->freqVector[3]-(int)freqVector[3]);

	int pos(0);
	int neg(0);
	for(int i =0;i<4;++i){
		if (vect[i]>0) pos+=vect[i];
		if (vect[i]<0) neg+=abs(vect[i]);
	}
	if((min(pos,neg)-abs(lengthdiff))<=k)return true;
	else return false;
}

bool ApproxSearch::matchInternalQGrams(string& suffix, string& pstr){
	int q = 4;
	if(suffix.length()<q)return true;
	int size = (int)pow(MAXCHARS,q);
	int qgramleft[size];//256
	bool seenleft[size];
	bool seenright[size];
	int maxlen = max(suffix.length(),pstr.length());
	int allowed_mismatches = (maxlen-q+1)-(maxlen-1-(k-1)*q);
	if(allowed_mismatches < 0) allowed_mismatches=0;
	int mismatches(0);
	memset(qgramleft, -1, size * sizeof(int));
	memset(seenleft, 0, size * sizeof(bool));
	memset(seenright, 0, size * sizeof(bool));

	int left(0);
	int right(0);

	left = hashChar(suffix[0]);
	left = left | (hashChar(suffix[1])<<2);
	left = left | (hashChar(suffix[2])<<4);
	left = left | (hashChar(suffix[3])<<6);
	qgramleft[left]=1;
	seenleft[left]=true;
	int j=2;
	for(unsigned int i=4;i<suffix.length();++i){
		left=left>>2;
		left = left | (hashChar(suffix[i])<<6);
		++j;
		if (!seenleft[left]){
			qgramleft[left]=j;
			seenleft[left]=true;
		}
	}

	right = hashChar(pstr[0]);
	right = right | (hashChar(pstr[1])<<2);
	right = right | (hashChar(pstr[2])<<4);
	right = right | (hashChar(pstr[3])<<6);

	j=1;
	for(int i=4;i<pstr.length();++i){
		if(mismatches>allowed_mismatches) return false;
		if(!seenleft[right]) ++mismatches;
		else{
			if(!seenright[right]){
			seenright[right]=true;
				if(k>0){
					if(abs(qgramleft[right]-j)>k) ++mismatches;
				}
			}
		}
		j++;
		right=right>>2;
		right = right | (hashChar(pstr[i])<<6);
	}


	if(mismatches>allowed_mismatches) return false;
	else return true;
}



void ApproxSearch::kmRec(CharNode * left,int posLeft, int posInfixLeft, string& pattern, int& patternLength, unsigned int posPattern, int mismatches){
	//links hat infix, der noch verglichen werden muss
	if(left->hasInfix() && left->infixLength > posInfixLeft){
//		if(debug) cerr<<"left->hasInfix() && left->infixLength > posInfixLeft"<<endl;
		if(left->getInfixRef()[posInfixLeft]==pattern[posPattern]){
			treestr[posLeft]=left->getInfixRef()[posInfixLeft];
			kmRec(left, posLeft+1,posInfixLeft+1,pattern,patternLength,posPattern+1,mismatches);
			//if(debug) cerr<<"\t\tdone"<<endl;
			return;
		}
		else if ((mismatches+1)<=k){
			treestr[posLeft]=left->getInfixRef()[posInfixLeft];
			//if(debug) cerr<<"\t\tcalling joinRec2(_, "<<posLeft+1<<","<<posInfixLeft+1<<",_,"<<posRight+1<<","<<posInfixRight+1<<","<<mismatches+1<<")"<<endl;
			kmRec(left, posLeft+1,posInfixLeft+1,pattern,patternLength,posPattern+1,mismatches+1);
			//if(debug) cerr<<"\t\tdone"<<endl;
			return;
		}
	}

	else if(left->hasSuffix()){
//		if(debug) cerr<<"left->hasSuffix()"<<endl;

		//restliche Suffixe sind nicht gleich lang->stop
		if (left->suffixLength!=(pattern.length()-posPattern)){
			//if(debug) cerr << "cRSNWLT: suffixe sind unterschiedlich lang."<<endl;
			return;
		}
		int lsufflen(left->suffixLength);
		int nmis(mismatches);
		int pl(posLeft);
		int pr(posPattern);

		string lsuffix(left->getIntSuffix());
		for(int i = 0; i <lsufflen;++i){
			if(i==nsIntSuffixStringLength){
				lsuffix = left->getSuffix();
			}
			if(lsuffix[i]==pattern[pr]){
				pr++;
				treestr[pl++]=lsuffix[i];
				continue;
			}
			else if((nmis+1)<=k){
				pr++;
				treestr[pl++]=lsuffix[i];
				nmis++;
				continue;
			}
			else return;
		}
		//Treffer
		if(nmis<=k){
//			if(debug) cout<<"4Treffer.suffixe passen"<<endl;
			printMatch(pl,pr);
		}
		return;
	}

	else if ((left->hasKey()) && (posPattern==pattern.length())){

//		if(debug) cout<<"1left->hasKey()&&right->hasKey(). Treffer."<<endl;
		printMatch(posLeft, posPattern);
	}

	else {
		for(int i=0;i<MAXCHARS;++i){
//			if(debug) cerr<<"untersuche kinder"<<endl;
			if (left->hasChild(i)){
				if(unhashChar(i)==pattern[posPattern]){
					CharNode * child_left = left->getChild(i);

					//apply length filtering if desired
					if(lenf){
//						if(debug) cerr<<"min: "<< child_left->minLength<<"\tmax: "<< child_left->maxLength<<endl;
						if(abs(child_left->minLength)>patternLength) continue;
						if (abs(child_left->maxLength)<patternLength) continue;
					}

					//apply freqency vector filtering if desired
					if(freqf){

//						if(debug) cerr<<"pos left: "<<posLeft<<"\t patternLength: "<<patternLength<<"\tfvects match: "<<evalFreqVector(child_left,posLeft,patternLength)<<endl;
//						if(debug) cerr <<child_left->freqVector[0]<<"\t"<<child_left->freqVector[1]<<"\t"<<child_left->freqVector[2]<<"\t"<<child_left->freqVector[3]<<endl;
//						if(debug) cerr <<freqVector[0]<<"\t"<<freqVector[1]<<"\t"<<freqVector[2]<<"\t"<<freqVector[3]<<endl;
						if(!evalFreqVector(child_left,posLeft+1,patternLength-1)) continue;
					}

					treestr[posLeft]=unhashChar(i);
					//if(debug) cerr<<"\tcalling joinRec2("<<unhashChar(i)<<","<<posLeft+1<<",0,"<<unhashChar(j)<<","<<posRight+1<<",0,"<<mismatches<<endl;
					kmRec(child_left,posLeft+1,0, pattern,patternLength,posPattern+1,mismatches);
					//if(debug) cerr<<"\tdone joinrec"<<endl;
					left->mPSpeicher->freeCharNode(child_left);
				}
				else {
					if((mismatches+1)<=k){
						CharNode * child_left = left->getChild(i);

						//apply length filtering if desired
						if(lenf){
							if(abs(child_left->minLength)>patternLength) continue;
							if (abs(child_left->maxLength)<patternLength) continue;
						}

						//apply freqency vector filtering if desired
						if(freqf){
//							if(debug) cerr<<"fvects match: "<<evalFreqVector(child_left,posLeft,patternLength)<<endl;
							if(!evalFreqVector(child_left,posLeft+1,patternLength-1)) continue;
						}

						treestr[posLeft]=unhashChar(i);
						//if(debug) cerr<<"\tcalling joinRec2("<<unhashChar(i)<<","<<posLeft+1<<",0,"<<unhashChar(j)<<","<<posRight+1<<",0,"<<mismatches+1<<endl;
						kmRec(child_left,posLeft+1,0, pattern,patternLength,posPattern+1,mismatches+1);
						//if(debug) cerr<<"\tdone joinrec"<<endl;
						left->mPSpeicher->freeCharNode(child_left);
					}
				}
			}
		}
		return;
	}
}

int ApproxSearch::kBand(char left, char right, int pos_left, int pos_right){
	if(left == right) return elaTable[pos_left-1][pos_right-1];
	else return elaTable[pos_left-1][pos_right-1]+1;
}

void ApproxSearch::printtable(int l, int r){
	for(int i = 0; i < l;++i){
		for (int j = 0; j < r;++j){
			cerr << elaTable[i][j]<<" ";
		}
		cerr<<endl;
	}
}

void ApproxSearch::elaRec(CharNode * left, int pos_left, string &pattern, int& patternLength){
	//pos_left: next position in treestr
	int next(pos_left);

	if (left->hasInfix()){
//		if(debug) cerr <<"left->hasInfix()"<<endl;
		int leftInfixLength(left->infixLength);

		//berechne Matrix für infixRight
		int infixpos(0);
		int last(pos_left+leftInfixLength);
		for (int i = pos_left; i < last;++i){
			treestr[i]=left->getInfixRef()[infixpos++];
			int val_left(elaTable[i][0]);
			for (unsigned int j = 1; j<=patternlength;++j) {
				if(abs(i-j)>k) continue;
				elaTable[i][j]=kBand(treestr[i],pattern[j],i,j);
				if(elaTable[i][j] < val_left) val_left=elaTable[i][j];
			}
			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if (val_left > k) {
//				cerr << "1"<<endl;
				return;
			}
			next = pos_left+leftInfixLength; //next pos
		}
	}

	else if(left->hasSuffix()){
//		if(debug) cerr <<"left->hasSuffix()"<<endl;
		string suffix(left->getIntSuffix());
		int length(left->suffixLength);
		//berechne Matrix für suffix
		int suffpos(0);
		int last(pos_left+length);
		for (int i = pos_left; i <last;++i){
			if(suffpos==(nsIntSuffixStringLength)){
				suffix=left->getSuffix();
				if(qgrf){
					int l = patternlength-left->suffixLength;
					if (l < 1) l =1;
					string pstr = pattern.substr(l, patternlength);
//					cerr << "calling mIQ(\n"<<suffix<<"\n"<<pstr<<endl;
					if(!matchInternalQGrams(suffix, pstr)) return;
				}
			}
			treestr[i]=suffix[suffpos++];

			int val_left(elaTable[i][0]);
			for (unsigned int j = 1; j<=patternlength;++j) {
				if(abs(i-j)>k)continue;
				elaTable[i][j]=kBand(treestr[i],pattern[j],i,j);
				if(elaTable[i][j] < val_left) val_left=elaTable[i][j];
			}
			//kleinster Wert in letzter berechneter Zeile der Matrix ist größer als tresh -> stopp
			if (val_left > k) {
				return;
			}
		}

		if(abs((pos_left+length)-patternlength)<=k){
			if (elaTable[pos_left+length-1][patternlength-1]<=k){
				printELAMatch(pos_left+length,patternlength);
			}
		}

		return;
	}
	else{
		if(left->hasKey()){
//			if(debug) cerr <<"left->hasKey()"<<endl;
			//auf jeden Fall ein Treffer, treshold wurde schon vor Rek.abstieg geprüft
//			cerr << pos_left<<"-"<<patternlength<<"<=k"<<endl;
//			cerr << abs((pos_left)-patternlength)<<"<="<<k<<endl;
//			printtable(pos_left+1,patternlength+1);
			if(abs((pos_left)-patternlength)<=k){
//				cerr << elaTable[pos_left-1][patternlength-1]<<"<="<<k<<endl;
				if (elaTable[pos_left-1][patternlength-1]<=k){
					printELAMatch(pos_left,patternlength);
				}
			}
		}
		next=pos_left;
	}

	for(int i = 0; i < MAXCHARS; ++i){
		if(left->hasChild(i)){
			int val_left(elaTable[next][0]);
			treestr[next]=unhashChar(i);
			for (unsigned int j = 1; j<=patternlength;++j) {
				if(abs(next-j)>k)continue;
				elaTable[next][j]=kBand(treestr[next],pattern[j],next,j);
				if(elaTable[next][j] < val_left) val_left=elaTable[next][j];
			}
			if(val_left>k){
				continue;
			}
			CharNode * child_left = left->getChild(i);

			//apply length filter, if desired
			if(lenf){
//				if(debug) cerr <<"minl: "<<abs(child_left->minLength-k)<<">"<<patternLength<<endl;
//				if(debug) cerr <<"maxl: "<<abs(child_left->maxLength+k)<<"<"<<patternLength<<endl;
				if(abs(child_left->minLength-k)>patternLength){
					left->mPSpeicher->freeCharNode(child_left);
					continue;
				}
				if (abs(child_left->maxLength+k)<patternLength) {
					left->mPSpeicher->freeCharNode(child_left);
					continue;

				}
			}

			//apply freqency vector filtering if desired
			if(freqf){

//				if(debug) cerr<<"pos left: "<<next+1<<"\t patternLength: "<<patternLength<<"\tfvects match: "<<evalFreqVector(child_left,next,patternLength)<<endl;
//				if(debug) cerr <<child_left->freqVector[0]<<"\t"<<child_left->freqVector[1]<<"\t"<<child_left->freqVector[2]<<"\t"<<child_left->freqVector[3]<<endl;
//				if(debug) cerr <<freqVector[0]<<"\t"<<freqVector[1]<<"\t"<<freqVector[2]<<"\t"<<freqVector[3]<<endl;
				if(!evalFreqVector(child_left,next,patternLength)) continue;
			}


			elaRec(child_left,next+1,pattern,patternLength);
			left->mPSpeicher->freeCharNode(child_left);
		}
	}
	return;

}


int main(int argc, char ** argv){
	// ./appxsearch.out T<name of tree> P<patternfile> OK k<no of allowed mistakes> =>bigTest for kMismatches
	Watch watch;
	// F - File insert
	// I - IOOrder
	// S - Statistics

	char operation = 0;
	char * fileNameA = "";
	char * fileNameB = "";
	char * pattern="";
	int k = 0;
	bool lf=false;//length filter
	bool ff=false;//frequency filter
	bool qf=false;//q-gram filter
	for(int i=1; i < argc; ++i){

		switch(*argv[i]){

			case 'O':{ // Operation
				operation = argv[i][1];
				break;}
			case 'T':{ // FileName A
				fileNameA = &argv[i][1];
				break;}
			case 'P':{ // FileName PatternList
				fileNameB = &argv[i][1];
				break;}
			case 'p':{ //single Pattern
				pattern =&argv[i][1];
				break;}
			case 'k':{ //no of allowed mistakes
				k = atoi(&(argv[i][1]));
//				cerr<<"k: "<<k<<endl;
				break;}
			case 'l':{ //enable length filter
				if(debug) cerr<<" length filter on"<<endl;
				lf=true;
				break;}
			case 'f':{ //enable frequency filter
				ff=true;
				break;}
			case 'q':{
				qf =true;
				break;
			}
			default:
				break;
		}
	}
//	cerr << "Operation " << operation << endl;
//	cerr << "FileNameA " << fileNameA << endl;
//	cerr << "FileNameB/Pattern " << fileNameB << endl;
//	cerr << "k: "<<k<<endl;

	switch(operation){
		case 'K':{
			bigTestKMSearch(string(fileNameA), string(fileNameB),k,ff,lf);
			break;}
		case 'E':{
			if(debug) cerr <<"calling bigTestELASearch"<<endl;
			bigTestELASearch(string(fileNameA),string(fileNameB),k,ff,lf,qf);
			break;}
		case 'k':{
			if(debug) cerr <<"calling smallTestKMSearch"<<endl;
			smallTestKMSearch(string(fileNameA), string(pattern),k,ff,lf);
			break;}
		case 'e':{
			if(debug) cerr <<"calling smallTestELASearch"<<endl;
			smallTestELASearch(string(fileNameA), string(pattern),k,ff,lf,qf);
			break;}
		default:
			break;
	}



	return 0;
}
