//
//  ASyncSocketTestViewController.m
//  ASyncSocketTest
//
//  Created by Ingmar Eveslage on 28.06.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "ASyncSocketTestViewController.h"

@implementation ASyncSocketTestViewController

@synthesize manager;

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    manager = [[SocketCommunicationManager alloc] init];
    
    [[NSNotificationCenter defaultCenter] addObserver:self 
                                             selector:@selector(receivedMessageEvent:) 
                                                 name:kNotification 
                                               object:nil];
}

- (void)viewDidUnload
{
    [messageLabel release];
    messageLabel = nil;
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

- (IBAction)buttonPressed:(id)sender {
    [manager connectToHost:@"127.0.0.1" onPort:10000];
    
}

- (IBAction)send:(id)sender {
    [manager sendMessage:@"hello world from iPhone"];
}

- (IBAction)receivedMessage:(id)sender {
    NSDictionary *userInfo = [NSDictionary dictionaryWithObject:@"hello dummy" forKey:kNotificationMessage];
    [[NSNotificationCenter defaultCenter] postNotificationName:kNotification 
                                                        object:self
                                                      userInfo:userInfo];
    
}

- (void) receivedMessageEvent:(NSNotification*) notification {
    messageLabel.text = [notification.userInfo objectForKey:kNotificationMessage];
}

- (void)dealloc {
    [messageLabel release];
    [super dealloc];
}
@end
