/*
 * InputFileParser.cpp
 *
 *  Created on: 31.05.2010
 *      Author: ingmar
 */

#include "InputFileParser.h"
#include "Poco/FileStream.h"
#include "Poco/StringTokenizer.h"
#include <iostream>

#include "Auftrag.h"

using Poco::FileInputStream;
using Poco::StringTokenizer;

InputFileParser::InputFileParser(File* inputFile): inputFile(inputFile), walzfolge(NULL) {

}


InputFileParser::~InputFileParser() {
}

Walzfolge* InputFileParser::getWalzfolge() {
	if (walzfolge == NULL) {
		walzfolge = new Walzfolge();
		FileInputStream fis(inputFile->path());
		std::string sLine;

		//read the first line to build index map
		std::getline(fis, sLine);
		StringTokenizer st(sLine,";", StringTokenizer::TOK_TRIM);
		int pos = 0;
		for(StringTokenizer::Iterator it = st.begin(); it != st.end(); it++ ) {
			indexMap[*it] = pos;
			pos++;
		}

		int linenumber = 2;
		while (std::getline(fis, sLine).good()) {
			StringTokenizer st(sLine,";", StringTokenizer::TOK_TRIM);
			if (st.count() != 41) {
				std::cerr << "warning: error while reading line " << linenumber << " in input file. wrong number of tokens" << std::endl;
				continue;
			} else {
				Auftrag* auftrag = new Auftrag();
				auftrag->anzahlRinge = atoi(st[indexMap["PSMNG"]].c_str());
				auftrag->aufweitdorn = st[indexMap["Z_TR_AWD"]].empty() ? -1 : atoi(st[indexMap["Z_TR_AWD"]].c_str());
				auftrag->aufweitsattel = st[indexMap["Z_TR_AWS"]];
				auftrag->gesenk = st[indexMap["Z_TR_FGESENK"]];
				auftrag->hbno = st[indexMap["Z_HBN"]].compare("W") == 0 ? true : false;
				auftrag->lochdorn = atoi(st[indexMap["Z_LDO"]].c_str());
				auftrag->lochscheibenDurchmesser = atoi(st[indexMap["Z_TR_DL"]].c_str());
				auftrag->nummer = atoi(st[indexMap["AUFNR"]].c_str());
				auftrag->ringDurchmesser = atoi(st[indexMap["Z_TR_RADMR"]].c_str());
				auftrag->ringFormat = atoi(st[indexMap["Z_DMR_NBL"]].c_str());
				auftrag->ringHoehe = atoi(st[indexMap["Z_TR_RHOEHE"]].c_str());
				auftrag->ringMasse = atoi(st[indexMap["Z_VMASSE"]].c_str());
				auftrag->sortiment = ermittleSortiment(st[indexMap["Z_KMATNR"]]);
				auftrag->tastrollen = st[indexMap["Z_TR_ROLLE"]];
				auftrag->walzdorn =  st[indexMap["Z_TR_WD"]].empty() ? -1 : atoi(st[indexMap["Z_TR_WD"]].c_str());
				auftrag->walze = st[indexMap["Z_PRW"]].empty() ? -1 : atoi(st[indexMap["Z_PRW"]].c_str());
				std::string wz = st[indexMap["Z_WZEIT"]];
				auftrag->walzZeit = atof(wz.replace(wz.find(","),1 ,".").c_str());
				auftrag->zentrierrollen = st[indexMap["Z_TR_ZROLLE"]].empty() ? -1 : atoi(st[indexMap["Z_TR_ZROLLE"]].c_str());
				walzfolge->auftraege.push_back(auftrag);
			}
			linenumber++;
		}
	}
	return walzfolge;
}

Sortiment InputFileParser::ermittleSortiment(std::string sortimentName) {
	if (sortimentName.compare("RING") == 0)
		return Ringe;
	if (sortimentName.compare("RADREIFEN") == 0)
		return Radreifen;
	if (sortimentName.compare("FLANSCH") == 0)
		return Flansche;
	if (sortimentName.compare("") == 0)
		return HochlegierteFlansche;
	if (sortimentName.compare("") == 0)
		return HochlegierteRingeMartensite;
	if (sortimentName.compare("") == 0)
		return HochlegierteRingeAustenite;
	return 	Ringe;

}
